package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import org.joda.time.DateTime;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class V1ObjectMetaFluentImpl<A extends V1ObjectMetaFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ObjectMetaFluent<A>{

    private Map<String,String> annotations;
    private String clusterName;
    private DateTime creationTimestamp;
    private Long deletionGracePeriodSeconds;
    private DateTime deletionTimestamp;
    private List<String> finalizers;
    private String generateName;
    private Long generation;
    private Map<String,String> labels;
    private List<V1ManagedFieldsEntryBuilder> managedFields;
    private String name;
    private String namespace;
    private List<V1OwnerReferenceBuilder> ownerReferences;
    private String resourceVersion;
    private String selfLink;
    private String uid;

    public V1ObjectMetaFluentImpl(){
    }
    public V1ObjectMetaFluentImpl(V1ObjectMeta instance){
            this.withAnnotations(instance.getAnnotations());

            this.withClusterName(instance.getClusterName());

            this.withCreationTimestamp(instance.getCreationTimestamp());

            this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());

            this.withDeletionTimestamp(instance.getDeletionTimestamp());

            this.withFinalizers(instance.getFinalizers());

            this.withGenerateName(instance.getGenerateName());

            this.withGeneration(instance.getGeneration());

            this.withLabels(instance.getLabels());

            this.withManagedFields(instance.getManagedFields());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withOwnerReferences(instance.getOwnerReferences());

            this.withResourceVersion(instance.getResourceVersion());

            this.withSelfLink(instance.getSelfLink());

            this.withUid(instance.getUid());

    }

    public A addToAnnotations(String key,String value){
            if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map){
            if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
            if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key){
            if(this.annotations == null) { return (A) this; }
            if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map){
            if(this.annotations == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotations(){
            return this.annotations;
    }

    public A withAnnotations(Map<String,String> annotations){
            if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations(){
            return this.annotations != null;
    }

    public String getClusterName(){
            return this.clusterName;
    }

    public A withClusterName(String clusterName){
            this.clusterName=clusterName; return (A) this;
    }

    public Boolean hasClusterName(){
            return this.clusterName != null;
    }

    public A withNewClusterName(String arg1){
            return (A)withClusterName(new String(arg1));
    }

    public A withNewClusterName(StringBuilder arg1){
            return (A)withClusterName(new String(arg1));
    }

    public A withNewClusterName(StringBuffer arg1){
            return (A)withClusterName(new String(arg1));
    }

    public DateTime getCreationTimestamp(){
            return this.creationTimestamp;
    }

    public A withCreationTimestamp(DateTime creationTimestamp){
            this.creationTimestamp=creationTimestamp; return (A) this;
    }

    public Boolean hasCreationTimestamp(){
            return this.creationTimestamp != null;
    }

    public A withNewCreationTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withCreationTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewCreationTimestamp(Object arg0){
            return (A)withCreationTimestamp(new DateTime(arg0));
    }

    public A withNewCreationTimestamp(long arg0){
            return (A)withCreationTimestamp(new DateTime(arg0));
    }

    public Long getDeletionGracePeriodSeconds(){
            return this.deletionGracePeriodSeconds;
    }

    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds){
            this.deletionGracePeriodSeconds=deletionGracePeriodSeconds; return (A) this;
    }

    public Boolean hasDeletionGracePeriodSeconds(){
            return this.deletionGracePeriodSeconds != null;
    }

    public DateTime getDeletionTimestamp(){
            return this.deletionTimestamp;
    }

    public A withDeletionTimestamp(DateTime deletionTimestamp){
            this.deletionTimestamp=deletionTimestamp; return (A) this;
    }

    public Boolean hasDeletionTimestamp(){
            return this.deletionTimestamp != null;
    }

    public A withNewDeletionTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withDeletionTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewDeletionTimestamp(Object arg0){
            return (A)withDeletionTimestamp(new DateTime(arg0));
    }

    public A withNewDeletionTimestamp(long arg0){
            return (A)withDeletionTimestamp(new DateTime(arg0));
    }

    public A addToFinalizers(int index,String item){
            if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
            this.finalizers.add(index, item);
            return (A)this;
    }

    public A setToFinalizers(int index,String item){
            if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
            this.finalizers.set(index, item); return (A)this;
    }

    public A addToFinalizers(String... items){
            if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
            for (String item : items) {this.finalizers.add(item);} return (A)this;
    }

    public A addAllToFinalizers(Collection<String> items){
            if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
            for (String item : items) {this.finalizers.add(item);} return (A)this;
    }

    public A removeFromFinalizers(String... items){
            for (String item : items) {if (this.finalizers!= null){ this.finalizers.remove(item);}} return (A)this;
    }

    public A removeAllFromFinalizers(Collection<String> items){
            for (String item : items) {if (this.finalizers!= null){ this.finalizers.remove(item);}} return (A)this;
    }

    public List<String> getFinalizers(){
            return this.finalizers;
    }

    public String getFinalizer(int index){
            return this.finalizers.get(index);
    }

    public String getFirstFinalizer(){
            return this.finalizers.get(0);
    }

    public String getLastFinalizer(){
            return this.finalizers.get(finalizers.size() - 1);
    }

    public String getMatchingFinalizer(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: finalizers) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingFinalizer(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: finalizers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withFinalizers(List<String> finalizers){
            if (this.finalizers != null) { _visitables.get("finalizers").removeAll(this.finalizers);}
            if (finalizers != null) {this.finalizers = new ArrayList<String>(); for (String item : finalizers){this.addToFinalizers(item);}} else { this.finalizers = null;} return (A) this;
    }

    public A withFinalizers(String... finalizers){
            if (this.finalizers != null) {this.finalizers.clear();}
            if (finalizers != null) {for (String item :finalizers){ this.addToFinalizers(item);}} return (A) this;
    }

    public Boolean hasFinalizers(){
            return finalizers != null && !finalizers.isEmpty();
    }

    public A addNewFinalizer(String arg1){
            return (A)addToFinalizers(new String(arg1));
    }

    public A addNewFinalizer(StringBuilder arg1){
            return (A)addToFinalizers(new String(arg1));
    }

    public A addNewFinalizer(StringBuffer arg1){
            return (A)addToFinalizers(new String(arg1));
    }

    public String getGenerateName(){
            return this.generateName;
    }

    public A withGenerateName(String generateName){
            this.generateName=generateName; return (A) this;
    }

    public Boolean hasGenerateName(){
            return this.generateName != null;
    }

    public A withNewGenerateName(String arg1){
            return (A)withGenerateName(new String(arg1));
    }

    public A withNewGenerateName(StringBuilder arg1){
            return (A)withGenerateName(new String(arg1));
    }

    public A withNewGenerateName(StringBuffer arg1){
            return (A)withGenerateName(new String(arg1));
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation != null;
    }

    public A addToLabels(String key,String value){
            if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(this.labels == null) { return (A) this; }
            if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(this.labels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.labels != null;
    }

    public A addToManagedFields(int index,V1ManagedFieldsEntry item){
            if (this.managedFields == null) {this.managedFields = new ArrayList<V1ManagedFieldsEntryBuilder>();}
            V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").add(index >= 0 ? index : _visitables.get("managedFields").size(), builder);this.managedFields.add(index >= 0 ? index : managedFields.size(), builder); return (A)this;
    }

    public A setToManagedFields(int index,V1ManagedFieldsEntry item){
            if (this.managedFields == null) {this.managedFields = new ArrayList<V1ManagedFieldsEntryBuilder>();}
            V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);
            if (index < 0 || index >= _visitables.get("managedFields").size()) { _visitables.get("managedFields").add(builder); } else { _visitables.get("managedFields").set(index, builder);}
            if (index < 0 || index >= managedFields.size()) { managedFields.add(builder); } else { managedFields.set(index, builder);}
             return (A)this;
    }

    public A addToManagedFields(V1ManagedFieldsEntry... items){
            if (this.managedFields == null) {this.managedFields = new ArrayList<V1ManagedFieldsEntryBuilder>();}
            for (V1ManagedFieldsEntry item : items) {V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").add(builder);this.managedFields.add(builder);} return (A)this;
    }

    public A addAllToManagedFields(Collection<V1ManagedFieldsEntry> items){
            if (this.managedFields == null) {this.managedFields = new ArrayList<V1ManagedFieldsEntryBuilder>();}
            for (V1ManagedFieldsEntry item : items) {V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").add(builder);this.managedFields.add(builder);} return (A)this;
    }

    public A removeFromManagedFields(V1ManagedFieldsEntry... items){
            for (V1ManagedFieldsEntry item : items) {V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").remove(builder);if (this.managedFields != null) {this.managedFields.remove(builder);}} return (A)this;
    }

    public A removeAllFromManagedFields(Collection<V1ManagedFieldsEntry> items){
            for (V1ManagedFieldsEntry item : items) {V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").remove(builder);if (this.managedFields != null) {this.managedFields.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromManagedFields(io.kubernetes.client.fluent.Predicate<V1ManagedFieldsEntryBuilder> predicate){
            if (managedFields == null) return (A) this;
            final Iterator<V1ManagedFieldsEntryBuilder> each = managedFields.iterator();
            final List visitables = _visitables.get("managedFields");
            while (each.hasNext()) {
              V1ManagedFieldsEntryBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildManagedFields instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ManagedFieldsEntry> getManagedFields(){
            return build(managedFields);
    }

    public List<V1ManagedFieldsEntry> buildManagedFields(){
            return build(managedFields);
    }

    public V1ManagedFieldsEntry buildManagedField(int index){
            return this.managedFields.get(index).build();
    }

    public V1ManagedFieldsEntry buildFirstManagedField(){
            return this.managedFields.get(0).build();
    }

    public V1ManagedFieldsEntry buildLastManagedField(){
            return this.managedFields.get(managedFields.size() - 1).build();
    }

    public V1ManagedFieldsEntry buildMatchingManagedField(io.kubernetes.client.fluent.Predicate<V1ManagedFieldsEntryBuilder> predicate){
            for (V1ManagedFieldsEntryBuilder item: managedFields) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingManagedField(io.kubernetes.client.fluent.Predicate<V1ManagedFieldsEntryBuilder> predicate){
            for (V1ManagedFieldsEntryBuilder item: managedFields) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withManagedFields(List<V1ManagedFieldsEntry> managedFields){
            if (this.managedFields != null) { _visitables.get("managedFields").removeAll(this.managedFields);}
            if (managedFields != null) {this.managedFields = new ArrayList<V1ManagedFieldsEntryBuilder>(); for (V1ManagedFieldsEntry item : managedFields){this.addToManagedFields(item);}} else { this.managedFields = null;} return (A) this;
    }

    public A withManagedFields(V1ManagedFieldsEntry... managedFields){
            if (this.managedFields != null) {this.managedFields.clear();}
            if (managedFields != null) {for (V1ManagedFieldsEntry item :managedFields){ this.addToManagedFields(item);}} return (A) this;
    }

    public Boolean hasManagedFields(){
            return managedFields != null && !managedFields.isEmpty();
    }

    public V1ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedField(){
            return new ManagedFieldsNestedImpl();
    }

    public V1ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedFieldLike(V1ManagedFieldsEntry item){
            return new ManagedFieldsNestedImpl(-1, item);
    }

    public V1ObjectMetaFluent.ManagedFieldsNested<A> setNewManagedFieldLike(int index,V1ManagedFieldsEntry item){
            return new ManagedFieldsNestedImpl(index, item);
    }

    public V1ObjectMetaFluent.ManagedFieldsNested<A> editManagedField(int index){
            if (managedFields.size() <= index) throw new RuntimeException("Can't edit managedFields. Index exceeds size.");
            return setNewManagedFieldLike(index, buildManagedField(index));
    }

    public V1ObjectMetaFluent.ManagedFieldsNested<A> editFirstManagedField(){
            if (managedFields.size() == 0) throw new RuntimeException("Can't edit first managedFields. The list is empty.");
            return setNewManagedFieldLike(0, buildManagedField(0));
    }

    public V1ObjectMetaFluent.ManagedFieldsNested<A> editLastManagedField(){
            int index = managedFields.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last managedFields. The list is empty.");
            return setNewManagedFieldLike(index, buildManagedField(index));
    }

    public V1ObjectMetaFluent.ManagedFieldsNested<A> editMatchingManagedField(io.kubernetes.client.fluent.Predicate<V1ManagedFieldsEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<managedFields.size();i++) { 
            if (predicate.apply(managedFields.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching managedFields. No match found.");
            return setNewManagedFieldLike(index, buildManagedField(index));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace(){
            return this.namespace != null;
    }

    public A withNewNamespace(String arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A addToOwnerReferences(int index,V1OwnerReference item){
            if (this.ownerReferences == null) {this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();}
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);_visitables.get("ownerReferences").add(index >= 0 ? index : _visitables.get("ownerReferences").size(), builder);this.ownerReferences.add(index >= 0 ? index : ownerReferences.size(), builder); return (A)this;
    }

    public A setToOwnerReferences(int index,V1OwnerReference item){
            if (this.ownerReferences == null) {this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();}
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            if (index < 0 || index >= _visitables.get("ownerReferences").size()) { _visitables.get("ownerReferences").add(builder); } else { _visitables.get("ownerReferences").set(index, builder);}
            if (index < 0 || index >= ownerReferences.size()) { ownerReferences.add(builder); } else { ownerReferences.set(index, builder);}
             return (A)this;
    }

    public A addToOwnerReferences(V1OwnerReference... items){
            if (this.ownerReferences == null) {this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();}
            for (V1OwnerReference item : items) {V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);_visitables.get("ownerReferences").add(builder);this.ownerReferences.add(builder);} return (A)this;
    }

    public A addAllToOwnerReferences(Collection<V1OwnerReference> items){
            if (this.ownerReferences == null) {this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>();}
            for (V1OwnerReference item : items) {V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);_visitables.get("ownerReferences").add(builder);this.ownerReferences.add(builder);} return (A)this;
    }

    public A removeFromOwnerReferences(V1OwnerReference... items){
            for (V1OwnerReference item : items) {V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);_visitables.get("ownerReferences").remove(builder);if (this.ownerReferences != null) {this.ownerReferences.remove(builder);}} return (A)this;
    }

    public A removeAllFromOwnerReferences(Collection<V1OwnerReference> items){
            for (V1OwnerReference item : items) {V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);_visitables.get("ownerReferences").remove(builder);if (this.ownerReferences != null) {this.ownerReferences.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOwnerReferences(io.kubernetes.client.fluent.Predicate<V1OwnerReferenceBuilder> predicate){
            if (ownerReferences == null) return (A) this;
            final Iterator<V1OwnerReferenceBuilder> each = ownerReferences.iterator();
            final List visitables = _visitables.get("ownerReferences");
            while (each.hasNext()) {
              V1OwnerReferenceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOwnerReferences instead.
 * @return The buildable object.
 */
@Deprecated public List<V1OwnerReference> getOwnerReferences(){
            return build(ownerReferences);
    }

    public List<V1OwnerReference> buildOwnerReferences(){
            return build(ownerReferences);
    }

    public V1OwnerReference buildOwnerReference(int index){
            return this.ownerReferences.get(index).build();
    }

    public V1OwnerReference buildFirstOwnerReference(){
            return this.ownerReferences.get(0).build();
    }

    public V1OwnerReference buildLastOwnerReference(){
            return this.ownerReferences.get(ownerReferences.size() - 1).build();
    }

    public V1OwnerReference buildMatchingOwnerReference(io.kubernetes.client.fluent.Predicate<V1OwnerReferenceBuilder> predicate){
            for (V1OwnerReferenceBuilder item: ownerReferences) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingOwnerReference(io.kubernetes.client.fluent.Predicate<V1OwnerReferenceBuilder> predicate){
            for (V1OwnerReferenceBuilder item: ownerReferences) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withOwnerReferences(List<V1OwnerReference> ownerReferences){
            if (this.ownerReferences != null) { _visitables.get("ownerReferences").removeAll(this.ownerReferences);}
            if (ownerReferences != null) {this.ownerReferences = new ArrayList<V1OwnerReferenceBuilder>(); for (V1OwnerReference item : ownerReferences){this.addToOwnerReferences(item);}} else { this.ownerReferences = null;} return (A) this;
    }

    public A withOwnerReferences(V1OwnerReference... ownerReferences){
            if (this.ownerReferences != null) {this.ownerReferences.clear();}
            if (ownerReferences != null) {for (V1OwnerReference item :ownerReferences){ this.addToOwnerReferences(item);}} return (A) this;
    }

    public Boolean hasOwnerReferences(){
            return ownerReferences != null && !ownerReferences.isEmpty();
    }

    public V1ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference(){
            return new OwnerReferencesNestedImpl();
    }

    public V1ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(V1OwnerReference item){
            return new OwnerReferencesNestedImpl(-1, item);
    }

    public V1ObjectMetaFluent.OwnerReferencesNested<A> setNewOwnerReferenceLike(int index,V1OwnerReference item){
            return new OwnerReferencesNestedImpl(index, item);
    }

    public V1ObjectMetaFluent.OwnerReferencesNested<A> editOwnerReference(int index){
            if (ownerReferences.size() <= index) throw new RuntimeException("Can't edit ownerReferences. Index exceeds size.");
            return setNewOwnerReferenceLike(index, buildOwnerReference(index));
    }

    public V1ObjectMetaFluent.OwnerReferencesNested<A> editFirstOwnerReference(){
            if (ownerReferences.size() == 0) throw new RuntimeException("Can't edit first ownerReferences. The list is empty.");
            return setNewOwnerReferenceLike(0, buildOwnerReference(0));
    }

    public V1ObjectMetaFluent.OwnerReferencesNested<A> editLastOwnerReference(){
            int index = ownerReferences.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ownerReferences. The list is empty.");
            return setNewOwnerReferenceLike(index, buildOwnerReference(index));
    }

    public V1ObjectMetaFluent.OwnerReferencesNested<A> editMatchingOwnerReference(io.kubernetes.client.fluent.Predicate<V1OwnerReferenceBuilder> predicate){
            int index = -1;
            for (int i=0;i<ownerReferences.size();i++) { 
            if (predicate.apply(ownerReferences.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ownerReferences. No match found.");
            return setNewOwnerReferenceLike(index, buildOwnerReference(index));
    }

    public String getResourceVersion(){
            return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion){
            this.resourceVersion=resourceVersion; return (A) this;
    }

    public Boolean hasResourceVersion(){
            return this.resourceVersion != null;
    }

    public A withNewResourceVersion(String arg1){
            return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuilder arg1){
            return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuffer arg1){
            return (A)withResourceVersion(new String(arg1));
    }

    public String getSelfLink(){
            return this.selfLink;
    }

    public A withSelfLink(String selfLink){
            this.selfLink=selfLink; return (A) this;
    }

    public Boolean hasSelfLink(){
            return this.selfLink != null;
    }

    public A withNewSelfLink(String arg1){
            return (A)withSelfLink(new String(arg1));
    }

    public A withNewSelfLink(StringBuilder arg1){
            return (A)withSelfLink(new String(arg1));
    }

    public A withNewSelfLink(StringBuffer arg1){
            return (A)withSelfLink(new String(arg1));
    }

    public String getUid(){
            return this.uid;
    }

    public A withUid(String uid){
            this.uid=uid; return (A) this;
    }

    public Boolean hasUid(){
            return this.uid != null;
    }

    public A withNewUid(String arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1){
            return (A)withUid(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1ObjectMetaFluentImpl that = (V1ObjectMetaFluentImpl) o;
            if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
            if (clusterName != null ? !clusterName.equals(that.clusterName) :that.clusterName != null) return false;
            if (creationTimestamp != null ? !creationTimestamp.equals(that.creationTimestamp) :that.creationTimestamp != null) return false;
            if (deletionGracePeriodSeconds != null ? !deletionGracePeriodSeconds.equals(that.deletionGracePeriodSeconds) :that.deletionGracePeriodSeconds != null) return false;
            if (deletionTimestamp != null ? !deletionTimestamp.equals(that.deletionTimestamp) :that.deletionTimestamp != null) return false;
            if (finalizers != null ? !finalizers.equals(that.finalizers) :that.finalizers != null) return false;
            if (generateName != null ? !generateName.equals(that.generateName) :that.generateName != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (managedFields != null ? !managedFields.equals(that.managedFields) :that.managedFields != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            if (ownerReferences != null ? !ownerReferences.equals(that.ownerReferences) :that.ownerReferences != null) return false;
            if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
            if (selfLink != null ? !selfLink.equals(that.selfLink) :that.selfLink != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            return true;
    }


    public class ManagedFieldsNestedImpl<N> extends V1ManagedFieldsEntryFluentImpl<V1ObjectMetaFluent.ManagedFieldsNested<N>> implements V1ObjectMetaFluent.ManagedFieldsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ManagedFieldsEntryBuilder builder;
        private final int index;
    
            ManagedFieldsNestedImpl(int index,V1ManagedFieldsEntry item){
                    this.index = index;
                    this.builder = new V1ManagedFieldsEntryBuilder(this, item);
            }
            ManagedFieldsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1ManagedFieldsEntryBuilder(this);
            }
    
    public N and(){
            return (N) V1ObjectMetaFluentImpl.this.setToManagedFields(index,builder.build());
    }
    public N endManagedField(){
            return and();
    }

}
    public class OwnerReferencesNestedImpl<N> extends V1OwnerReferenceFluentImpl<V1ObjectMetaFluent.OwnerReferencesNested<N>> implements V1ObjectMetaFluent.OwnerReferencesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1OwnerReferenceBuilder builder;
        private final int index;
    
            OwnerReferencesNestedImpl(int index,V1OwnerReference item){
                    this.index = index;
                    this.builder = new V1OwnerReferenceBuilder(this, item);
            }
            OwnerReferencesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1OwnerReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1ObjectMetaFluentImpl.this.setToOwnerReferences(index,builder.build());
    }
    public N endOwnerReference(){
            return and();
    }

}


}
