package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1TopologySpreadConstraintBuilder extends V1TopologySpreadConstraintFluentImpl<V1TopologySpreadConstraintBuilder> implements VisitableBuilder<V1TopologySpreadConstraint,V1TopologySpreadConstraintBuilder>{

    V1TopologySpreadConstraintFluent<?> fluent;
    Boolean validationEnabled;

    public V1TopologySpreadConstraintBuilder(){
            this(true);
    }
    public V1TopologySpreadConstraintBuilder(Boolean validationEnabled){
            this(new V1TopologySpreadConstraint(), validationEnabled);
    }
    public V1TopologySpreadConstraintBuilder(V1TopologySpreadConstraintFluent<?> fluent){
            this(fluent, true);
    }
    public V1TopologySpreadConstraintBuilder(V1TopologySpreadConstraintFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1TopologySpreadConstraint(), validationEnabled);
    }
    public V1TopologySpreadConstraintBuilder(V1TopologySpreadConstraintFluent<?> fluent,V1TopologySpreadConstraint instance){
            this(fluent, instance, true);
    }
    public V1TopologySpreadConstraintBuilder(V1TopologySpreadConstraintFluent<?> fluent,V1TopologySpreadConstraint instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLabelSelector(instance.getLabelSelector());

            fluent.withMaxSkew(instance.getMaxSkew());

            fluent.withTopologyKey(instance.getTopologyKey());

            fluent.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());

            this.validationEnabled = validationEnabled; 
    }
    public V1TopologySpreadConstraintBuilder(V1TopologySpreadConstraint instance){
            this(instance,true);
    }
    public V1TopologySpreadConstraintBuilder(V1TopologySpreadConstraint instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLabelSelector(instance.getLabelSelector());

            this.withMaxSkew(instance.getMaxSkew());

            this.withTopologyKey(instance.getTopologyKey());

            this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());

            this.validationEnabled = validationEnabled; 
    }

    public V1TopologySpreadConstraint build(){
            V1TopologySpreadConstraint buildable = new V1TopologySpreadConstraint();
            buildable.setLabelSelector(fluent.getLabelSelector());
            buildable.setMaxSkew(fluent.getMaxSkew());
            buildable.setTopologyKey(fluent.getTopologyKey());
            buildable.setWhenUnsatisfiable(fluent.getWhenUnsatisfiable());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1TopologySpreadConstraintBuilder that = (V1TopologySpreadConstraintBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
