package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1EndpointConditionsBuilder extends V1alpha1EndpointConditionsFluentImpl<V1alpha1EndpointConditionsBuilder> implements VisitableBuilder<V1alpha1EndpointConditions,V1alpha1EndpointConditionsBuilder>{

    V1alpha1EndpointConditionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1EndpointConditionsBuilder(){
            this(true);
    }
    public V1alpha1EndpointConditionsBuilder(Boolean validationEnabled){
            this(new V1alpha1EndpointConditions(), validationEnabled);
    }
    public V1alpha1EndpointConditionsBuilder(V1alpha1EndpointConditionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1EndpointConditionsBuilder(V1alpha1EndpointConditionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1EndpointConditions(), validationEnabled);
    }
    public V1alpha1EndpointConditionsBuilder(V1alpha1EndpointConditionsFluent<?> fluent,V1alpha1EndpointConditions instance){
            this(fluent, instance, true);
    }
    public V1alpha1EndpointConditionsBuilder(V1alpha1EndpointConditionsFluent<?> fluent,V1alpha1EndpointConditions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReady(instance.getReady());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1EndpointConditionsBuilder(V1alpha1EndpointConditions instance){
            this(instance,true);
    }
    public V1alpha1EndpointConditionsBuilder(V1alpha1EndpointConditions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReady(instance.getReady());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1EndpointConditions build(){
            V1alpha1EndpointConditions buildable = new V1alpha1EndpointConditions();
            buildable.setReady(fluent.isReady());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1EndpointConditionsBuilder that = (V1alpha1EndpointConditionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
