package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PodPresetListBuilder extends V1alpha1PodPresetListFluentImpl<V1alpha1PodPresetListBuilder> implements VisitableBuilder<V1alpha1PodPresetList,V1alpha1PodPresetListBuilder>{

    V1alpha1PodPresetListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PodPresetListBuilder(){
            this(true);
    }
    public V1alpha1PodPresetListBuilder(Boolean validationEnabled){
            this(new V1alpha1PodPresetList(), validationEnabled);
    }
    public V1alpha1PodPresetListBuilder(V1alpha1PodPresetListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PodPresetListBuilder(V1alpha1PodPresetListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PodPresetList(), validationEnabled);
    }
    public V1alpha1PodPresetListBuilder(V1alpha1PodPresetListFluent<?> fluent,V1alpha1PodPresetList instance){
            this(fluent, instance, true);
    }
    public V1alpha1PodPresetListBuilder(V1alpha1PodPresetListFluent<?> fluent,V1alpha1PodPresetList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PodPresetListBuilder(V1alpha1PodPresetList instance){
            this(instance,true);
    }
    public V1alpha1PodPresetListBuilder(V1alpha1PodPresetList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PodPresetList build(){
            V1alpha1PodPresetList buildable = new V1alpha1PodPresetList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PodPresetListBuilder that = (V1alpha1PodPresetListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
