package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1RoleListFluentImpl<A extends V1alpha1RoleListFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1RoleListFluent<A>{

    private String apiVersion;
    private List<V1alpha1RoleBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public V1alpha1RoleListFluentImpl(){
    }
    public V1alpha1RoleListFluentImpl(V1alpha1RoleList instance){
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,V1alpha1Role item){
            if (this.items == null) {this.items = new ArrayList<V1alpha1RoleBuilder>();}
            V1alpha1RoleBuilder builder = new V1alpha1RoleBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,V1alpha1Role item){
            if (this.items == null) {this.items = new ArrayList<V1alpha1RoleBuilder>();}
            V1alpha1RoleBuilder builder = new V1alpha1RoleBuilder(item);
            if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(V1alpha1Role... items){
            if (this.items == null) {this.items = new ArrayList<V1alpha1RoleBuilder>();}
            for (V1alpha1Role item : items) {V1alpha1RoleBuilder builder = new V1alpha1RoleBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<V1alpha1Role> items){
            if (this.items == null) {this.items = new ArrayList<V1alpha1RoleBuilder>();}
            for (V1alpha1Role item : items) {V1alpha1RoleBuilder builder = new V1alpha1RoleBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(V1alpha1Role... items){
            for (V1alpha1Role item : items) {V1alpha1RoleBuilder builder = new V1alpha1RoleBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<V1alpha1Role> items){
            for (V1alpha1Role item : items) {V1alpha1RoleBuilder builder = new V1alpha1RoleBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(io.kubernetes.client.fluent.Predicate<V1alpha1RoleBuilder> predicate){
            if (items == null) return (A) this;
            final Iterator<V1alpha1RoleBuilder> each = items.iterator();
            final List visitables = _visitables.get("items");
            while (each.hasNext()) {
              V1alpha1RoleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Role> getItems(){
            return build(items);
    }

    public List<V1alpha1Role> buildItems(){
            return build(items);
    }

    public V1alpha1Role buildItem(int index){
            return this.items.get(index).build();
    }

    public V1alpha1Role buildFirstItem(){
            return this.items.get(0).build();
    }

    public V1alpha1Role buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public V1alpha1Role buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1alpha1RoleBuilder> predicate){
            for (V1alpha1RoleBuilder item: items) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1alpha1RoleBuilder> predicate){
            for (V1alpha1RoleBuilder item: items) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withItems(List<V1alpha1Role> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<V1alpha1RoleBuilder>(); for (V1alpha1Role item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(V1alpha1Role... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (V1alpha1Role item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public V1alpha1RoleListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public V1alpha1RoleListFluent.ItemsNested<A> addNewItemLike(V1alpha1Role item){
            return new ItemsNestedImpl(-1, item);
    }

    public V1alpha1RoleListFluent.ItemsNested<A> setNewItemLike(int index,V1alpha1Role item){
            return new ItemsNestedImpl(index, item);
    }

    public V1alpha1RoleListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1alpha1RoleListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public V1alpha1RoleListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1alpha1RoleListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1alpha1RoleBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ListMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ListMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1alpha1RoleListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1alpha1RoleListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1alpha1RoleListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1alpha1RoleListFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ListMetaBuilder().build());
    }

    public V1alpha1RoleListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1alpha1RoleListFluentImpl that = (V1alpha1RoleListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends V1alpha1RoleFluentImpl<V1alpha1RoleListFluent.ItemsNested<N>> implements V1alpha1RoleListFluent.ItemsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1RoleBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,V1alpha1Role item){
                    this.index = index;
                    this.builder = new V1alpha1RoleBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1RoleBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1RoleListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ListMetaFluentImpl<V1alpha1RoleListFluent.MetadataNested<N>> implements V1alpha1RoleListFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ListMetaBuilder builder;
    
            MetadataNestedImpl(V1ListMeta item){
                    this.builder = new V1ListMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ListMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1RoleListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
