package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CSIDriverSpecBuilder extends V1beta1CSIDriverSpecFluentImpl<V1beta1CSIDriverSpecBuilder> implements VisitableBuilder<V1beta1CSIDriverSpec,V1beta1CSIDriverSpecBuilder>{

    V1beta1CSIDriverSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1CSIDriverSpecBuilder(){
            this(true);
    }
    public V1beta1CSIDriverSpecBuilder(Boolean validationEnabled){
            this(new V1beta1CSIDriverSpec(), validationEnabled);
    }
    public V1beta1CSIDriverSpecBuilder(V1beta1CSIDriverSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1CSIDriverSpecBuilder(V1beta1CSIDriverSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1CSIDriverSpec(), validationEnabled);
    }
    public V1beta1CSIDriverSpecBuilder(V1beta1CSIDriverSpecFluent<?> fluent,V1beta1CSIDriverSpec instance){
            this(fluent, instance, true);
    }
    public V1beta1CSIDriverSpecBuilder(V1beta1CSIDriverSpecFluent<?> fluent,V1beta1CSIDriverSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttachRequired(instance.getAttachRequired());

            fluent.withPodInfoOnMount(instance.getPodInfoOnMount());

            fluent.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1CSIDriverSpecBuilder(V1beta1CSIDriverSpec instance){
            this(instance,true);
    }
    public V1beta1CSIDriverSpecBuilder(V1beta1CSIDriverSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttachRequired(instance.getAttachRequired());

            this.withPodInfoOnMount(instance.getPodInfoOnMount());

            this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1CSIDriverSpec build(){
            V1beta1CSIDriverSpec buildable = new V1beta1CSIDriverSpec();
            buildable.setAttachRequired(fluent.isAttachRequired());
            buildable.setPodInfoOnMount(fluent.isPodInfoOnMount());
            buildable.setVolumeLifecycleModes(fluent.getVolumeLifecycleModes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CSIDriverSpecBuilder that = (V1beta1CSIDriverSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
