package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DaemonSetBuilder extends V1beta2DaemonSetFluentImpl<V1beta2DaemonSetBuilder> implements VisitableBuilder<V1beta2DaemonSet,V1beta2DaemonSetBuilder>{

    V1beta2DaemonSetFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DaemonSetBuilder(){
            this(true);
    }
    public V1beta2DaemonSetBuilder(Boolean validationEnabled){
            this(new V1beta2DaemonSet(), validationEnabled);
    }
    public V1beta2DaemonSetBuilder(V1beta2DaemonSetFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DaemonSetBuilder(V1beta2DaemonSetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DaemonSet(), validationEnabled);
    }
    public V1beta2DaemonSetBuilder(V1beta2DaemonSetFluent<?> fluent,V1beta2DaemonSet instance){
            this(fluent, instance, true);
    }
    public V1beta2DaemonSetBuilder(V1beta2DaemonSetFluent<?> fluent,V1beta2DaemonSet instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DaemonSetBuilder(V1beta2DaemonSet instance){
            this(instance,true);
    }
    public V1beta2DaemonSetBuilder(V1beta2DaemonSet instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DaemonSet build(){
            V1beta2DaemonSet buildable = new V1beta2DaemonSet();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DaemonSetBuilder that = (V1beta2DaemonSetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
