/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointPort represents a Port used by an EndpointSlice")
public class V1alpha1EndpointPort {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private Integer port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    private String protocol;

    public V1alpha1EndpointPort name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of this port. All ports in an EndpointSlice must have a unique name. If the EndpointSlice is dervied from a Kubernetes service, this corresponds to the Service.ports[].name. Name must either be an empty string or pass IANA_SVC_NAME validation: * must be no more than 15 characters long * may contain only [-a-z0-9] * must contain at least one letter [a-z] * it must not start or end with a hyphen, nor contain adjacent hyphens Default is empty string.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha1EndpointPort port(Integer port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The port number of the endpoint. If this is not specified, ports are not restricted and must be interpreted in the context of the specific consumer.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public V1alpha1EndpointPort protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1EndpointPort v1alpha1EndpointPort = (V1alpha1EndpointPort)o;
        return Objects.equals(this.name, v1alpha1EndpointPort.name) && Objects.equals(this.port, v1alpha1EndpointPort.port) && Objects.equals(this.protocol, v1alpha1EndpointPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1EndpointPort {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

