/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1RoleBinding;
import io.kubernetes.client.openapi.models.V1alpha1RoleBindingFluent;
import io.kubernetes.client.openapi.models.V1alpha1RoleRef;
import io.kubernetes.client.openapi.models.V1alpha1RoleRefBuilder;
import io.kubernetes.client.openapi.models.V1alpha1RoleRefFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1Subject;
import io.kubernetes.client.openapi.models.V1alpha1SubjectBuilder;
import io.kubernetes.client.openapi.models.V1alpha1SubjectFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class V1alpha1RoleBindingFluentImpl<A extends V1alpha1RoleBindingFluent<A>>
extends BaseFluent<A>
implements V1alpha1RoleBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1alpha1RoleRefBuilder roleRef;
    private List<V1alpha1SubjectBuilder> subjects;

    public V1alpha1RoleBindingFluentImpl() {
    }

    public V1alpha1RoleBindingFluentImpl(V1alpha1RoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1alpha1RoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1alpha1RoleBindingFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1alpha1RoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1alpha1RoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1alpha1RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1alpha1RoleRef getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public V1alpha1RoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(V1alpha1RoleRef roleRef) {
        this._visitables.get("roleRef").remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new V1alpha1RoleRefBuilder(roleRef);
            this._visitables.get("roleRef").add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public V1alpha1RoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public V1alpha1RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(V1alpha1RoleRef item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public V1alpha1RoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public V1alpha1RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new V1alpha1RoleRefBuilder().build());
    }

    @Override
    public V1alpha1RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(V1alpha1RoleRef item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(int index, V1alpha1Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1alpha1SubjectBuilder>();
        }
        V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);
        this._visitables.get("subjects").add(index >= 0 ? index : this._visitables.get("subjects").size(), builder);
        this.subjects.add(index >= 0 ? index : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(int index, V1alpha1Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1alpha1SubjectBuilder>();
        }
        V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);
        if (index < 0 || index >= this._visitables.get("subjects").size()) {
            this._visitables.get("subjects").add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(V1alpha1Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1alpha1SubjectBuilder>();
        }
        for (V1alpha1Subject item : items) {
            V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<V1alpha1Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<V1alpha1SubjectBuilder>();
        }
        for (V1alpha1Subject item : items) {
            V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(V1alpha1Subject ... items) {
        for (V1alpha1Subject item : items) {
            V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<V1alpha1Subject> items) {
        for (V1alpha1Subject item : items) {
            V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubjects(Predicate<V1alpha1SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<V1alpha1SubjectBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            V1alpha1SubjectBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha1Subject> getSubjects() {
        return V1alpha1RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<V1alpha1Subject> buildSubjects() {
        return V1alpha1RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public V1alpha1Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    @Override
    public V1alpha1Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public V1alpha1Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public V1alpha1Subject buildMatchingSubject(Predicate<V1alpha1SubjectBuilder> predicate) {
        for (V1alpha1SubjectBuilder item : this.subjects) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubject(Predicate<V1alpha1SubjectBuilder> predicate) {
        for (V1alpha1SubjectBuilder item : this.subjects) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjects(List<V1alpha1Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList<V1alpha1SubjectBuilder>();
            for (V1alpha1Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(V1alpha1Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (V1alpha1Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public V1alpha1RoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public V1alpha1RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(V1alpha1Subject item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public V1alpha1RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index, V1alpha1Subject item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public V1alpha1RoleBindingFluent.SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public V1alpha1RoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public V1alpha1RoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public V1alpha1RoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<V1alpha1SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.apply(this.subjects.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1RoleBindingFluentImpl that = (V1alpha1RoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        return !(this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null);
    }

    public class SubjectsNestedImpl<N>
    extends V1alpha1SubjectFluentImpl<V1alpha1RoleBindingFluent.SubjectsNested<N>>
    implements V1alpha1RoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        private final V1alpha1SubjectBuilder builder;
        private final int index;

        SubjectsNestedImpl(int index, V1alpha1Subject item) {
            this.index = index;
            this.builder = new V1alpha1SubjectBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha1SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1RoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends V1alpha1RoleRefFluentImpl<V1alpha1RoleBindingFluent.RoleRefNested<N>>
    implements V1alpha1RoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        private final V1alpha1RoleRefBuilder builder;

        RoleRefNestedImpl(V1alpha1RoleRef item) {
            this.builder = new V1alpha1RoleRefBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new V1alpha1RoleRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1RoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1alpha1RoleBindingFluent.MetadataNested<N>>
    implements V1alpha1RoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1RoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

