/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.models.V1APIGroup;
import io.kubernetes.client.openapi.models.V1APIGroupList;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1APIVersions;
import io.kubernetes.client.util.exception.IncompleteDiscoveryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.Call;

public class Discovery {
    private final ApiClient apiClient;

    public Discovery() {
        this(Configuration.getDefaultApiClient());
    }

    public Discovery(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Set<APIResource> findAll() throws ApiException {
        HashSet<APIResource> allResources = new HashSet<APIResource>();
        for (String version : this.legacyCoreApi().getVersions()) {
            allResources.addAll(this.findAll("", Arrays.asList(version), version, "/api/" + version));
        }
        IncompleteDiscoveryException incompleteDiscoveryException = null;
        for (V1APIGroup group : this.groupDiscovery("/apis").getGroups()) {
            try {
                allResources.addAll(this.findAll(group.getName(), group.getVersions().stream().map(v -> v.getVersion()).collect(Collectors.toList()), group.getPreferredVersion().getVersion()));
            }
            catch (ApiException e) {
                IncompleteDiscoveryException resourceDiscoveryException = new IncompleteDiscoveryException(String.format("Unable to retrieve the complete list of server APIs: %s/%s : %s", group.getName(), group.getPreferredVersion().getVersion(), e.getResponseBody()), e, allResources);
                if (incompleteDiscoveryException == null) {
                    incompleteDiscoveryException = resourceDiscoveryException;
                    continue;
                }
                incompleteDiscoveryException.addSuppressed((Throwable)((Object)resourceDiscoveryException));
            }
        }
        if (incompleteDiscoveryException != null) {
            throw incompleteDiscoveryException;
        }
        return allResources;
    }

    public Set<APIResource> findAll(String group, List<String> versions, String preferredVersion) throws ApiException {
        return this.findAll(group, versions, preferredVersion, "/apis/" + group + "/" + preferredVersion);
    }

    public Set<APIResource> findAll(String group, List<String> versions, String preferredVersion, String path) throws ApiException {
        V1APIResourceList resourceList = this.resourceDiscovery(path);
        return this.groupResourcesByName(group, versions, preferredVersion, resourceList);
    }

    public Set<APIResource> groupResourcesByName(String group, List<String> versions, String preferredVersion, V1APIResourceList resourceList) {
        Set<APIResource> resources = resourceList.getResources().stream().filter(r -> this.getSubResourceNameIfPossible(r.getName()).isEmpty()).map(r -> new APIResource(group, versions, preferredVersion, r.getKind(), r.getNamespaced(), r.getName(), r.getSingularName())).collect(Collectors.toSet());
        Map<String, Set<String>> subResources = this.manageRelationFromResourceToSubResources(resourceList);
        resources.stream().forEach(r -> {
            if (subResources.containsKey(r.getResourcePlural())) {
                r.subResources.addAll((Collection)subResources.get(r.getResourcePlural()));
            }
        });
        return resources;
    }

    private Map<String, Set<String>> manageRelationFromResourceToSubResources(V1APIResourceList resourceList) {
        HashMap<String, Set<String>> subResources = new HashMap<String, Set<String>>();
        resourceList.getResources().stream().forEach(r -> subResources.put(r.getName(), new HashSet()));
        resourceList.getResources().stream().forEach(r -> this.getSubResourceNameIfPossible(r.getName()).ifPresent(subResourceName -> subResources.computeIfAbsent(this.getMajorResourceName(r.getName()), majorResourceName -> new HashSet()).add(subResourceName)));
        return subResources;
    }

    private String getMajorResourceName(String discoveredResourceName) {
        String[] parts = discoveredResourceName.split("/", 2);
        return parts[0];
    }

    private Optional<String> getSubResourceNameIfPossible(String discoveredResourceName) {
        boolean isSubResource = discoveredResourceName.contains("/");
        if (!isSubResource) {
            return Optional.empty();
        }
        String[] parts = discoveredResourceName.split("/", 2);
        return Optional.of(parts[1]);
    }

    public V1APIVersions legacyCoreApi() throws ApiException {
        return this.versionDiscovery("/api");
    }

    public V1APIGroupList groupDiscovery(String path) throws ApiException {
        return this.get(V1APIGroupList.class, path);
    }

    public V1APIVersions versionDiscovery(String path) throws ApiException {
        return this.get(V1APIVersions.class, path);
    }

    public V1APIResourceList resourceDiscovery(String path) throws ApiException {
        return this.get(V1APIResourceList.class, path);
    }

    private <T> T get(Class<T> returnTypeClass, String urlPath) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        Call call = this.apiClient.buildCall(this.apiClient.getBasePath(), urlPath, "GET", Collections.emptyList(), Collections.emptyList(), null, headers, Collections.emptyMap(), Collections.emptyMap(), new String[]{"BearerToken"}, null);
        ApiResponse resourceList = this.apiClient.execute(call, returnTypeClass);
        return (T)resourceList.getData();
    }

    public static class APIResource {
        private final String group;
        private final String kind;
        private final List<String> versions;
        private final String preferredVersion;
        private final Boolean isNamespaced;
        private final String resourcePlural;
        private final String resourceSingular;
        private final List<String> subResources;

        public APIResource(String group, List<String> versions, String preferredVersion, String kind, Boolean isNamespaced, String resourcePlural, String resourceSingular) {
            this.group = group;
            this.versions = versions;
            this.preferredVersion = preferredVersion;
            this.kind = kind;
            this.isNamespaced = isNamespaced;
            this.resourcePlural = resourcePlural;
            this.resourceSingular = resourceSingular;
            this.subResources = new ArrayList<String>();
        }

        public String getGroup() {
            return this.group;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public String getPreferredVersion() {
            return this.preferredVersion;
        }

        public String getKind() {
            return this.kind;
        }

        public Boolean getNamespaced() {
            return this.isNamespaced;
        }

        public String getResourcePlural() {
            return this.resourcePlural;
        }

        public String getResourceSingular() {
            return this.resourceSingular;
        }

        public List<String> getSubResources() {
            return this.subResources;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            APIResource that = (APIResource)o;
            return Objects.equals(this.group, that.group) && Objects.equals(this.kind, that.kind) && Objects.equals(this.versions, that.versions) && Objects.equals(this.preferredVersion, that.preferredVersion) && Objects.equals(this.isNamespaced, that.isNamespaced) && Objects.equals(this.resourcePlural, that.resourcePlural) && Objects.equals(this.resourceSingular, that.resourceSingular) && Objects.equals(this.subResources, that.subResources);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.kind, this.versions, this.preferredVersion, this.isNamespaced, this.resourcePlural, this.resourceSingular, this.subResources);
        }
    }
}

