/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apimachinery;

public enum KubernetesVerb {
    GET("get"),
    LIST("list"),
    CREATE("create"),
    UPDATE("update"),
    DELETE("delete"),
    PATCH("patch"),
    WATCH("watch"),
    DELETE_COLLECTION("deleteCollection");

    private final String value;

    private KubernetesVerb(String value) {
        this.value = value;
    }

    public static KubernetesVerb of(String httpVerb, boolean hasNamePathParam, boolean hasWatchParam) {
        if (hasWatchParam) {
            return WATCH;
        }
        switch (httpVerb) {
            case "GET": {
                if (!hasNamePathParam) {
                    return LIST;
                }
                return GET;
            }
            case "POST": {
                return CREATE;
            }
            case "PUT": {
                return UPDATE;
            }
            case "PATCH": {
                return PATCH;
            }
            case "DELETE": {
                if (!hasNamePathParam) {
                    return DELETE_COLLECTION;
                }
                return DELETE;
            }
        }
        throw new IllegalArgumentException("invalid HTTP verb for kubernetes client");
    }

    public String value() {
        return this.value;
    }
}

