/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import io.kubernetes.client.util.credentials.RefreshAuthentication;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;

public class TokenFileAuthentication
extends RefreshAuthentication {
    public TokenFileAuthentication(String file) {
        this(file, Duration.ofMinutes(1L));
    }

    public TokenFileAuthentication(String file, Duration refreshPeriod) {
        super(() -> TokenFileAuthentication.getToken(file), refreshPeriod);
    }

    private static String getToken(String file) {
        try {
            return new String(Files.readAllBytes(Paths.get(file, new String[0])), Charset.defaultCharset()).trim();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file: " + file);
        }
    }
}

