/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class SSLUtils {
    public static boolean isNotNullOrEmpty(String val) {
        return val != null && val.length() > 0;
    }

    public static KeyManager[] keyManagers(byte[] certData, byte[] keyData, String algo, String passphrase, String keyStoreFile, String keyStorePassphrase) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, InvalidKeySpecException, IOException {
        KeyManager[] keyManagers = null;
        if (certData != null && keyData != null) {
            KeyStore keyStore = SSLUtils.createKeyStore(certData, keyData, algo, passphrase, keyStoreFile, keyStorePassphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, passphrase.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        return keyManagers;
    }

    /*
     * Exception decompiling
     */
    public static KeyStore createKeyStore(byte[] clientCertData, byte[] clientKeyData, String clientKeyAlgo, String clientKeyPassphrase, String keyStoreFile, String keyStorePassphrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PrivateKey loadKey(InputStream keyInputStream, String clientKeyAlgo) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (clientKeyAlgo.equals("EC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMKeyPair keys = (PEMKeyPair)new PEMParser((Reader)new InputStreamReader(keyInputStream)).readObject();
            return new JcaPEMKeyConverter().getKeyPair(keys).getPrivate();
        }
        byte[] keyBytes = SSLUtils.decodePem(keyInputStream);
        if (clientKeyAlgo.equals("RSA")) {
            RSAPrivateCrtKeySpec keySpec = SSLUtils.decodePKCS1(keyBytes);
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(spec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                return KeyFactory.getInstance("ECDSA").generatePrivate(spec);
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                throw new InvalidKeySpecException("Unknown type of PKCS8 Private Key, tried RSA and ECDSA");
            }
        }
    }

    public static KeyStore createKeyStore(InputStream certInputStream, InputStream keyInputStream, String clientKeyAlgo, char[] clientKeyPassphrase, String keyStoreFile, char[] keyStorePassphrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        Collection<? extends Certificate> certs = certFactory.generateCertificates(certInputStream);
        Certificate[] certsArray = certs.toArray(new X509Certificate[0]);
        PrivateKey privateKey = SSLUtils.loadKey(keyInputStream, clientKeyAlgo);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        if (keyStoreFile != null && keyStoreFile.length() > 0) {
            keyStore.load(new FileInputStream(keyStoreFile), keyStorePassphrase);
        } else {
            SSLUtils.loadDefaultKeyStoreFile(keyStore, keyStorePassphrase);
        }
        String alias = certsArray[0].getSubjectX500Principal().getName();
        keyStore.setKeyEntry(alias, privateKey, clientKeyPassphrase, certsArray);
        return keyStore;
    }

    private static byte[] decodePem(InputStream keyInputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(keyInputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("-----BEGIN ")) continue;
                byte[] byArray = SSLUtils.readBytes(reader, line.trim().replace("BEGIN", "END"));
                return byArray;
            }
            throw new IOException("PEM is invalid: no begin marker");
        }
    }

    private static byte[] readBytes(BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) {
                return Base64.decodeBase64((String)buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException("PEM is invalid : No end marker");
    }

    public static RSAPrivateCrtKeySpec decodePKCS1(byte[] keyBytes) throws IOException {
        DerParser parser = new DerParser(keyBytes);
        Asn1Object sequence = parser.read();
        sequence.validateSequence();
        parser = new DerParser(sequence.getValue());
        parser.read();
        return new RSAPrivateCrtKeySpec(SSLUtils.next(parser), SSLUtils.next(parser), SSLUtils.next(parser), SSLUtils.next(parser), SSLUtils.next(parser), SSLUtils.next(parser), SSLUtils.next(parser), SSLUtils.next(parser));
    }

    private static BigInteger next(DerParser parser) throws IOException {
        return parser.read().getInteger();
    }

    private static void loadDefaultKeyStoreFile(KeyStore keyStore, char[] keyStorePassphrase) throws CertificateException, NoSuchAlgorithmException, IOException {
        File keyStoreFile;
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
        if (keyStorePath != null && keyStorePath.length() > 0 && SSLUtils.loadDefaultStoreFile(keyStore, keyStoreFile = new File(keyStorePath), keyStorePassphrase)) {
            return;
        }
        keyStore.load(null);
    }

    private static boolean loadDefaultStoreFile(KeyStore keyStore, File fileToLoad, char[] passphrase) throws CertificateException, NoSuchAlgorithmException, IOException {
        if (fileToLoad.exists() && fileToLoad.isFile() && fileToLoad.length() > 0L) {
            keyStore.load(new FileInputStream(fileToLoad), passphrase);
            return true;
        }
        return false;
    }

    private static char[] getKeyStorePassphrase(String keyStorePassphrase) {
        if (keyStorePassphrase == null || keyStorePassphrase.length() == 0) {
            return System.getProperty("javax.net.ssl.keyStorePassword", "changeit").toCharArray();
        }
        return keyStorePassphrase.toCharArray();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    static class Asn1Object {
        private final int type;
        private final byte[] value;
        private final int tag;

        public Asn1Object(int tag, byte[] value) {
            this.tag = tag;
            this.type = tag & 0x1F;
            this.value = value;
        }

        public byte[] getValue() {
            return this.value;
        }

        BigInteger getInteger() throws IOException {
            if (this.type != 2) {
                throw new IOException("Invalid DER: object is not integer");
            }
            return new BigInteger(this.value);
        }

        void validateSequence() throws IOException {
            if (this.type != 16) {
                throw new IOException("Invalid DER: not a sequence");
            }
            if ((this.tag & 0x20) != 32) {
                throw new IOException("Invalid DER: can't parse primitive entity");
            }
        }
    }

    static class DerParser {
        private InputStream in;

        DerParser(byte[] bytes) throws IOException {
            this.in = new ByteArrayInputStream(bytes);
        }

        Asn1Object read() throws IOException {
            int tag = this.in.read();
            if (tag == -1) {
                throw new IOException("Invalid DER: stream too short, missing tag");
            }
            int length = this.getLength();
            byte[] value = new byte[length];
            if (this.in.read(value) < length) {
                throw new IOException("Invalid DER: stream too short, missing value");
            }
            return new Asn1Object(tag, value);
        }

        private int getLength() throws IOException {
            int i = this.in.read();
            if (i == -1) {
                throw new IOException("Invalid DER: length missing");
            }
            if ((i & 0xFFFFFF80) == 0) {
                return i;
            }
            int num = i & 0x7F;
            if (i >= 255 || num > 4) {
                throw new IOException("Invalid DER: length field too big (" + i + ")");
            }
            byte[] bytes = new byte[num];
            if (this.in.read(bytes) < num) {
                throw new IOException("Invalid DER: length too short");
            }
            return new BigInteger(1, bytes).intValue();
        }
    }
}

