/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.util;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentMultiMap<K, V> {
    private final ConcurrentMap<K, Set<V>> map = new ConcurrentHashMap<K, Set<V>>();

    public synchronized void add(K key, V value) {
        Set set = (Set)this.map.get(key);
        if (set != null) {
            set.add(value);
        } else {
            this.map.put(key, this.createConcurrentSet(value));
        }
    }

    public synchronized void remove(K key, V value) {
        Set set = (Set)this.map.get(key);
        if (set != null) {
            set.remove(value);
            if (set.isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    public boolean contains(K key, V value) {
        return this.get(key).contains(value);
    }

    public Set<V> get(K key) {
        Set set = (Set)this.map.get(key);
        return set == null ? Collections.emptySet() : set;
    }

    protected Set<V> createConcurrentSet(V value) {
        ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
        set.add(value);
        return set;
    }
}

