/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.web;

import graphql.GraphQL;
import io.leangen.graphql.spqr.spring.web.GraphQLExecutor;
import io.leangen.graphql.spqr.spring.web.dto.ExecutorParams;
import io.leangen.graphql.spqr.spring.web.dto.GraphQLRequest;
import io.leangen.graphql.spqr.spring.web.dto.TransportType;
import io.leangen.graphql.util.Utils;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public abstract class GraphQLController<R> {
    protected final GraphQL graphQL;
    protected final GraphQLExecutor<R> executor;

    public GraphQLController(GraphQL graphQL, GraphQLExecutor<R> executor) {
        this.graphQL = graphQL;
        this.executor = executor;
    }

    @PostMapping(value={"${graphql.spqr.http.endpoint:/graphql}"}, consumes={"application/json"}, produces={"application/json"})
    public Object executeJsonPost(@RequestBody GraphQLRequest requestBody, GraphQLRequest requestParams, R request) {
        return this.jsonPost(requestBody, requestParams, request, TransportType.HTTP);
    }

    @PostMapping(value={"${graphql.spqr.http.endpoint:/graphql}"}, produces={"text/event-stream"})
    public Object executeJsonPostEventStream(@RequestBody GraphQLRequest requestBody, GraphQLRequest requestParams, R request) {
        return this.jsonPost(requestBody, requestParams, request, TransportType.HTTP_EVENT_STREAM);
    }

    public Object jsonPost(GraphQLRequest requestBody, GraphQLRequest requestParams, R request, TransportType transportType) {
        String id = Utils.isNotEmpty((String)requestParams.getId()) ? requestParams.getId() : requestBody.getId();
        String query = Utils.isNotEmpty((String)requestParams.getQuery()) ? requestParams.getQuery() : requestBody.getQuery();
        String operationName = Utils.isNotEmpty((String)requestParams.getOperationName()) ? requestParams.getOperationName() : requestBody.getOperationName();
        Map<String, Object> variables = requestParams.getVariables().isEmpty() ? requestBody.getVariables() : requestParams.getVariables();
        ExecutorParams<R> params = new ExecutorParams<R>(new GraphQLRequest(id, query, operationName, variables), request, transportType);
        return this.executor.execute(this.graphQL, params);
    }

    @PostMapping(value={"${graphql.spqr.http.endpoint:/graphql}"}, consumes={"application/graphql", "application/graphql;charset=UTF-8"}, produces={"application/json"})
    public Object executeGraphQLPost(@RequestBody String queryBody, GraphQLRequest originalReq, R request) {
        String query = Utils.isNotEmpty((String)originalReq.getQuery()) ? originalReq.getQuery() : queryBody;
        GraphQLRequest remappedReq = new GraphQLRequest(originalReq.getId(), query, originalReq.getOperationName(), originalReq.getVariables());
        ExecutorParams<R> params = new ExecutorParams<R>(remappedReq, request, TransportType.HTTP);
        return this.executor.execute(this.graphQL, params);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"${graphql.spqr.http.endpoint:/graphql}"}, consumes={"application/x-www-form-urlencoded", "application/x-www-form-urlencoded;charset=UTF-8"}, produces={"application/json"})
    public Object executeFormPost(@RequestParam Map<String, String> queryParams, GraphQLRequest graphQLRequest, R request) {
        String idParam = queryParams.get("id");
        String queryParam = queryParams.get("query");
        String operationNameParam = queryParams.get("operationName");
        String id = Utils.isNotEmpty((String)idParam) ? idParam : graphQLRequest.getId();
        String query = Utils.isNotEmpty((String)queryParam) ? queryParam : graphQLRequest.getQuery();
        String operationName = Utils.isEmpty((String)operationNameParam) ? graphQLRequest.getOperationName() : operationNameParam;
        ExecutorParams<R> params = new ExecutorParams<R>(new GraphQLRequest(id, query, operationName, graphQLRequest.getVariables()), request, TransportType.HTTP);
        return this.executor.execute(this.graphQL, params);
    }

    @GetMapping(value={"${graphql.spqr.http.endpoint:/graphql}"}, produces={"application/json"}, headers={"Connection!=Upgrade", "Connection!=keep-alive, Upgrade", "Connection!=upgrade", "Connection!=keep-alive, upgrade"})
    public Object executeGet(GraphQLRequest graphQLRequest, R request) {
        return this.get(graphQLRequest, request, TransportType.HTTP);
    }

    @GetMapping(value={"${graphql.spqr.http.endpoint:/graphql}"}, produces={"text/event-stream"}, headers={"Connection!=Upgrade", "Connection!=keep-alive, Upgrade", "Connection!=upgrade", "Connection!=keep-alive, upgrade"})
    public Object executeGetEventStream(GraphQLRequest graphQLRequest, R request) {
        return this.get(graphQLRequest, request, TransportType.HTTP_EVENT_STREAM);
    }

    private Object get(GraphQLRequest graphQLRequest, R request, TransportType transportType) {
        return this.executor.execute(this.graphQL, new ExecutorParams<R>(graphQLRequest, request, transportType));
    }
}

