/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionBuilder;
import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.LettuceStrings;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslConnectionBuilder;
import io.lettuce.core.StatefulRedisConnectionImpl;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandExpiryWriter;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.protocol.Endpoint;
import io.lettuce.core.pubsub.PubSubCommandHandler;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnectionImpl;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.sentinel.StatefulRedisSentinelConnectionImpl;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class RedisClient
extends AbstractRedisClient {
    private static final RedisURI EMPTY_URI = new RedisURI();
    private final RedisURI redisURI;

    protected RedisClient(ClientResources clientResources, RedisURI redisURI) {
        super(clientResources);
        RedisClient.assertNotNull(redisURI);
        this.redisURI = redisURI;
        this.setDefaultTimeout(redisURI.getTimeout());
    }

    protected RedisClient() {
        this(null, EMPTY_URI);
    }

    public static RedisClient create() {
        return new RedisClient(null, EMPTY_URI);
    }

    public static RedisClient create(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(null, redisURI);
    }

    public static RedisClient create(String uri) {
        LettuceAssert.notEmpty(uri, "URI must not be empty");
        return new RedisClient(null, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources) {
        RedisClient.assertNotNull(clientResources);
        return new RedisClient(clientResources, EMPTY_URI);
    }

    public static RedisClient create(ClientResources clientResources, String uri) {
        RedisClient.assertNotNull(clientResources);
        LettuceAssert.notEmpty(uri, "URI must not be empty");
        return RedisClient.create(clientResources, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisClient.assertNotNull(clientResources);
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(clientResources, redisURI);
    }

    public StatefulRedisConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.getConnection(this.connectStandaloneAsync(codec, this.redisURI, this.timeout));
    }

    public StatefulRedisConnection<String, String> connect(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.getConnection(this.connectStandaloneAsync(this.newStringStringCodec(), redisURI, redisURI.getTimeout()));
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.getConnection(this.connectStandaloneAsync(codec, redisURI, redisURI.getTimeout()));
    }

    public <K, V> ConnectionFuture<StatefulRedisConnection<K, V>> connectAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return RedisClient.transformAsyncConnectionException(this.connectStandaloneAsync(codec, redisURI, redisURI.getTimeout()));
    }

    private <K, V> ConnectionFuture<StatefulRedisConnection<K, V>> connectStandaloneAsync(RedisCodec<K, V> codec, RedisURI redisURI, Duration timeout) {
        DefaultEndpoint endpoint;
        RedisClient.assertNotNull(codec);
        RedisClient.checkValidRedisURI(redisURI);
        logger.debug("Trying to get a Redis connection for: " + redisURI);
        RedisChannelWriter writer = endpoint = new DefaultEndpoint(this.clientOptions, this.clientResources);
        if (CommandExpiryWriter.isSupported(this.clientOptions)) {
            writer = new CommandExpiryWriter(writer, this.clientOptions, this.clientResources);
        }
        StatefulRedisConnectionImpl connection = this.newStatefulRedisConnection(writer, codec, timeout);
        ConnectionFuture<StatefulRedisConnection<K, V>> future = this.connectStatefulAsync(connection, codec, endpoint, redisURI, () -> new CommandHandler(this.clientOptions, this.clientResources, endpoint));
        future.whenComplete((channelHandler, throwable) -> {
            if (throwable != null) {
                connection.close();
            }
        });
        return future;
    }

    private <K, V, S> ConnectionFuture<S> connectStatefulAsync(StatefulRedisConnectionImpl<K, V> connection, RedisCodec<K, V> codec, Endpoint endpoint, RedisURI redisURI, Supplier<CommandHandler> commandHandlerSupplier) {
        ConnectionFuture future;
        ConnectionBuilder connectionBuilder = this.getConnectionBuilder(endpoint, redisURI, commandHandlerSupplier);
        connectionBuilder.connection(connection);
        CompletionStage sync = future = this.initializeChannelAsync(connectionBuilder);
        if (!this.clientOptions.isPingBeforeActivateConnection() && RedisClient.hasPassword(redisURI)) {
            sync = sync.thenCompose(channelHandler -> {
                CommandArgs args = new CommandArgs(codec).add(redisURI.getPassword());
                return connection.async().dispatch(CommandType.AUTH, new StatusOutput(codec), args);
            });
        }
        if (LettuceStrings.isNotEmpty(redisURI.getClientName())) {
            sync = sync.thenApply(channelHandler -> {
                connection.setClientName(redisURI.getClientName());
                return channelHandler;
            });
        }
        if (redisURI.getDatabase() != 0) {
            sync = sync.thenCompose(channelHandler -> {
                CommandArgs args = new CommandArgs(codec).add(redisURI.getDatabase());
                return connection.async().dispatch(CommandType.SELECT, new StatusOutput(codec), args);
            });
        }
        return sync.thenApply(channelHandler -> connection);
    }

    private <K, V> ConnectionBuilder getConnectionBuilder(Endpoint endpoint, RedisURI redisURI, Supplier<CommandHandler> commandHandlerSupplier) {
        ConnectionBuilder connectionBuilder;
        if (redisURI.isSsl()) {
            SslConnectionBuilder sslConnectionBuilder = SslConnectionBuilder.sslConnectionBuilder();
            sslConnectionBuilder.ssl(redisURI);
            connectionBuilder = sslConnectionBuilder;
        } else {
            connectionBuilder = ConnectionBuilder.connectionBuilder();
        }
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        connectionBuilder.commandHandler(commandHandlerSupplier).endpoint(endpoint);
        this.connectionBuilder(this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        this.channelType(connectionBuilder, redisURI);
        if (this.clientOptions.isPingBeforeActivateConnection()) {
            if (RedisClient.hasPassword(redisURI)) {
                connectionBuilder.enableAuthPingBeforeConnect();
            } else {
                connectionBuilder.enablePingBeforeConnect();
            }
        }
        return connectionBuilder;
    }

    private static boolean hasPassword(RedisURI redisURI) {
        return redisURI.getPassword() != null && redisURI.getPassword().length != 0;
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub() {
        return this.getConnection(this.connectPubSubAsync(this.newStringStringCodec(), this.redisURI, this.timeout));
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.getConnection(this.connectPubSubAsync(this.newStringStringCodec(), redisURI, redisURI.getTimeout()));
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.getConnection(this.connectPubSubAsync(codec, this.redisURI, this.timeout));
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.getConnection(this.connectPubSubAsync(codec, redisURI, redisURI.getTimeout()));
    }

    public <K, V> ConnectionFuture<StatefulRedisPubSubConnection<K, V>> connectPubSubAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return RedisClient.transformAsyncConnectionException(this.connectPubSubAsync(codec, redisURI, redisURI.getTimeout()));
    }

    private <K, V> ConnectionFuture<StatefulRedisPubSubConnection<K, V>> connectPubSubAsync(RedisCodec<K, V> codec, RedisURI redisURI, Duration timeout) {
        PubSubEndpoint endpoint;
        RedisClient.assertNotNull(codec);
        RedisClient.checkValidRedisURI(redisURI);
        RedisChannelWriter writer = endpoint = new PubSubEndpoint(this.clientOptions, this.clientResources);
        if (CommandExpiryWriter.isSupported(this.clientOptions)) {
            writer = new CommandExpiryWriter(writer, this.clientOptions, this.clientResources);
        }
        StatefulRedisPubSubConnectionImpl connection = this.newStatefulRedisPubSubConnection(endpoint, writer, codec, timeout);
        ConnectionFuture future = this.connectStatefulAsync(connection, codec, endpoint, redisURI, () -> new PubSubCommandHandler(this.clientOptions, this.clientResources, codec, endpoint));
        return future.whenComplete((conn, throwable) -> {
            if (throwable != null) {
                conn.close();
            }
        });
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel() {
        return this.connectSentinel(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.getConnection(this.connectSentinelAsync(codec, this.redisURI, this.timeout));
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.getConnection(this.connectSentinelAsync(this.newStringStringCodec(), redisURI, redisURI.getTimeout()));
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return this.getConnection(this.connectSentinelAsync(codec, redisURI, redisURI.getTimeout()));
    }

    public <K, V> CompletableFuture<StatefulRedisSentinelConnection<K, V>> connectSentinelAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return RedisClient.transformAsyncConnectionException(this.connectSentinelAsync(codec, redisURI, redisURI.getTimeout()), redisURI);
    }

    private <K, V> CompletableFuture<StatefulRedisSentinelConnection<K, V>> connectSentinelAsync(RedisCodec<K, V> codec, RedisURI redisURI, Duration timeout) {
        RedisClient.assertNotNull(codec);
        RedisClient.checkValidRedisURI(redisURI);
        logger.debug("Trying to get a Redis Sentinel connection for one of: " + redisURI.getSentinels());
        if (redisURI.getSentinels().isEmpty() && (LettuceStrings.isNotEmpty(redisURI.getHost()) || !LettuceStrings.isEmpty(redisURI.getSocket()))) {
            return this.doConnectSentinelAsync(codec, redisURI.getClientName(), redisURI, timeout).toCompletableFuture();
        }
        List<RedisURI> sentinels = redisURI.getSentinels();
        LinkedBlockingQueue exceptionCollector = new LinkedBlockingQueue();
        RedisClient.validateUrisAreOfSameConnectionType(sentinels);
        Mono connectionLoop = null;
        for (RedisURI uri : sentinels) {
            String clientName = LettuceStrings.isNotEmpty(uri.getClientName()) ? uri.getClientName() : redisURI.getClientName();
            Mono connectionMono = Mono.defer(() -> Mono.fromCompletionStage(this.doConnectSentinelAsync(codec, clientName, uri, timeout))).onErrorMap(CompletionException.class, Throwable::getCause).onErrorMap(e -> new RedisConnectionException("Cannot connect Redis Sentinel at " + uri, (Throwable)e)).doOnError(exceptionCollector::add);
            if (connectionLoop == null) {
                connectionLoop = connectionMono;
                continue;
            }
            connectionLoop = connectionLoop.onErrorResume(t -> connectionMono);
        }
        if (connectionLoop == null) {
            return Mono.error((Throwable)new RedisConnectionException("Cannot connect to a Redis Sentinel: " + redisURI.getSentinels())).toFuture();
        }
        return connectionLoop.onErrorMap(e -> {
            RedisConnectionException ex = new RedisConnectionException("Cannot connect to a Redis Sentinel: " + redisURI.getSentinels(), (Throwable)e);
            for (Throwable throwable : exceptionCollector) {
                if (e == throwable) continue;
                ex.addSuppressed(throwable);
            }
            return ex;
        }).toFuture();
    }

    private <K, V> ConnectionFuture<StatefulRedisSentinelConnection<K, V>> doConnectSentinelAsync(RedisCodec<K, V> codec, String clientName, RedisURI redisURI, Duration timeout) {
        DefaultEndpoint endpoint;
        RedisChannelWriter writer = endpoint = new DefaultEndpoint(this.clientOptions, this.clientResources);
        if (CommandExpiryWriter.isSupported(this.clientOptions)) {
            writer = new CommandExpiryWriter(writer, this.clientOptions, this.clientResources);
        }
        ConnectionBuilder connectionBuilder = this.getConnectionBuilder(endpoint, redisURI, () -> new CommandHandler(this.clientOptions, this.clientResources, endpoint));
        StatefulRedisSentinelConnectionImpl connection = this.newStatefulRedisSentinelConnection(writer, codec, timeout);
        logger.debug("Connecting to Redis Sentinel, address: " + redisURI);
        connectionBuilder.connection(connection);
        this.connectionBuilder(this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        if (this.clientOptions.isPingBeforeActivateConnection()) {
            connectionBuilder.enablePingBeforeConnect();
        }
        this.channelType(connectionBuilder, redisURI);
        CompletionStage sync = this.initializeChannelAsync(connectionBuilder);
        if (!this.clientOptions.isPingBeforeActivateConnection() && RedisClient.hasPassword(redisURI)) {
            sync = sync.thenCompose(channelHandler -> {
                CommandArgs args = new CommandArgs(codec).add(redisURI.getPassword());
                return connection.async().dispatch(CommandType.AUTH, new StatusOutput(codec), args).toCompletableFuture();
            });
        }
        if (LettuceStrings.isNotEmpty(clientName)) {
            sync = sync.thenApply(channelHandler -> {
                connection.setClientName(clientName);
                return channelHandler;
            });
        }
        return sync.thenApply(ignore -> connection).whenComplete((ignore, e) -> {
            if (e != null) {
                logger.warn("Cannot connect Redis Sentinel at " + redisURI + ": " + e.toString());
                connection.close();
            }
        });
    }

    @Override
    public void setOptions(ClientOptions clientOptions) {
        super.setOptions(clientOptions);
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    protected <K, V> StatefulRedisPubSubConnectionImpl<K, V> newStatefulRedisPubSubConnection(PubSubEndpoint<K, V> endpoint, RedisChannelWriter channelWriter, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisPubSubConnectionImpl<K, V>(endpoint, channelWriter, codec, timeout);
    }

    protected <K, V> StatefulRedisSentinelConnectionImpl<K, V> newStatefulRedisSentinelConnection(RedisChannelWriter channelWriter, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisSentinelConnectionImpl<K, V>(channelWriter, codec, timeout);
    }

    protected <K, V> StatefulRedisConnectionImpl<K, V> newStatefulRedisConnection(RedisChannelWriter channelWriter, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisConnectionImpl<K, V>(channelWriter, codec, timeout);
    }

    protected Mono<SocketAddress> getSocketAddress(RedisURI redisURI) {
        return Mono.defer(() -> {
            if (redisURI.getSentinelMasterId() != null && !redisURI.getSentinels().isEmpty()) {
                logger.debug("Connecting to Redis using Sentinels {}, MasterId {}", redisURI.getSentinels(), (Object)redisURI.getSentinelMasterId());
                return this.lookupRedis(redisURI).switchIfEmpty(Mono.error((Throwable)new RedisConnectionException("Cannot provide redisAddress using sentinel for masterId " + redisURI.getSentinelMasterId())));
            }
            return Mono.fromCallable(() -> this.clientResources.socketAddressResolver().resolve(redisURI));
        });
    }

    protected RedisCodec<String, String> newStringStringCodec() {
        return StringCodec.UTF8;
    }

    private static void validateUrisAreOfSameConnectionType(List<RedisURI> redisUris) {
        boolean unixDomainSocket = false;
        boolean inetSocket = false;
        for (RedisURI sentinel : redisUris) {
            if (sentinel.getSocket() != null) {
                unixDomainSocket = true;
            }
            if (sentinel.getHost() == null) continue;
            inetSocket = true;
        }
        if (unixDomainSocket && inetSocket) {
            throw new RedisConnectionException("You cannot mix unix domain socket and IP socket URI's");
        }
    }

    private Mono<SocketAddress> getSocketAddressSupplier(RedisURI redisURI) {
        return this.getSocketAddress(redisURI).doOnNext(addr -> logger.debug("Resolved SocketAddress {} using {}", addr, (Object)redisURI));
    }

    private Mono<SocketAddress> lookupRedis(RedisURI sentinelUri) {
        Mono connection = Mono.fromCompletionStage(() -> this.connectSentinelAsync(this.newStringStringCodec(), sentinelUri, this.timeout));
        return connection.flatMap(c -> {
            String sentinelMasterId = sentinelUri.getSentinelMasterId();
            return c.reactive().getMasterAddrByName(sentinelMasterId).map(it -> {
                if (it instanceof InetSocketAddress) {
                    InetSocketAddress isa = (InetSocketAddress)it;
                    SocketAddress resolved = this.clientResources.socketAddressResolver().resolve(RedisURI.create(isa.getHostString(), isa.getPort()));
                    logger.debug("Resolved Master {} SocketAddress {}:{} to {}", new Object[]{sentinelMasterId, isa.getHostString(), isa.getPort(), resolved});
                    return resolved;
                }
                return it;
            }).timeout(this.timeout).flatMap(it -> Mono.fromCompletionStage(c::closeAsync).thenReturn(it));
        });
    }

    private static <T> ConnectionFuture<T> transformAsyncConnectionException(ConnectionFuture<T> future) {
        return future.thenCompose((v, e) -> {
            if (e != null) {
                return Futures.failed(RedisConnectionException.create(future.getRemoteAddress(), e));
            }
            return CompletableFuture.completedFuture(v);
        });
    }

    private static <T> CompletableFuture<T> transformAsyncConnectionException(CompletionStage<T> future, RedisURI target) {
        return ConnectionFuture.from(null, future.toCompletableFuture()).thenCompose((v, e) -> {
            if (e != null) {
                return Futures.failed(RedisConnectionException.create(target.toString(), e));
            }
            return CompletableFuture.completedFuture(v);
        }).toCompletableFuture();
    }

    private static void checkValidRedisURI(RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisURI, "A valid RedisURI is required");
        if (redisURI.getSentinels().isEmpty()) {
            if (LettuceStrings.isEmpty(redisURI.getHost()) && LettuceStrings.isEmpty(redisURI.getSocket())) {
                throw new IllegalArgumentException("RedisURI for Redis Standalone does not contain a host or a socket");
            }
        } else {
            if (LettuceStrings.isEmpty(redisURI.getSentinelMasterId())) {
                throw new IllegalArgumentException("TRedisURI for Redis Sentinel requires a masterId");
            }
            for (RedisURI sentinel : redisURI.getSentinels()) {
                if (!LettuceStrings.isEmpty(sentinel.getHost()) || !LettuceStrings.isEmpty(sentinel.getSocket())) continue;
                throw new IllegalArgumentException("RedisURI for Redis Sentinel does not contain a host or a socket");
            }
        }
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
    }

    private static void assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisURI, "RedisURI must not be null");
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull((Object)clientResources, "ClientResources must not be null");
    }

    private void checkForRedisURI() {
        LettuceAssert.assertState(this.redisURI != EMPTY_URI, "RedisURI is not available. Use RedisClient(Host), RedisClient(Host, Port) or RedisClient(RedisURI) to construct your client.");
        RedisClient.checkValidRedisURI(this.redisURI);
    }
}

