/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.AbstractRedisReactiveCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.dynamic.CommandCreationException;
import io.lettuce.core.dynamic.CommandFactoryResolver;
import io.lettuce.core.dynamic.CommandMethod;
import io.lettuce.core.dynamic.CommandMethodVerifier;
import io.lettuce.core.dynamic.ConversionService;
import io.lettuce.core.dynamic.ConvertingCommand;
import io.lettuce.core.dynamic.ExecutableCommand;
import io.lettuce.core.dynamic.ExecutableCommandLookupStrategy;
import io.lettuce.core.dynamic.ReactiveCommandSegmentCommandFactory;
import io.lettuce.core.dynamic.ReactiveExecutableCommand;
import io.lettuce.core.dynamic.ReactiveTypeAdapters;
import io.lettuce.core.dynamic.RedisCommandsMetadata;
import io.lettuce.core.dynamic.codec.AnnotationRedisCodecResolver;
import io.lettuce.core.dynamic.output.CodecAwareOutputFactoryResolver;
import io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import io.lettuce.core.dynamic.segment.AnnotationCommandSegmentFactory;
import io.lettuce.core.dynamic.segment.CommandSegments;
import io.lettuce.core.internal.LettuceAssert;
import java.util.List;

class ReactiveExecutableCommandLookupStrategy
implements ExecutableCommandLookupStrategy {
    private final AbstractRedisReactiveCommands<Object, Object> redisReactiveCommands;
    private final ConversionService conversionService = new ConversionService();
    private final List<RedisCodec<?, ?>> redisCodecs;
    private final CommandOutputFactoryResolver outputFactoryResolver;
    private final ReactiveCommandFactoryResolver commandFactoryResolver;
    private final CommandMethodVerifier commandMethodVerifier;

    ReactiveExecutableCommandLookupStrategy(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver outputFactoryResolver, CommandMethodVerifier commandMethodVerifier, AbstractRedisReactiveCommands<Object, Object> redisReactiveCommands) {
        this.redisReactiveCommands = redisReactiveCommands;
        this.redisCodecs = redisCodecs;
        this.outputFactoryResolver = outputFactoryResolver;
        this.commandMethodVerifier = commandMethodVerifier;
        ReactiveTypeAdapters.registerIn(this.conversionService);
        this.commandFactoryResolver = new ReactiveCommandFactoryResolver();
    }

    @Override
    public ExecutableCommand resolveCommandMethod(CommandMethod method, RedisCommandsMetadata commandsMetadata) {
        LettuceAssert.isTrue(!method.isBatchExecution(), () -> String.format("Command batching %s not supported with ReactiveExecutableCommandLookupStrategy", method));
        LettuceAssert.isTrue(method.isReactiveExecution(), () -> String.format("Command method %s not supported by ReactiveExecutableCommandLookupStrategy", method));
        ReactiveCommandSegmentCommandFactory commandFactory = this.commandFactoryResolver.resolveRedisCommandFactory(method, commandsMetadata);
        return new ConvertingCommand(this.conversionService, new ReactiveExecutableCommand(method, commandFactory, this.redisReactiveCommands));
    }

    class ReactiveCommandFactoryResolver
    implements CommandFactoryResolver {
        final AnnotationCommandSegmentFactory commandSegmentFactory = new AnnotationCommandSegmentFactory();
        final AnnotationRedisCodecResolver codecResolver;

        ReactiveCommandFactoryResolver() {
            this.codecResolver = new AnnotationRedisCodecResolver(ReactiveExecutableCommandLookupStrategy.this.redisCodecs);
        }

        @Override
        public ReactiveCommandSegmentCommandFactory resolveRedisCommandFactory(CommandMethod commandMethod, RedisCommandsMetadata redisCommandsMetadata) {
            RedisCodec<?, ?> codec = this.codecResolver.resolve(commandMethod);
            if (codec == null) {
                throw new CommandCreationException(commandMethod, "Cannot resolve RedisCodec");
            }
            CommandSegments commandSegments = this.commandSegmentFactory.createCommandSegments(commandMethod);
            ReactiveExecutableCommandLookupStrategy.this.commandMethodVerifier.validate(commandSegments, commandMethod);
            CodecAwareOutputFactoryResolver outputFactoryResolver = new CodecAwareOutputFactoryResolver(ReactiveExecutableCommandLookupStrategy.this.outputFactoryResolver, codec);
            return new ReactiveCommandSegmentCommandFactory(commandSegments, commandMethod, codec, outputFactoryResolver);
        }
    }
}

