/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.json.JsonValue;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.vector.QuantizationType;
import java.util.Optional;

public class VAddArgs
implements CompositeArgument {
    private Optional<Boolean> checkAndSet = Optional.empty();
    private Optional<QuantizationType> quantType = Optional.empty();
    private Optional<Long> explorationFactor = Optional.empty();
    private Optional<String> attributes = Optional.empty();
    private Optional<Long> maxNodes = Optional.empty();

    public VAddArgs checkAndSet(boolean checkAndSet) {
        this.checkAndSet = Optional.of(checkAndSet);
        return this;
    }

    public VAddArgs quantizationType(QuantizationType quantType) {
        LettuceAssert.notNull((Object)quantType, "QuantType must not be null");
        this.quantType = Optional.of(quantType);
        return this;
    }

    public VAddArgs explorationFactor(Long explorationFactor) {
        LettuceAssert.isTrue(explorationFactor > 0L, "Exploration factor must be greater than 0");
        this.explorationFactor = Optional.of(explorationFactor);
        return this;
    }

    public VAddArgs maxNodes(Long maxNodes) {
        LettuceAssert.isTrue(maxNodes > 0L, "Max nodes must be greater than 0");
        this.maxNodes = Optional.of(maxNodes);
        return this;
    }

    public VAddArgs attributes(String attributes) {
        LettuceAssert.notNull((Object)attributes, "Attributes must not be null");
        this.attributes = Optional.of(attributes);
        return this;
    }

    public VAddArgs attributes(JsonValue attributes) {
        LettuceAssert.notNull((Object)attributes, "Attributes must not be null");
        this.attributes = Optional.of(attributes.toString());
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.checkAndSet.isPresent() && this.checkAndSet.get().booleanValue()) {
            args.add(CommandKeyword.CAS);
        }
        this.quantType.ifPresent(quantizationType -> args.add(quantizationType.getKeyword()));
        this.explorationFactor.ifPresent(Long2 -> args.add(CommandKeyword.EF).add((long)Long2));
        this.attributes.ifPresent(attr -> args.add(CommandKeyword.SETATTR).add((String)attr));
        this.maxNodes.ifPresent(Long2 -> args.add(CommandKeyword.M).add((long)Long2));
    }

    public static class Builder {
        private Builder() {
        }

        public static VAddArgs checkAndSet(boolean checkAndSet) {
            return new VAddArgs().checkAndSet(checkAndSet);
        }

        public static VAddArgs quantizationType(QuantizationType quantType) {
            return new VAddArgs().quantizationType(quantType);
        }

        public static VAddArgs explorationFactor(Long explorationFactor) {
            return new VAddArgs().explorationFactor(explorationFactor);
        }

        public static VAddArgs maxNodes(Long maxNodes) {
            return new VAddArgs().maxNodes(maxNodes);
        }

        public static VAddArgs attributes(String attributes) {
            return new VAddArgs().attributes(attributes);
        }
    }
}

