/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.util.Optional;

public abstract class FieldArgs<K> {
    protected K name;
    protected Optional<K> as = Optional.empty();
    protected boolean sortable;
    protected boolean unNormalizedForm;
    protected boolean noIndex;
    protected boolean indexEmpty;
    protected boolean indexMissing;

    public abstract String getFieldType();

    public K getName() {
        return this.name;
    }

    public Optional<K> getAs() {
        return this.as;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isUnNormalizedForm() {
        return this.unNormalizedForm;
    }

    public boolean isNoIndex() {
        return this.noIndex;
    }

    public boolean isIndexEmpty() {
        return this.indexEmpty;
    }

    public boolean isIndexMissing() {
        return this.indexMissing;
    }

    public final void build(CommandArgs<K, ?> args) {
        args.addKey(this.name);
        this.as.ifPresent(a -> args.add(CommandKeyword.AS).addKey(a));
        args.add(this.getFieldType());
        this.buildTypeSpecificArgs(args);
        if (this.sortable) {
            args.add(CommandKeyword.SORTABLE);
            if (this.unNormalizedForm) {
                args.add(CommandKeyword.UNF);
            }
        }
        if (this.noIndex) {
            args.add(CommandKeyword.NOINDEX);
        }
        if (this.indexEmpty) {
            args.add(CommandKeyword.INDEXEMPTY);
        }
        if (this.indexMissing) {
            args.add(CommandKeyword.INDEXMISSING);
        }
    }

    protected abstract void buildTypeSpecificArgs(CommandArgs<K, ?> var1);

    public static abstract class Builder<K, T extends FieldArgs<K>, B extends Builder<K, T, B>> {
        protected final T instance;

        protected Builder(T instance) {
            this.instance = instance;
        }

        protected B self() {
            return (B)this;
        }

        public B name(K name) {
            ((FieldArgs)this.instance).name = name;
            return this.self();
        }

        public B as(K as) {
            ((FieldArgs)this.instance).as = Optional.of(as);
            return this.self();
        }

        public B sortable() {
            ((FieldArgs)this.instance).sortable = true;
            return this.self();
        }

        public B unNormalizedForm() {
            ((FieldArgs)this.instance).sortable = true;
            ((FieldArgs)this.instance).unNormalizedForm = true;
            return this.self();
        }

        public B noIndex() {
            ((FieldArgs)this.instance).noIndex = true;
            return this.self();
        }

        public B indexEmpty() {
            ((FieldArgs)this.instance).indexEmpty = true;
            return this.self();
        }

        public B indexMissing() {
            ((FieldArgs)this.instance).indexMissing = true;
            return this.self();
        }

        public T build() {
            return this.instance;
        }
    }
}

