/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AbstractPrefixPatternMethodMatcher
implements MethodMatcher {
    private static final Comparator<String> PREFIX_COMPARATOR = Comparator.comparingInt(String::length).thenComparing(String::compareTo).reversed();
    protected final Pattern pattern;

    protected AbstractPrefixPatternMethodMatcher(@NonNull List<String> prefixes) {
        if (prefixes.isEmpty()) {
            throw new IllegalArgumentException("At least one prefix required");
        }
        this.pattern = AbstractPrefixPatternMethodMatcher.computePattern(prefixes);
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        String methodName = matchContext.getMethodElement().getName();
        Matcher matcher = this.pattern.matcher(methodName);
        if (matcher.find()) {
            return this.match(matchContext, matcher);
        }
        return null;
    }

    protected abstract MethodMatcher.MethodMatch match(MethodMatchContext var1, Matcher var2);

    private static Pattern computePattern(List<String> prefixes) {
        String prefixPattern = prefixes.stream().sorted(PREFIX_COMPARATOR).collect(Collectors.joining("|"));
        return Pattern.compile("^((" + prefixPattern + ")(\\S*?))$");
    }
}

