/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.query;

import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersPreparedQuery;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.query.internal.DefaultPreparedQuery;
import io.micronaut.data.runtime.query.internal.DelegatePreparedQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.util.Map;

@Internal
public class DefaultBindableParametersPreparedQuery<E, R>
implements BindableParametersPreparedQuery<E, R>,
DelegatePreparedQuery<E, R> {
    protected final PreparedQuery<E, R> preparedQuery;
    protected final InvocationContext<?, ?> invocationContext;
    protected final BindableParametersStoredQuery<E, R> storedQuery;

    public DefaultBindableParametersPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        this.preparedQuery = preparedQuery;
        this.invocationContext = ((DefaultPreparedQuery)preparedQuery).getContext();
        this.storedQuery = DefaultBindableParametersPreparedQuery.unwrap(((DefaultPreparedQuery)preparedQuery).getStoredQueryDelegate());
    }

    public DefaultBindableParametersPreparedQuery(PreparedQuery<E, R> preparedQuery, InvocationContext<?, ?> invocationContext, BindableParametersStoredQuery<E, R> storedQuery) {
        this.preparedQuery = preparedQuery;
        this.invocationContext = invocationContext;
        this.storedQuery = storedQuery;
    }

    private static <X, Y> BindableParametersStoredQuery<X, Y> unwrap(StoredQuery<X, Y> storedQuery) {
        if (storedQuery instanceof BindableParametersStoredQuery) {
            return (BindableParametersStoredQuery)storedQuery;
        }
        if (storedQuery instanceof DelegateStoredQuery) {
            return DefaultBindableParametersPreparedQuery.unwrap(storedQuery);
        }
        throw new DataAccessException("Cannot unwrap BindableParametersStoredQuery");
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.storedQuery.getPersistentEntity();
    }

    @Override
    public PreparedQuery<E, R> getPreparedQueryDelegate() {
        return this.preparedQuery;
    }

    @Override
    public void bindParameters(BindableParametersStoredQuery.Binder binder, E entity, Map<QueryParameterBinding, Object> previousValues) {
        this.storedQuery.bindParameters(binder, this.invocationContext, entity, previousValues);
    }

    @Override
    public void bindParameters(BindableParametersStoredQuery.Binder binder, InvocationContext<?, ?> invocationContext, E entity, Map<QueryParameterBinding, Object> previousValues) {
        this.storedQuery.bindParameters(binder, this.invocationContext, entity, previousValues);
    }
}

