/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlowImpl;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Internal
public interface ExecutionFlow<T> {
    @NonNull
    public static <K> ExecutionFlow<K> just(@Nullable K value) {
        return new ImperativeExecutionFlowImpl(value, null);
    }

    @NonNull
    public static <K> ExecutionFlow<K> error(@NonNull Throwable e) {
        return new ImperativeExecutionFlowImpl(null, e);
    }

    @NonNull
    public static <T> ExecutionFlow<T> empty() {
        return new ImperativeExecutionFlowImpl(null, null);
    }

    @NonNull
    public static <T> ExecutionFlow<T> async(@NonNull Executor executor, @NonNull Supplier<? extends ExecutionFlow<T>> supplier) {
        DelayedExecutionFlow completableFuture = DelayedExecutionFlow.create();
        executor.execute(() -> ((ExecutionFlow)supplier.get()).onComplete((t, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)throwable;
                    throwable = completionException.getCause();
                }
                completableFuture.completeExceptionally((Throwable)throwable);
            } else {
                completableFuture.complete(t);
            }
        }));
        return completableFuture;
    }

    @NonNull
    public <R> ExecutionFlow<R> map(@NonNull Function<? super T, ? extends R> var1);

    @NonNull
    public <R> ExecutionFlow<R> flatMap(@NonNull Function<? super T, ? extends ExecutionFlow<? extends R>> var1);

    @NonNull
    public <R> ExecutionFlow<R> then(@NonNull Supplier<? extends ExecutionFlow<? extends R>> var1);

    @NonNull
    public ExecutionFlow<T> onErrorResume(@NonNull Function<? super Throwable, ? extends ExecutionFlow<? extends T>> var1);

    @NonNull
    public ExecutionFlow<T> putInContext(@NonNull String var1, @NonNull Object var2);

    public void onComplete(@NonNull BiConsumer<? super T, Throwable> var1);

    @Nullable
    public ImperativeExecutionFlow<T> tryComplete();

    @Nullable
    default public T tryCompleteValue() {
        ImperativeExecutionFlow<T> imperativeFlow = this.tryComplete();
        if (imperativeFlow != null) {
            return imperativeFlow.getValue();
        }
        return null;
    }

    @Nullable
    default public Throwable tryCompleteError() {
        ImperativeExecutionFlow<T> imperativeFlow = this.tryComplete();
        if (imperativeFlow != null) {
            return imperativeFlow.getError();
        }
        return null;
    }

    @NonNull
    default public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.onComplete((value, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)throwable;
                    throwable = completionException.getCause();
                }
                completableFuture.completeExceptionally((Throwable)throwable);
            } else {
                completableFuture.complete(value);
            }
        });
        return completableFuture;
    }
}

