/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.MicronautMetaServiceLoaderUtils;
import io.micronaut.core.io.service.SoftServiceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graalvm.nativeimage.ImageSingletons;

@Internal
final class ServiceScanner<S> {
    private final ClassLoader classLoader;
    private final String serviceName;
    private final Predicate<String> lineCondition;
    private final Function<String, S> transformer;

    public ServiceScanner(ClassLoader classLoader, String serviceName, Predicate<String> lineCondition, Function<String, S> transformer) {
        this.classLoader = classLoader;
        this.serviceName = serviceName;
        this.lineCondition = lineCondition;
        this.transformer = transformer;
    }

    @Nullable
    static StaticServiceDefinitions findStaticServiceDefinitions() {
        if (ServiceScanner.hasImageSingletons()) {
            return ImageSingletons.contains(StaticServiceDefinitions.class) ? (StaticServiceDefinitions)ImageSingletons.lookup(StaticServiceDefinitions.class) : null;
        }
        return null;
    }

    private static boolean hasImageSingletons() {
        try {
            return ImageSingletons.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Set<String> computeStandardServiceTypeNames(URL url) {
        HashSet<String> typeNames = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || !this.lineCondition.test(line)) continue;
                int i = line.indexOf(35);
                if (i > -1) {
                    line = line.substring(0, i);
                }
                typeNames.add(line);
            }
        }
        catch (IOException | UncheckedIOException exception) {
            // empty catch block
        }
        return typeNames;
    }

    private Enumeration<URL> findStandardServiceConfigs() throws IOException {
        return this.classLoader.getResources("META-INF/services/" + this.serviceName);
    }

    @Internal
    record StaticServiceDefinitions(Map<String, Set<String>> serviceTypeMap) {
        StaticServiceDefinitions {
            if (serviceTypeMap == null) {
                serviceTypeMap = new HashMap<String, Set<String>>();
            }
        }
    }

    private static abstract class RecursiveActionValuesCollector<S>
    extends RecursiveAction {
        private RecursiveActionValuesCollector() {
        }

        public abstract void collect(Collection<S> var1);
    }

    private final class ServiceInstanceLoader
    extends RecursiveActionValuesCollector<S> {
        private final String className;
        private S result;
        private Throwable throwable;

        public ServiceInstanceLoader(String className) {
            this.className = className;
        }

        @Override
        protected void compute() {
            try {
                this.result = ServiceScanner.this.transformer.apply(this.className);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        @Override
        public void collect(Collection<S> values) {
            if (this.throwable != null) {
                throw new SoftServiceLoader.ServiceLoadingException("Failed to load a service: " + this.throwable.getMessage(), this.throwable);
            }
            if (this.result != null && !values.contains(this.result)) {
                values.add(this.result);
            }
        }
    }

    private final class UrlServicesLoader
    extends RecursiveActionValuesCollector<S> {
        private final URL url;
        private final List<ServiceInstanceLoader> tasks = new ArrayList<ServiceInstanceLoader>();

        public UrlServicesLoader(URL url) {
            this.url = url;
        }

        @Override
        protected void compute() {
            for (String typeName : ServiceScanner.this.computeStandardServiceTypeNames(this.url)) {
                ServiceInstanceLoader task = new ServiceInstanceLoader(typeName);
                this.tasks.add(task);
                task.fork();
            }
        }

        @Override
        public void collect(Collection<S> values) {
            for (ServiceInstanceLoader task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }
    }

    final class DefaultServiceCollector
    extends RecursiveActionValuesCollector<S>
    implements SoftServiceLoader.ServiceCollector<S> {
        private final List<RecursiveActionValuesCollector<S>> tasks = new ArrayList();

        DefaultServiceCollector() {
        }

        @Override
        protected void compute() {
            try {
                Enumeration<URL> serviceConfigs = ServiceScanner.this.findStandardServiceConfigs();
                while (serviceConfigs.hasMoreElements()) {
                    URL url = serviceConfigs.nextElement();
                    UrlServicesLoader task = new UrlServicesLoader(url);
                    this.tasks.add(task);
                    task.fork();
                }
                Set<String> serviceEntries = MicronautMetaServiceLoaderUtils.findMicronautMetaServiceEntries(ServiceScanner.this.classLoader, ServiceScanner.this.serviceName);
                for (String serviceEntry : serviceEntries) {
                    ServiceInstanceLoader task = new ServiceInstanceLoader(serviceEntry);
                    this.tasks.add(task);
                    task.fork();
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Failed to load resources for service: " + ServiceScanner.this.serviceName, e);
            }
        }

        @Override
        public void collect(Collection<S> values) {
            ForkJoinPool.commonPool().invoke(this);
            for (RecursiveActionValuesCollector task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }

        @Override
        public void collect(Collection<S> values, boolean allowFork) {
            if (allowFork && ForkJoinPool.getCommonPoolParallelism() > 1) {
                ForkJoinPool.commonPool().invoke(this);
                for (RecursiveActionValuesCollector task : this.tasks) {
                    task.join();
                    task.collect(values);
                }
            } else {
                try {
                    Object val;
                    Enumeration<URL> serviceConfigs = ServiceScanner.this.findStandardServiceConfigs();
                    while (serviceConfigs.hasMoreElements()) {
                        URL url = serviceConfigs.nextElement();
                        for (String typeName : ServiceScanner.this.computeStandardServiceTypeNames(url)) {
                            val = ServiceScanner.this.transformer.apply(typeName);
                            if (val == null) continue;
                            values.add(val);
                        }
                    }
                    Set<String> serviceEntries = MicronautMetaServiceLoaderUtils.findMicronautMetaServiceEntries(ServiceScanner.this.classLoader, ServiceScanner.this.serviceName);
                    for (String serviceEntry : serviceEntries) {
                        val = ServiceScanner.this.transformer.apply(serviceEntry);
                        if (val == null) continue;
                        values.add(val);
                    }
                }
                catch (IOException e) {
                    throw new ServiceConfigurationError("Failed to load resources for service: " + ServiceScanner.this.serviceName, e);
                }
            }
        }
    }
}

