/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.loadbalance;

import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.http.client.LoadBalancer;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;

@Singleton
public class LoadBalancerConverters
implements TypeConverterRegistrar {
    public void register(ConversionService<?> conversionService) {
        conversionService.addConverter(URI.class, LoadBalancer.class, (object, targetType, context) -> {
            try {
                return Optional.of(LoadBalancer.fixed(object.toURL()));
            }
            catch (MalformedURLException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        });
        conversionService.addConverter(URL.class, LoadBalancer.class, LoadBalancer::fixed);
        conversionService.addConverter(String.class, LoadBalancer.class, url -> {
            try {
                return LoadBalancer.fixed(new URL((String)url));
            }
            catch (MalformedURLException e) {
                return null;
            }
        });
    }
}

