/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpParameters;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.netty.stream.DefaultStreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.uri.UriBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;

@Internal
public class NettyClientHttpRequest<B>
implements MutableHttpRequest<B>,
NettyHttpRequestBuilder {
    static final CharSequence CHANNEL = "netty_channel";
    private final NettyHttpHeaders headers = new NettyHttpHeaders();
    private final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap();
    private final HttpMethod httpMethod;
    private final String httpMethodName;
    private final Map<String, String> cookies = new LinkedHashMap<String, String>(1);
    private URI uri;
    private Object body;
    private NettyHttpParameters httpParameters;
    private ConversionService conversionService = ConversionService.SHARED;

    NettyClientHttpRequest(HttpMethod httpMethod, URI uri, String httpMethodName) {
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.httpMethodName = httpMethodName;
    }

    NettyClientHttpRequest(HttpMethod httpMethod, String uri) {
        this(httpMethod, uri, httpMethod.name());
    }

    NettyClientHttpRequest(HttpMethod httpMethod, String uri, String httpMethodName) {
        this(httpMethod, URI.create(uri), httpMethodName);
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public MutableHttpRequest<B> cookie(Cookie cookie) {
        if (!(cookie instanceof NettyCookie)) {
            throw new IllegalArgumentException("Argument is not a Netty compatible Cookie");
        }
        NettyCookie nettyCookie = (NettyCookie)cookie;
        String value = ClientCookieEncoder.LAX.encode(nettyCookie.getNettyCookie());
        this.cookies.put(cookie.getName(), value);
        String headerValue = this.cookies.size() > 1 ? String.join((CharSequence)";", this.cookies.values()) : value;
        this.headers.set((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)headerValue);
        return this;
    }

    public MutableHttpRequest<B> cookies(Set<Cookie> cookies) {
        if (cookies.size() > 1) {
            for (Cookie cookie : cookies) {
                if (cookie instanceof NettyCookie) {
                    NettyCookie nettyCookie = (NettyCookie)cookie;
                    String value = ClientCookieEncoder.LAX.encode(nettyCookie.getNettyCookie());
                    this.cookies.put(cookie.getName(), value);
                    continue;
                }
                throw new IllegalArgumentException("Argument is not a Netty compatible Cookie");
            }
            this.headers.set((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)String.join((CharSequence)";", this.cookies.values()));
        } else if (!cookies.isEmpty()) {
            this.cookie(cookies.iterator().next());
        }
        return this;
    }

    public MutableHttpRequest<B> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T> Optional<T> getBody(Class<T> type) {
        return this.getBody(Argument.of(type));
    }

    public <T> Optional<T> getBody(ArgumentConversionContext<T> conversionContext) {
        return this.getBody().flatMap(b -> this.conversionService.convert(b, conversionContext));
    }

    public <T> MutableHttpRequest<T> body(T body) {
        this.body = body;
        return this;
    }

    public Cookies getCookies() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableHttpParameters getParameters() {
        NettyHttpParameters httpParameters = this.httpParameters;
        if (httpParameters == null) {
            NettyClientHttpRequest nettyClientHttpRequest = this;
            synchronized (nettyClientHttpRequest) {
                httpParameters = this.httpParameters;
                if (httpParameters == null) {
                    this.httpParameters = httpParameters = this.decodeParameters(this.getUri());
                }
            }
        }
        return httpParameters;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getUri() {
        return this.uri;
    }

    private NettyHttpParameters decodeParameters(URI uri) {
        QueryStringDecoder queryStringDecoder = this.createDecoder(uri);
        return new NettyHttpParameters(queryStringDecoder.parameters(), this.conversionService, (name, value) -> {
            UriBuilder newUri = UriBuilder.of((URI)this.getUri());
            newUri.replaceQueryParam(name.toString(), value.toArray());
            this.uri(newUri.build());
        });
    }

    protected QueryStringDecoder createDecoder(URI uri) {
        Charset charset = this.getCharacterEncoding();
        return charset != null ? new QueryStringDecoder(uri, charset) : new QueryStringDecoder(uri);
    }

    private static io.netty.handler.codec.http.HttpMethod getMethod(String httpMethodName) {
        return io.netty.handler.codec.http.HttpMethod.valueOf((String)httpMethodName);
    }

    private String resolveUriPath() {
        URI uri = this.getUri();
        if (StringUtils.isNotEmpty((CharSequence)uri.getScheme())) {
            try {
                uri = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri.toString();
    }

    public String toString() {
        return this.getMethodName() + " " + this.uri;
    }

    public String getMethodName() {
        return this.httpMethodName;
    }

    @NonNull
    @Deprecated
    public FullHttpRequest toFullHttpRequest() {
        DefaultFullHttpRequest req;
        String uriStr = this.resolveUriPath();
        io.netty.handler.codec.http.HttpMethod method = NettyClientHttpRequest.getMethod(this.httpMethodName);
        if (this.body != null) {
            Object object = this.body;
            if (object instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)object;
                req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uriStr, buf, this.headers.getNettyHeaders(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            } else {
                req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uriStr, false);
                req.headers().setAll(this.headers.getNettyHeaders());
            }
        } else {
            req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uriStr, Unpooled.EMPTY_BUFFER, this.headers.getNettyHeaders(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        }
        return req;
    }

    @NonNull
    @Deprecated
    public StreamedHttpRequest toStreamHttpRequest() {
        if (this.body instanceof Publisher) {
            String uriStr = this.resolveUriPath();
            io.netty.handler.codec.http.HttpMethod method = NettyClientHttpRequest.getMethod(this.httpMethodName);
            DefaultStreamedHttpRequest req = new DefaultStreamedHttpRequest(HttpVersion.HTTP_1_1, method, uriStr, false, (Publisher)this.body);
            req.headers().setAll(this.headers.getNettyHeaders());
            return req;
        }
        throw new IllegalStateException("Body must be set to a publisher of HTTP content first!");
    }

    @NonNull
    @Deprecated
    public HttpRequest toHttpRequest() {
        if (this.isStream()) {
            return this.toStreamHttpRequest();
        }
        return this.toFullHttpRequest();
    }

    public HttpRequest toHttpRequestWithoutBody() {
        return new DefaultHttpRequest(HttpVersion.HTTP_1_1, NettyClientHttpRequest.getMethod(this.httpMethodName), this.resolveUriPath(), this.headers.getNettyHeaders());
    }

    @Deprecated
    public boolean isStream() {
        return this.body instanceof Publisher;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

