/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.netty.EventLoopFlow;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.OrderedEventExecutor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
final class ReactiveClientWriter
extends ChannelInboundHandlerAdapter
implements Subscriber<HttpContent> {
    private final Publisher<HttpContent> source;
    private EventLoopFlow flow;
    private ChannelHandlerContext ctx;
    private Subscription subscription;
    private boolean writtenLast;

    ReactiveClientWriter(Publisher<HttpContent> source) {
        this.source = source;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.flow = new EventLoopFlow((OrderedEventExecutor)ctx.channel().eventLoop());
        this.ctx = ctx;
        this.source.subscribe((Subscriber)this);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.ctx = null;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        if (ctx.channel().isWritable()) {
            this.subscription.request(1L);
        }
    }

    public void onSubscribe(Subscription s) {
        if (this.flow.executeNow(() -> this.onSubscribe0(s))) {
            this.onSubscribe0(s);
        }
    }

    private void onSubscribe0(Subscription s) {
        if (this.ctx == null) {
            s.cancel();
        } else {
            this.subscription = s;
            if (this.ctx.channel().isWritable()) {
                this.subscription.request(1L);
            }
        }
    }

    public void onNext(HttpContent httpContent) {
        if (this.flow.executeNow(() -> this.onNext0(httpContent))) {
            this.onNext0(httpContent);
        }
    }

    private void onNext0(HttpContent httpContent) {
        if (this.writtenLast) {
            throw new IllegalStateException("Already written a LastHttpContent");
        }
        if (this.ctx == null) {
            httpContent.release();
            return;
        }
        if (httpContent instanceof LastHttpContent) {
            this.writtenLast = true;
        }
        this.ctx.writeAndFlush((Object)httpContent, this.ctx.voidPromise());
        if (this.ctx.channel().isWritable()) {
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable t) {
        if (this.flow.executeNow(() -> this.onError0(t))) {
            this.onError0(t);
        }
    }

    private void onError0(Throwable t) {
        this.ctx.fireExceptionCaught(t);
        this.ctx.pipeline().remove(this.ctx.name());
    }

    public void onComplete() {
        if (this.flow.executeNow(this::onComplete0)) {
            this.onComplete0();
        }
    }

    private void onComplete0() {
        if (!this.writtenLast) {
            this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.ctx.voidPromise());
        }
        this.ctx.pipeline().remove(this.ctx.name());
    }
}

