/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.ConversionServiceAware;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.functional.ThrowingFunction;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ContextlessMessageBodyHandlerRegistry;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.TypedMessageBodyHandler;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.client.ProxyRequestOptions;
import io.micronaut.http.client.RawHttpClient;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.exceptions.HttpClientErrorDecoder;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientExceptionUtils;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.exceptions.NoHostException;
import io.micronaut.http.client.exceptions.ReadTimeoutException;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.filters.ClientServerContextFilter;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.client.multipart.MultipartDataFactory;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.ConnectionManager;
import io.micronaut.http.client.netty.DefaultHttpClientBuilder;
import io.micronaut.http.client.netty.FullNettyClientHttpResponse;
import io.micronaut.http.client.netty.Http1ResponseHandler;
import io.micronaut.http.client.netty.MicronautFlux;
import io.micronaut.http.client.netty.MutableHttpRequestWrapper;
import io.micronaut.http.client.netty.NettyClientByteBodyResponse;
import io.micronaut.http.client.netty.NettyClientCustomizer;
import io.micronaut.http.client.netty.NettyClientHttpRequest;
import io.micronaut.http.client.netty.NettyStreamedHttpResponse;
import io.micronaut.http.client.netty.RawHttpRequestWrapper;
import io.micronaut.http.client.netty.SseSplitter;
import io.micronaut.http.client.netty.StreamWriter;
import io.micronaut.http.client.netty.ssl.ClientSslBuilder;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.client.netty.websocket.NettyWebSocketClientHandler;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ContextPathUtils;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.exceptions.BufferLengthExceededException;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.FilterRunner;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.netty.body.BodySizeLimits;
import io.micronaut.http.netty.body.NettyBodyAdapter;
import io.micronaut.http.netty.body.NettyByteBody;
import io.micronaut.http.netty.body.NettyByteBufMessageBodyHandler;
import io.micronaut.http.netty.body.NettyCharSequenceBodyWriter;
import io.micronaut.http.netty.body.NettyJsonHandler;
import io.micronaut.http.netty.body.NettyJsonStreamHandler;
import io.micronaut.http.netty.body.NettyWritableBodyWriter;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.http.util.HttpHeadersUtil;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.json.codec.JsonStreamMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.websocket.WebSocketClient;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

@Internal
public class DefaultHttpClient
implements WebSocketClient,
HttpClient,
StreamingHttpClient,
SseClient,
ProxyHttpClient,
RawHttpClient,
Closeable,
AutoCloseable {
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final io.netty.handler.codec.http.HttpHeaders REDIRECT_HEADER_BLOCKLIST = new DefaultHttpHeaders();
    protected MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected ByteBufferFactory<ByteBufAllocator, ByteBuf> byteBufferFactory = new NettyByteBufferFactory();
    ConnectionManager connectionManager;
    private MessageBodyHandlerRegistry handlerRegistry;
    private final List<HttpFilterResolver.FilterEntry> clientFilterEntries;
    private final LoadBalancer loadBalancer;
    private final HttpClientConfiguration configuration;
    private final String contextPath;
    private final Charset defaultCharset;
    private final Logger log;
    private final HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver;
    private final WebSocketBeanRegistry webSocketRegistry;
    private final RequestBinderRegistry requestBinderRegistry;
    private final String informationalServiceId;
    private final ConversionService conversionService;
    @Nullable
    private final ExecutorService blockingExecutor;

    @Deprecated
    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @Nullable ThreadFactory threadFactory, ClientSslBuilder nettyClientSslBuilder, @NonNull MediaTypeCodecRegistry codecRegistry, @NonNull MessageBodyHandlerRegistry handlerRegistry, @Nullable AnnotationMetadataResolver annotationMetadataResolver, ConversionService conversionService, HttpClientFilter ... filters) {
        this(DefaultHttpClient.builder().loadBalancer(loadBalancer).configuration(configuration).contextPath(contextPath).threadFactory(threadFactory).nettyClientSslBuilder(nettyClientSslBuilder).codecRegistry(codecRegistry).handlerRegistry(handlerRegistry).conversionService(conversionService).annotationMetadataResolver(annotationMetadataResolver).filters(filters));
    }

    @Deprecated
    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @Nullable HttpVersionSelection explicitHttpVersion, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @NonNull HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver, @NonNull List<HttpFilterResolver.FilterEntry> clientFilterEntries, @Nullable ThreadFactory threadFactory, @NonNull ClientSslBuilder nettyClientSslBuilder, @NonNull MediaTypeCodecRegistry codecRegistry, @NonNull MessageBodyHandlerRegistry handlerRegistry, @NonNull WebSocketBeanRegistry webSocketBeanRegistry, @NonNull RequestBinderRegistry requestBinderRegistry, @Nullable EventLoopGroup eventLoopGroup, @NonNull ChannelFactory<? extends SocketChannel> socketChannelFactory, @NonNull ChannelFactory<? extends DatagramChannel> udpChannelFactory, NettyClientCustomizer clientCustomizer, @Nullable String informationalServiceId, ConversionService conversionService, @Nullable AddressResolverGroup<?> resolverGroup) {
        this(DefaultHttpClient.builder().loadBalancer(loadBalancer).explicitHttpVersion(explicitHttpVersion).configuration(configuration).contextPath(contextPath).filterResolver(filterResolver).clientFilterEntries(clientFilterEntries).threadFactory(threadFactory).nettyClientSslBuilder(nettyClientSslBuilder).codecRegistry(codecRegistry).handlerRegistry(handlerRegistry).webSocketBeanRegistry(webSocketBeanRegistry).requestBinderRegistry(requestBinderRegistry).eventLoopGroup(eventLoopGroup).socketChannelFactory(socketChannelFactory).udpChannelFactory(udpChannelFactory).clientCustomizer(clientCustomizer).informationalServiceId(informationalServiceId).conversionService(conversionService).resolverGroup(resolverGroup));
    }

    DefaultHttpClient(DefaultHttpClientBuilder builder) {
        this.loadBalancer = builder.loadBalancer;
        this.configuration = builder.configuration == null ? new DefaultHttpClientConfiguration() : builder.configuration;
        this.defaultCharset = this.configuration.getDefaultCharset();
        if (StringUtils.isNotEmpty((CharSequence)builder.contextPath)) {
            if (builder.contextPath.charAt(0) != '/') {
                builder.contextPath = "/" + builder.contextPath;
            }
            this.contextPath = builder.contextPath;
        } else {
            this.contextPath = null;
        }
        this.mediaTypeCodecRegistry = builder.codecRegistry == null ? DefaultHttpClient.createDefaultMediaTypeRegistry() : builder.codecRegistry;
        this.handlerRegistry = builder.handlerRegistry == null ? DefaultHttpClient.createDefaultMessageBodyHandlerRegistry() : builder.handlerRegistry;
        this.log = this.configuration.getLoggerName().map(LoggerFactory::getLogger).orElse(DEFAULT_LOG);
        if (builder.filterResolver == null) {
            builder.filters(new HttpClientFilter[0]);
        }
        this.filterResolver = builder.filterResolver;
        this.clientFilterEntries = builder.clientFilterEntries != null ? builder.clientFilterEntries : builder.filterResolver.resolveFilterEntries((AnnotationMetadataProvider)new ClientFilterResolutionContext(null, AnnotationMetadata.EMPTY_METADATA));
        this.webSocketRegistry = builder.webSocketBeanRegistry;
        this.conversionService = builder.conversionService;
        this.requestBinderRegistry = builder.requestBinderRegistry == null ? new DefaultRequestBinderRegistry(this.conversionService, new RequestArgumentBinder[0]) : builder.requestBinderRegistry;
        this.informationalServiceId = builder.informationalServiceId;
        this.blockingExecutor = builder.blockingExecutor;
        this.connectionManager = new ConnectionManager(this.log, builder.eventLoopGroup, (ThreadFactory)(builder.threadFactory == null ? new DefaultThreadFactory(MultithreadEventLoopGroup.class) : builder.threadFactory), this.configuration, builder.explicitHttpVersion, builder.socketChannelFactory, builder.udpChannelFactory, builder.nettyClientSslBuilder == null ? new NettyClientSslBuilder(new ResourceResolver()) : builder.nettyClientSslBuilder, builder.clientCustomizer, builder.informationalServiceId, builder.resolverGroup);
    }

    @Deprecated
    public DefaultHttpClient(@Nullable URI uri) {
        this(DefaultHttpClient.builder().uri(uri));
    }

    @Deprecated
    public DefaultHttpClient() {
        this(DefaultHttpClient.builder());
    }

    @Deprecated
    public DefaultHttpClient(@Nullable URI uri, @NonNull HttpClientConfiguration configuration) {
        this(DefaultHttpClient.builder().uri(uri).configuration(configuration));
    }

    @Deprecated
    public DefaultHttpClient(@Nullable URI uri, @NonNull HttpClientConfiguration configuration, @NonNull ClientSslBuilder clientSslBuilder) {
        this(DefaultHttpClient.builder().uri(uri).configuration(configuration).nettyClientSslBuilder(clientSslBuilder));
    }

    @Deprecated
    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, HttpClientConfiguration configuration) {
        this(DefaultHttpClient.builder().loadBalancer(loadBalancer).configuration(configuration));
    }

    @NonNull
    public static DefaultHttpClientBuilder builder() {
        return new DefaultHttpClientBuilder();
    }

    static boolean isAcceptEvents(HttpRequest<?> request) {
        String acceptHeader = (String)request.getHeaders().get((CharSequence)"Accept");
        return acceptHeader != null && acceptHeader.equalsIgnoreCase("text/event-stream");
    }

    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public Logger getLog() {
        return this.log;
    }

    public ConnectionManager connectionManager() {
        return this.connectionManager;
    }

    public HttpClient start() {
        if (!this.isRunning()) {
            this.connectionManager.start();
        }
        return this;
    }

    public boolean isRunning() {
        return this.connectionManager.isRunning();
    }

    public HttpClient stop() {
        if (this.isRunning()) {
            this.connectionManager.shutdown();
        }
        return this;
    }

    @Deprecated
    public MediaTypeCodecRegistry getMediaTypeCodecRegistry() {
        return this.mediaTypeCodecRegistry;
    }

    @Deprecated(forRemoval=true)
    public void setMediaTypeCodecRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        if (mediaTypeCodecRegistry != null) {
            this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        }
    }

    @NonNull
    public final MessageBodyHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    @Deprecated(forRemoval=true)
    public final void setHandlerRegistry(@NonNull MessageBodyHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public BlockingHttpClient toBlocking() {
        return new BlockingHttpClient(){

            public void close() {
                DefaultHttpClient.this.close();
            }

            public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                if (!DefaultHttpClient.this.configuration.isAllowBlockEventLoop() && Thread.currentThread() instanceof FastThreadLocalThread) {
                    throw new HttpClientException("You are trying to run a BlockingHttpClient operation on a netty event loop thread. This is a common cause for bugs: Event loops should never be blocked. You can either mark your controller as @ExecuteOn(TaskExecutors.BLOCKING), or use the reactive HTTP client to resolve this bug. There is also a configuration option to disable this check if you are certain a blocking operation is fine here.");
                }
                BlockHint blockHint = BlockHint.willBlockThisThread();
                return (HttpResponse)DefaultHttpClient.this.exchange(request, bodyType, errorType, blockHint).block();
            }

            public <I, O, E> O retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                HttpResponse response = this.exchange(request, bodyType, errorType);
                if (HttpStatus.class.isAssignableFrom(bodyType.getType())) {
                    return (O)response.getStatus();
                }
                Optional body = response.getBody();
                if (body.isEmpty() && response.getBody(Argument.of(byte[].class)).isPresent()) {
                    throw DefaultHttpClient.this.decorate(new HttpClientResponseException("Failed to decode the body for the given content type [%s]".formatted(response.getContentType().orElse(null)), response));
                }
                return (O)body.orElseThrow(() -> DefaultHttpClient.this.decorate(new HttpClientResponseException("Empty body", response)));
            }
        };
    }

    @NonNull
    private <I> MutableHttpRequest<?> toMutableRequest(HttpRequest<I> request) {
        return MutableHttpRequestWrapper.wrapIfNecessary(this.conversionService, request);
    }

    public <I> Publisher<Event<ByteBuffer<?>>> eventStream(@NonNull HttpRequest<I> request) {
        this.setupConversionService(request);
        return this.eventStreamOrError(request, null);
    }

    private <I> Publisher<Event<ByteBuffer<?>>> eventStreamOrError(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        if (request instanceof MutableHttpRequest) {
            MutableHttpRequest httpRequest = (MutableHttpRequest)request;
            httpRequest.accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM_TYPE});
        }
        return Flux.create(emitter -> this.dataStream(request, errorType).subscribe(new Subscriber<ByteBuffer<?>>((FluxSink)emitter){
            private Subscription dataSubscription;
            private CurrentEvent currentEvent;
            final /* synthetic */ FluxSink val$emitter;
            {
                this.val$emitter = fluxSink;
            }

            public void onSubscribe(Subscription s) {
                this.dataSubscription = s;
                Disposable cancellable = () -> this.dataSubscription.cancel();
                this.val$emitter.onCancel(cancellable);
                if (!this.val$emitter.isCancelled() && this.val$emitter.requestedFromDownstream() > 0L) {
                    this.dataSubscription.request(1L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ByteBuffer<?> buffer) {
                try {
                    int len = buffer.readableBytes();
                    if (len == 0) {
                        try {
                            Event event = Event.of((Object)DefaultHttpClient.this.byteBufferFactory.wrap(this.currentEvent.data)).name(this.currentEvent.name).retry(this.currentEvent.retry).id(this.currentEvent.id);
                            this.val$emitter.next((Object)event);
                        }
                        finally {
                            this.currentEvent = null;
                        }
                    } else {
                        int colonIndex;
                        if (this.currentEvent == null) {
                            this.currentEvent = new CurrentEvent();
                        }
                        if ((colonIndex = buffer.indexOf((byte)58)) > 0) {
                            String type = buffer.slice(0, colonIndex).toString(StandardCharsets.UTF_8).trim();
                            int fromIndex = colonIndex + 1;
                            if (buffer.getByte(fromIndex) == 32) {
                                ++fromIndex;
                            }
                            if (fromIndex < len) {
                                int toIndex = len - fromIndex;
                                switch (type) {
                                    case "data": {
                                        ByteBuffer content = buffer.slice(fromIndex, toIndex);
                                        byte[] d = this.currentEvent.data;
                                        if (d == null) {
                                            this.currentEvent.data = content.toByteArray();
                                            break;
                                        }
                                        this.currentEvent.data = ArrayUtils.concat((byte[])d, (byte[])content.toByteArray());
                                        break;
                                    }
                                    case "id": {
                                        ByteBuffer id = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.id = id.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "event": {
                                        ByteBuffer event = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.name = event.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "retry": {
                                        ByteBuffer retry = buffer.slice(fromIndex, toIndex);
                                        String text = retry.toString(StandardCharsets.UTF_8);
                                        if (StringUtils.isEmpty((CharSequence)text)) break;
                                        this.currentEvent.retry = Duration.ofMillis(Long.parseLong(text));
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (this.val$emitter.requestedFromDownstream() > 0L && !this.val$emitter.isCancelled()) {
                        this.dataSubscription.request(1L);
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                }
                finally {
                    if (buffer instanceof ReferenceCounted) {
                        ReferenceCounted counted = (ReferenceCounted)buffer;
                        counted.release();
                    }
                }
            }

            public void onError(Throwable t) {
                this.dataSubscription.cancel();
                if (t instanceof HttpClientException) {
                    this.val$emitter.error(t);
                } else {
                    this.val$emitter.error((Throwable)DefaultHttpClient.this.decorate(new HttpClientException("Error consuming Server Sent Events: " + t.getMessage(), t)));
                }
            }

            public void onComplete() {
                this.val$emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType) {
        this.setupConversionService(request);
        return this.eventStream(request, eventType, DEFAULT_ERROR_TYPE);
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType, @NonNull Argument<?> errorType) {
        this.setupConversionService(request);
        MessageBodyReader reader = this.handlerRegistry.getReader(eventType, List.of(MediaType.APPLICATION_JSON_TYPE));
        return Flux.from(this.eventStreamOrError(request, errorType)).map(byteBufferEvent -> {
            ByteBuffer data = (ByteBuffer)byteBufferEvent.getData();
            Object decoded = reader.read(eventType, MediaType.APPLICATION_JSON_TYPE, (Headers)request.getHeaders(), data);
            return Event.of((Event)byteBufferEvent, (Object)decoded);
        });
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request) {
        this.setupConversionService(request);
        return this.dataStream(request, DEFAULT_ERROR_TYPE);
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        this.setupConversionService(request);
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return new MicronautFlux<ByteBuffer>(Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> this.dataStreamImpl((MutableHttpRequest)this.toMutableRequest(request), errorType, (HttpRequest<Object>)parentRequest, (URI)requestURI))).doAfterNext(buffer -> {
            ByteBuf byteBuf;
            Object o = buffer.asNativeBuffer();
            if (o instanceof ByteBuf && (byteBuf = (ByteBuf)o).refCnt() > 0) {
                ReferenceCountUtil.safeRelease((Object)byteBuf);
            }
        });
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request) {
        return this.exchangeStream(request, DEFAULT_ERROR_TYPE);
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        this.setupConversionService(request);
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return new MicronautFlux<HttpResponse>(Flux.from(this.resolveRequestURI(request)).flatMap(uri -> this.exchangeStreamImpl((HttpRequest<Object>)parentRequest, (MutableHttpRequest)this.toMutableRequest(request), errorType, (URI)uri))).doAfterNext(byteBufferHttpResponse -> {
            ByteBuffer buffer = (ByteBuffer)byteBufferHttpResponse.body();
            if (buffer instanceof ReferenceCounted) {
                ReferenceCounted counted = (ReferenceCounted)buffer;
                counted.release();
            }
        });
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type) {
        return this.jsonStream(request, type, DEFAULT_ERROR_TYPE);
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type, @NonNull Argument<?> errorType) {
        this.setupConversionService(request);
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        this.setupConversionService(parentRequest);
        return Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> this.jsonStreamImpl((HttpRequest<?>)parentRequest, (MutableHttpRequest)this.toMutableRequest(request), type, errorType, (URI)requestURI));
    }

    public <I> Publisher<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> request) {
        return this.jsonStream(request, Map.class);
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        this.setupConversionService(request);
        return this.jsonStream(request, Argument.of(type));
    }

    public <I, O, E> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return this.exchange(request, bodyType, errorType, null).flux();
    }

    @NonNull
    private <I, O, E> Mono<HttpResponse<O>> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType, @Nullable BlockHint blockHint) {
        this.setupConversionService(request);
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        Mono mono = this.resolveRequestURI(request).flatMap(uri -> {
            MutableHttpRequest mutableRequest = this.toMutableRequest(request).uri(uri);
            return this.sendRequestWithRedirects(parentRequest, blockHint, mutableRequest, (req, resp) -> Mono.from((Publisher)ReactiveExecutionFlow.fromFlow((ExecutionFlow)InternalByteBody.bufferFlow((ByteBody)resp.byteBody()).onErrorResume(t -> ExecutionFlow.error((Throwable)this.handleResponseError((HttpRequest<?>)mutableRequest, (Throwable)t))).flatMap(av -> this.handleExchangeResponse(bodyType, errorType, (NettyClientByteBodyResponse)resp, (CloseableAvailableByteBody)av))).toPublisher())).map(r -> r);
        });
        Duration requestTimeout = this.configuration.getRequestTimeout();
        if (requestTimeout == null) {
            requestTimeout = this.configuration.getReadTimeout().filter(d -> !d.isNegative()).map(d -> d.plusSeconds(1L)).orElse(null);
        }
        if (requestTimeout != null && !requestTimeout.isNegative()) {
            mono = mono.timeout(requestTimeout).onErrorResume(throwable -> {
                if (throwable instanceof TimeoutException) {
                    return Mono.error((Throwable)ReadTimeoutException.TIMEOUT_EXCEPTION);
                }
                return Mono.error((Throwable)throwable);
            });
        }
        return mono;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private <O, E> ExecutionFlow<FullNettyClientHttpResponse<O>> handleExchangeResponse(Argument<O> bodyType, final Argument<E> errorType, NettyClientByteBodyResponse resp, CloseableAvailableByteBody av) {
        Object response;
        ByteBuf buf = AvailableNettyByteBody.toByteBuf((AvailableByteBody)av);
        DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(resp.nettyResponse.protocolVersion(), resp.nettyResponse.status(), buf, resp.nettyResponse.headers(), (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
        try {
            if (this.log.isTraceEnabled()) {
                this.traceBody("Response", fullHttpResponse.content());
            }
            boolean convertBodyWithBodyType = DefaultHttpClient.shouldConvertWithBodyType((io.netty.handler.codec.http.HttpResponse)fullHttpResponse, this.configuration, bodyType, errorType);
            response = new FullNettyClientHttpResponse<O>((FullHttpResponse)fullHttpResponse, this.handlerRegistry, bodyType, convertBodyWithBodyType, this.conversionService);
            if (convertBodyWithBodyType) {
                ExecutionFlow executionFlow = ExecutionFlow.just((Object)response);
                return executionFlow;
            }
            ExecutionFlow executionFlow = ExecutionFlow.error((Throwable)this.makeErrorFromRequestBody(errorType, fullHttpResponse.status(), (FullNettyClientHttpResponse<?>)response));
            return executionFlow;
        }
        catch (HttpClientResponseException t) {
            response = ExecutionFlow.error((Throwable)t);
            return response;
        }
        catch (Exception t) {
            response = new FullNettyClientHttpResponse((FullHttpResponse)fullHttpResponse, this.handlerRegistry, null, false, this.conversionService);
            HttpClientResponseException clientResponseError = this.decorate(new HttpClientResponseException("Error decoding HTTP response body: " + t.getMessage(), (Throwable)t, (HttpResponse)response, new HttpClientErrorDecoder(){

                public Argument<?> getErrorType(MediaType mediaType) {
                    return errorType;
                }
            }));
            ExecutionFlow executionFlow = ExecutionFlow.error((Throwable)clientResponseError);
            return executionFlow;
        }
        finally {
            fullHttpResponse.release();
        }
    }

    public <I, O, E> Publisher<O> retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        this.setupConversionService(request);
        Flux exchange = Flux.from(this.exchange(request, bodyType, errorType));
        if (bodyType.getType() == Void.TYPE) {
            return exchange.ignoreElements();
        }
        return exchange.map(response -> {
            if (bodyType.getType() == HttpStatus.class) {
                return response.getStatus();
            }
            Optional body = response.getBody();
            if (body.isEmpty() && response.getBody(byte[].class).isPresent()) {
                throw this.decorate(new HttpClientResponseException("Failed to decode the body for the given content type [%s]".formatted(response.getContentType().orElse(null)), response));
            }
            return body.orElseThrow(() -> this.decorate(new HttpClientResponseException("Empty body", response)));
        });
    }

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, MutableHttpRequest<?> request) {
        this.setupConversionService((HttpRequest<?>)request);
        Mono<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flux.from(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, request, clientEndpointType, null));
    }

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, Map<String, Object> parameters) {
        WebSocketBean webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        String uri = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("/ws");
        uri = UriTemplate.of((String)uri).expand(parameters);
        MutableHttpRequest request = HttpRequest.GET((String)uri);
        Mono<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flux.from(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, (MutableHttpRequest<?>)request, clientEndpointType, (WebSocketBean)webSocketBean));
    }

    @Override
    public void close() {
        this.stop();
    }

    private <T> Publisher<T> connectWebSocket(URI uri, MutableHttpRequest<?> request, Class<T> clientEndpointType, WebSocketBean<T> webSocketBean) {
        RequestKey requestKey;
        try {
            requestKey = new RequestKey(this, uri);
        }
        catch (HttpClientException e) {
            return Flux.error((Throwable)e);
        }
        if (webSocketBean == null) {
            webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        }
        WebSocketVersion protocolVersion = webSocketBean.getBeanDefinition().enumValue(ClientWebSocket.class, "version", WebSocketVersion.class).orElse(WebSocketVersion.V13);
        int maxFramePayloadLength = webSocketBean.messageMethod().map(m -> m.intValue(OnMessage.class, "maxPayloadLength").orElse(65536)).orElse(65536);
        String subprotocol = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class, "subprotocol").orElse("");
        URI webSocketURL = UriBuilder.of((URI)uri).scheme(!requestKey.isSecure() ? "ws" : "wss").host(requestKey.getHost()).port(requestKey.getPort()).build();
        MutableHttpHeaders headers = request.getHeaders();
        EmptyHttpHeaders customHeaders = EmptyHttpHeaders.INSTANCE;
        if (headers instanceof NettyHttpHeaders) {
            NettyHttpHeaders httpHeaders = (NettyHttpHeaders)headers;
            customHeaders = httpHeaders.getNettyHeaders();
        }
        if (StringUtils.isNotEmpty((CharSequence)subprotocol)) {
            NettyHttpHeaders.validateHeader((CharSequence)"Sec-WebSocket-Protocol", (CharSequence)subprotocol);
            customHeaders.add("Sec-WebSocket-Protocol", (Object)subprotocol);
        }
        NettyWebSocketClientHandler handler = new NettyWebSocketClientHandler(request, webSocketBean, WebSocketClientHandshakerFactory.newHandshaker((URI)webSocketURL, (WebSocketVersion)protocolVersion, (String)subprotocol, (boolean)true, (io.netty.handler.codec.http.HttpHeaders)customHeaders, (int)maxFramePayloadLength), this.requestBinderRegistry, this.mediaTypeCodecRegistry, this.handlerRegistry, this.conversionService);
        return this.connectionManager.connectForWebsocket(requestKey, (ChannelHandler)handler).then(handler.getHandshakeCompletedMono());
    }

    private <I> Flux<HttpResponse<ByteBuffer<?>>> exchangeStreamImpl(HttpRequest<Object> parentRequest, MutableHttpRequest<I> request, Argument<?> errorType, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        return streamResponsePublisher.switchMap(response -> {
            StreamedHttpResponse streamedHttpResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
            Flux httpContentReactiveSequence = Flux.from((Publisher)streamedHttpResponse);
            return httpContentReactiveSequence.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(message -> {
                ByteBuf byteBuf = message.content();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{byteBuf.readableBytes(), request.getMethodName(), request.getUri()});
                    this.traceBody("Response", byteBuf);
                }
                ByteBuffer byteBuffer = this.byteBufferFactory.wrap((Object)byteBuf);
                NettyStreamedHttpResponse<ByteBuffer> thisResponse = new NettyStreamedHttpResponse<ByteBuffer>(streamedHttpResponse, this.conversionService);
                thisResponse.setBody(byteBuffer);
                return new HttpResponseWrapper(thisResponse);
            });
        });
    }

    private <I, O> Flux<O> jsonStreamImpl(HttpRequest<?> parentRequest, MutableHttpRequest<I> request, Argument<O> type, Argument<?> errorType, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        return streamResponsePublisher.switchMap(response -> {
            if (!(response instanceof NettyStreamedHttpResponse)) {
                throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
            }
            StreamedHttpResponse streamResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
            MediaType mediaType = response.getContentType().orElse(MediaType.APPLICATION_JSON_STREAM_TYPE);
            ChunkedMessageBodyReader reader = (ChunkedMessageBodyReader)this.handlerRegistry.getReader(type, List.of(mediaType));
            return reader.readChunked(type, mediaType, (Headers)response.getHeaders(), (Publisher)Flux.from((Publisher)streamResponse).map(c -> NettyByteBufferFactory.DEFAULT.wrap(c.content())));
        });
    }

    private <I> Flux<ByteBuffer<?>> dataStreamImpl(MutableHttpRequest<I> request, Argument<?> errorType, HttpRequest<Object> parentRequest, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        Function<HttpContent, ByteBuffer> contentMapper = message -> {
            ByteBuf byteBuf = message.content();
            return this.byteBufferFactory.wrap((Object)byteBuf);
        };
        return streamResponsePublisher.switchMap(response -> {
            if (!(response instanceof NettyStreamedHttpResponse)) {
                throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
            }
            NettyStreamedHttpResponse nettyStreamedHttpResponse = (NettyStreamedHttpResponse)response;
            Flux httpContentReactiveSequence = Flux.from((Publisher)nettyStreamedHttpResponse.getNettyResponse());
            return httpContentReactiveSequence.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(contentMapper);
        });
    }

    private <I> Publisher<HttpResponse<?>> buildStreamExchange(@Nullable HttpRequest<?> parentRequest, @NonNull MutableHttpRequest<I> request, @NonNull URI requestURI, @Nullable Argument<?> errorType) {
        return this.sendRequestWithRedirects(parentRequest, null, request.uri(requestURI), (req, resp) -> {
            Flux body;
            ByteBody bb = resp.byteBody();
            if (!DefaultHttpClient.hasBody(resp)) {
                resp.close();
                body = Flux.empty();
            } else if (DefaultHttpClient.isAcceptEvents(req)) {
                if (bb instanceof AvailableNettyByteBody) {
                    AvailableNettyByteBody anbb = (AvailableNettyByteBody)bb;
                    ByteBuf single = AvailableNettyByteBody.toByteBuf((AvailableByteBody)anbb);
                    List<ByteBuf> parts = SseSplitter.split(single);
                    parts.get(parts.size() - 1).release();
                    body = Flux.fromIterable(parts.subList(0, parts.size() - 1)).map(DefaultHttpContent::new);
                } else {
                    body = SseSplitter.split((Flux<ByteBuf>)NettyByteBody.toByteBufs((ByteBody)bb), this.sizeLimits()).map(DefaultHttpContent::new);
                }
            } else {
                body = NettyByteBody.toByteBufs((ByteBody)bb).map(DefaultHttpContent::new);
            }
            return this.readBodyOnError(errorType, Mono.just(this.toStreamingResponse((NettyClientByteBodyResponse)resp, (Publisher<HttpContent>)body)).flatMap(r -> this.handleStreamHttpError(r, true)));
        });
    }

    private <B> MutableHttpResponse<B> toStreamingResponse(NettyClientByteBodyResponse resp, Publisher<HttpContent> content) {
        DefaultStreamedHttpResponse nettyResponse = new DefaultStreamedHttpResponse(resp.nettyResponse.protocolVersion(), resp.nettyResponse.status(), resp.getHeaders().getNettyHeaders(), content);
        return new NettyStreamedHttpResponse((StreamedHttpResponse)nettyResponse, this.conversionService);
    }

    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request) {
        return this.proxy(request, ProxyRequestOptions.getDefault());
    }

    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request, @NonNull ProxyRequestOptions options) {
        Objects.requireNonNull(options, "options");
        this.setupConversionService(request);
        return this.resolveRequestURI(request).flatMap(requestURI -> {
            MutableHttpRequest<?> httpRequest = this.toMutableRequest(request);
            if (!options.isRetainHostHeader()) {
                httpRequest.headers(headers -> headers.remove((CharSequence)HttpHeaderNames.HOST));
            }
            return this.sendRequestWithRedirects(request, null, httpRequest.uri(requestURI), (req, resp) -> {
                Flux body;
                if (!DefaultHttpClient.hasBody(resp)) {
                    resp.close();
                    body = Flux.empty();
                } else {
                    body = NettyByteBody.toByteBufs((ByteBody)resp.byteBody()).map(DefaultHttpContent::new);
                }
                return Mono.just(this.toStreamingResponse((NettyClientByteBodyResponse)resp, (Publisher<HttpContent>)body)).flatMap(r -> this.handleStreamHttpError(r, false));
            });
        }).map(HttpResponse::toMutableResponse);
    }

    private void setupConversionService(HttpRequest<?> httpRequest) {
        if (httpRequest instanceof ConversionServiceAware) {
            ConversionServiceAware aware = (ConversionServiceAware)httpRequest;
            aware.setConversionService(this.conversionService);
        }
    }

    protected <I> Mono<URI> resolveRequestURI(HttpRequest<I> request) {
        return this.resolveRequestURI(request, true);
    }

    protected <I> Mono<URI> resolveRequestURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Mono.just((Object)requestURI);
        }
        return this.resolveURI(request, includeContextPath);
    }

    protected <I> Mono<URI> resolveRedirectURI(HttpRequest<?> parentRequest, HttpRequest<I> request) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Mono.just((Object)requestURI);
        }
        if (parentRequest == null || parentRequest.getUri().getHost() == null) {
            return this.resolveURI(request, false);
        }
        URI parentURI = parentRequest.getUri();
        UriBuilder uriBuilder = UriBuilder.of((URI)requestURI).scheme(parentURI.getScheme()).userInfo(parentURI.getUserInfo()).host(parentURI.getHost()).port(parentURI.getPort());
        return Mono.just((Object)uriBuilder.build());
    }

    protected Object getLoadBalancerDiscriminator() {
        return null;
    }

    private NettyByteBody buildNettyRequest(MutableHttpRequest<?> request, URI requestURI, MediaType requestContentType, boolean permitsBody, EventLoop eventLoop) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        NettyHttpRequestBuilder nettyRequestBuilder;
        ByteBody direct;
        Optional body;
        if (!request.getHeaders().contains("Host")) {
            request.getHeaders().set((CharSequence)HttpHeaderNames.HOST, (CharSequence)this.getHostHeader(requestURI));
        }
        if (permitsBody && (body = request.getBody()).isPresent() && !request.getHeaders().contains("Content-Type")) {
            MediaType mediaType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            request.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)mediaType);
        }
        if ((direct = (nettyRequestBuilder = NettyHttpRequestBuilder.asBuilder(request)).byteBodyDirect()) != null) {
            return NettyBodyAdapter.adapt((ByteBody)direct, (EventLoop)eventLoop);
        }
        if (permitsBody) {
            ByteBuf bodyContent;
            Optional body2 = request.getBody();
            boolean hasBody = body2.isPresent();
            if (requestContentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && hasBody) {
                Object bodyValue = body2.get();
                if (bodyValue instanceof CharSequence) {
                    CharSequence sequence = (CharSequence)bodyValue;
                    ByteBuf byteBuf = this.charSequenceToByteBuf(sequence, requestContentType);
                    return new AvailableNettyByteBody(byteBuf);
                }
                return this.buildFormRequest(request, eventLoop, (ThrowingFunction<io.netty.handler.codec.http.HttpRequest, HttpPostRequestEncoder, HttpPostRequestEncoder.ErrorDataEncoderException>)((ThrowingFunction)r -> this.buildFormDataRequest((io.netty.handler.codec.http.HttpRequest)r, bodyValue)));
            }
            if (requestContentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE) && hasBody) {
                return this.buildFormRequest(request, eventLoop, (ThrowingFunction<io.netty.handler.codec.http.HttpRequest, HttpPostRequestEncoder, HttpPostRequestEncoder.ErrorDataEncoderException>)((ThrowingFunction)r -> this.buildMultipartRequest((io.netty.handler.codec.http.HttpRequest)r, body2.get())));
            }
            if (hasBody) {
                Object bodyValue = body2.get();
                if (Publishers.isConvertibleToPublisher(bodyValue)) {
                    boolean isSingle = Publishers.isSingle(bodyValue.getClass());
                    Publisher publisher = (Publisher)this.conversionService.convert(bodyValue, Publisher.class).orElseThrow(() -> new IllegalArgumentException("Unconvertible reactive type: " + bodyValue));
                    Flux requestBodyPublisher = Flux.from((Publisher)publisher).map(value -> {
                        Argument type = Argument.ofInstance((Object)value);
                        ByteBuffer buffer = this.handlerRegistry.getWriter(type, List.of(requestContentType)).writeTo(type, requestContentType, value, (MutableHeaders)request.getHeaders(), this.byteBufferFactory);
                        return new DefaultHttpContent((ByteBuf)buffer.asNativeBuffer());
                    });
                    if (!isSingle && MediaType.APPLICATION_JSON_TYPE.equals((Object)requestContentType)) {
                        requestBodyPublisher = JsonSubscriber.lift((Publisher)requestBodyPublisher);
                    }
                    return NettyBodyAdapter.adapt((Publisher)requestBodyPublisher.map(ByteBufHolder::content), (EventLoop)eventLoop, (io.netty.handler.codec.http.HttpHeaders)nettyRequestBuilder.toHttpRequestWithoutBody().headers(), null);
                }
                if (bodyValue instanceof CharSequence) {
                    CharSequence sequence = (CharSequence)bodyValue;
                    bodyContent = this.charSequenceToByteBuf(sequence, requestContentType);
                } else {
                    Argument type = Argument.ofInstance(bodyValue);
                    ByteBuffer buffer = this.handlerRegistry.getWriter(type, List.of(requestContentType)).writeTo(type, requestContentType, bodyValue, (MutableHeaders)request.getHeaders(), this.byteBufferFactory);
                    bodyContent = (ByteBuf)buffer.asNativeBuffer();
                }
                if (bodyContent == null) {
                    bodyContent = (ByteBuf)this.conversionService.convert(bodyValue, ByteBuf.class).orElseThrow(() -> this.decorate(new HttpClientException("Body [" + bodyValue + "] cannot be encoded to content type [" + requestContentType + "]. No possible codecs or converters found.")));
                }
            } else {
                bodyContent = Unpooled.EMPTY_BUFFER;
            }
            return new AvailableNettyByteBody(bodyContent);
        }
        return (NettyByteBody)AvailableNettyByteBody.empty();
    }

    private static boolean requiresRequestBody(io.netty.handler.codec.http.HttpMethod method) {
        return method != null && (method.equals((Object)io.netty.handler.codec.http.HttpMethod.POST) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.PUT) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.PATCH));
    }

    private static boolean permitsRequestBody(io.netty.handler.codec.http.HttpMethod method) {
        return method != null && (DefaultHttpClient.requiresRequestBody(method) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.OPTIONS) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.DELETE));
    }

    private Mono<HttpResponse<?>> readBodyOnError(final @Nullable Argument<?> errorType, @NonNull Mono<HttpResponse<?>> publisher) {
        if (errorType != null && errorType != HttpClient.DEFAULT_ERROR_TYPE) {
            return publisher.onErrorResume(clientException -> {
                HttpClientResponseException exception;
                HttpResponse response;
                if (clientException instanceof HttpClientResponseException && (response = (exception = (HttpClientResponseException)((Object)clientException)).getResponse()) instanceof NettyStreamedHttpResponse) {
                    NettyStreamedHttpResponse streamedResponse = (NettyStreamedHttpResponse)response;
                    return Mono.create(emitter -> {
                        final StreamedHttpResponse nettyResponse = streamedResponse.getNettyResponse();
                        nettyResponse.subscribe((Subscriber)new Subscriber<HttpContent>(){
                            final CompositeByteBuf buffer;
                            Subscription s;
                            {
                                this.buffer = ((ByteBufAllocator)DefaultHttpClient.this.byteBufferFactory.getNativeAllocator()).compositeBuffer();
                            }

                            public void onSubscribe(Subscription s) {
                                this.s = s;
                                s.request(1L);
                            }

                            public void onNext(HttpContent httpContent) {
                                this.buffer.addComponent(true, httpContent.content());
                                this.s.request(1L);
                            }

                            public void onError(Throwable t) {
                                this.buffer.release();
                                emitter.error(t);
                            }

                            public void onComplete() {
                                try {
                                    DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(nettyResponse.protocolVersion(), nettyResponse.status(), (ByteBuf)this.buffer, nettyResponse.headers(), (io.netty.handler.codec.http.HttpHeaders)new DefaultHttpHeaders(true));
                                    FullNettyClientHttpResponse fullNettyClientHttpResponse = new FullNettyClientHttpResponse((FullHttpResponse)fullHttpResponse, DefaultHttpClient.this.handlerRegistry, errorType, true, DefaultHttpClient.this.conversionService);
                                    emitter.error((Throwable)DefaultHttpClient.this.decorate(new HttpClientResponseException(fullHttpResponse.status().reasonPhrase(), null, fullNettyClientHttpResponse, new HttpClientErrorDecoder(){

                                        public Argument<?> getErrorType(MediaType mediaType) {
                                            return errorType;
                                        }
                                    })));
                                }
                                finally {
                                    this.buffer.release();
                                }
                            }
                        });
                    });
                }
                return Mono.error((Throwable)clientException);
            });
        }
        return publisher;
    }

    private <I> Mono<URI> resolveURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (this.loadBalancer == null) {
            return Mono.error((Throwable)this.decorate(new NoHostException("Request URI specifies no host to connect to")));
        }
        return Mono.from((Publisher)this.loadBalancer.select(this.getLoadBalancerDiscriminator())).map(server -> {
            Optional authInfo = server.getMetadata().get((CharSequence)"Authorization-Info", String.class);
            if (request instanceof MutableHttpRequest) {
                MutableHttpRequest httpRequest = (MutableHttpRequest)request;
                if (authInfo.isPresent()) {
                    httpRequest.getHeaders().auth((String)authInfo.get());
                }
            }
            try {
                return server.resolve(includeContextPath ? ContextPathUtils.prepend((URI)requestURI, (String)this.contextPath) : requestURI);
            }
            catch (URISyntaxException e) {
                throw this.decorate(new HttpClientException("Failed to construct the request URI", (Throwable)e));
            }
        });
    }

    private <R extends HttpResponse<?>> Mono<R> handleStreamHttpError(R response, boolean failOnError) {
        boolean errorStatus;
        boolean bl = errorStatus = response.code() >= 400;
        if (errorStatus && failOnError) {
            return Mono.error((Throwable)this.decorate(new HttpClientResponseException(response.reason(), response)));
        }
        return Mono.just(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publisher<? extends HttpResponse<?>> exchange(HttpRequest<?> request, @Nullable CloseableByteBody requestBody, @Nullable Thread blockedThread) {
        if (requestBody == null) {
            requestBody = AvailableNettyByteBody.empty();
        }
        Mono<HttpResponse<?>> mono = null;
        try {
            mono = this.sendRequestWithRedirects(ServerRequestContext.currentRequest().orElse(null), blockedThread == null ? null : new BlockHint(blockedThread, null), new RawHttpRequestWrapper(this.conversionService, request.toMutableRequest(), requestBody), (req, resp) -> Mono.just((Object)resp));
        }
        finally {
            if (mono == null) {
                requestBody.close();
            }
        }
        return mono.doOnTerminate(() -> ((CloseableByteBody)requestBody).close());
    }

    private Mono<HttpResponse<?>> sendRequestWithRedirects(final HttpRequest<?> parentRequest, final @Nullable BlockHint blockHint, MutableHttpRequest<?> request, final BiFunction<MutableHttpRequest<?>, NettyClientByteBodyResponse, ? extends Mono<? extends HttpResponse<?>>> readResponse) {
        if (this.informationalServiceId != null && request.getAttribute((CharSequence)HttpAttributes.SERVICE_ID).isEmpty()) {
            request.setAttribute((CharSequence)HttpAttributes.SERVICE_ID, (Object)this.informationalServiceId);
        }
        List filters = this.filterResolver.resolveFilters(request, this.clientFilterEntries);
        if (parentRequest != null) {
            filters.add(GenericHttpFilter.createLegacyFilter((HttpFilter)new ClientServerContextFilter(parentRequest), (FilterOrder)new FilterOrder.Fixed(Integer.MIN_VALUE)));
        }
        FilterRunner.sortReverse((List)filters);
        FilterRunner runner = new FilterRunner(filters){

            protected ExecutionFlow<HttpResponse<?>> provideResponse(HttpRequest<?> request, PropagatedContext propagatedContext) {
                ReactiveExecutionFlow reactiveExecutionFlow;
                block8: {
                    PropagatedContext.Scope ignore = propagatedContext.propagate();
                    try {
                        reactiveExecutionFlow = ReactiveExecutionFlow.fromPublisher((Publisher)Mono.from(DefaultHttpClient.this.sendRequestWithRedirectsNoFilter(parentRequest, blockHint, MutableHttpRequestWrapper.wrapIfNecessary(DefaultHttpClient.this.conversionService, request), readResponse)));
                        if (ignore == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignore != null) {
                                try {
                                    ignore.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable e) {
                            return ExecutionFlow.error((Throwable)e);
                        }
                    }
                    ignore.close();
                }
                return reactiveExecutionFlow;
            }
        };
        Mono responseMono = Mono.from((Publisher)ReactiveExecutionFlow.fromFlow((ExecutionFlow)runner.run(request)).toPublisher());
        if (parentRequest != null) {
            responseMono = responseMono.contextWrite(c -> {
                if (c.hasKey((Object)"micronaut.http.server.request")) {
                    return c;
                }
                return c.put((Object)"micronaut.http.server.request", (Object)parentRequest);
            });
        }
        return responseMono;
    }

    private Mono<HttpResponse<?>> sendRequestWithRedirectsNoFilter(HttpRequest<?> parentRequest, @Nullable BlockHint blockHint, MutableHttpRequest<?> request, BiFunction<MutableHttpRequest<?>, NettyClientByteBodyResponse, ? extends Mono<? extends HttpResponse<?>>> readResponse) {
        RequestKey requestKey;
        try {
            requestKey = new RequestKey(this, request.getUri());
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return this.connectionManager.connect(requestKey, blockHint).flatMap(poolHandle -> {
            NettyByteBody byteBody;
            request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)poolHandle.channel);
            URI requestURI = request.getUri();
            boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
            try {
                byteBody = this.buildNettyRequest(request, requestURI, request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE), permitsBody, poolHandle.channel.eventLoop());
            }
            catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
                poolHandle.release();
                return Mono.error((Throwable)e);
            }
            return this.sendRawRequest((ConnectionManager.PoolHandle)poolHandle, (HttpRequest<?>)request, byteBody);
        }).flatMap(byteBodyResponse -> {
            int code = byteBodyResponse.code();
            io.netty.handler.codec.http.HttpHeaders nettyHeaders = byteBodyResponse.getHeaders().getNettyHeaders();
            if (code > 300 && code < 400 && this.configuration.isFollowRedirects() && nettyHeaders.contains((CharSequence)HttpHeaderNames.LOCATION)) {
                MutableHttpRequest redirectRequest;
                byteBodyResponse.close();
                String location = nettyHeaders.get((CharSequence)HttpHeaderNames.LOCATION);
                if (code == 307 || code == 308) {
                    redirectRequest = HttpRequest.create((HttpMethod)request.getMethod(), (String)location);
                    request.getBody().ifPresent(arg_0 -> ((MutableHttpRequest)redirectRequest).body(arg_0));
                } else {
                    redirectRequest = HttpRequest.GET((String)location);
                }
                DefaultHttpClient.setRedirectHeaders(request, (MutableHttpRequest<Object>)redirectRequest);
                return this.resolveRedirectURI((HttpRequest<?>)request, (HttpRequest)redirectRequest).flatMap(uri -> this.sendRequestWithRedirects(parentRequest, blockHint, redirectRequest.uri(uri), readResponse));
            }
            NettyHttpHeaders headers = byteBodyResponse.getHeaders();
            if (this.log.isTraceEnabled()) {
                this.log.trace("HTTP Client Response Received ({}) for Request: {} {}", new Object[]{byteBodyResponse.code(), request.getMethodName(), request.getUri()});
                HttpHeadersUtil.trace((Logger)this.log, (Set)headers.names(), arg_0 -> ((HttpHeaders)headers).getAll(arg_0));
            }
            return (Mono)readResponse.apply(request, (NettyClientByteBodyResponse)byteBodyResponse);
        });
    }

    private Mono<NettyClientByteBodyResponse> sendRawRequest(final ConnectionManager.PoolHandle poolHandle, HttpRequest<?> request, NettyByteBody byteBody) {
        URI uri = request.getUri();
        Object uriWithoutHost = uri.getRawPath();
        if (uri.getRawQuery() != null) {
            uriWithoutHost = (String)uriWithoutHost + "?" + uri.getRawQuery();
        }
        io.netty.handler.codec.http.HttpRequest nettyRequest = NettyHttpRequestBuilder.asBuilder(request).toHttpRequestWithoutBody().setUri((String)uriWithoutHost);
        return Mono.create(sink -> {
            StreamWriter streamWriter;
            ByteBuf byteBuf;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending HTTP {} to {}", (Object)request.getMethodName(), (Object)request.getUri());
            }
            final boolean expectContinue = HttpUtil.is100ContinueExpected((HttpMessage)nettyRequest);
            ChannelPipeline pipeline = poolHandle.channel.pipeline();
            if (byteBody instanceof AvailableNettyByteBody) {
                AvailableNettyByteBody available = (AvailableNettyByteBody)byteBody;
                byteBuf = AvailableNettyByteBody.toByteBuf((AvailableByteBody)available);
                streamWriter = null;
            } else {
                streamWriter = new StreamWriter((StreamingNettyByteBody)byteBody, e -> {
                    poolHandle.taint();
                    sink.error(e);
                });
                pipeline.addLast(new ChannelHandler[]{streamWriter});
                byteBuf = null;
            }
            if (this.log.isTraceEnabled()) {
                HttpHeadersUtil.trace((Logger)this.log, (Set)nettyRequest.headers().names(), arg_0 -> ((io.netty.handler.codec.http.HttpHeaders)nettyRequest.headers()).getAll(arg_0));
                if (byteBuf != null) {
                    this.traceBody("Request", byteBuf);
                }
            }
            pipeline.addLast("micronaut-http-response", (ChannelHandler)new Http1ResponseHandler(new Http1ResponseHandler.ResponseListener(){
                boolean stillExpectingContinue;
                final /* synthetic */ MonoSink val$sink;
                final /* synthetic */ HttpRequest val$request;
                final /* synthetic */ StreamWriter val$streamWriter;
                final /* synthetic */ ByteBuf val$byteBuf;
                final /* synthetic */ io.netty.handler.codec.http.HttpRequest val$nettyRequest;
                {
                    this.val$sink = monoSink;
                    this.val$request = httpRequest;
                    this.val$streamWriter = streamWriter;
                    this.val$byteBuf = byteBuf;
                    this.val$nettyRequest = httpRequest2;
                    this.stillExpectingContinue = expectContinue;
                }

                @Override
                public void fail(ChannelHandlerContext ctx, Throwable cause) {
                    poolHandle.taint();
                    this.val$sink.error((Throwable)DefaultHttpClient.this.handleResponseError(this.val$request, cause));
                }

                @Override
                public void continueReceived(ChannelHandlerContext ctx) {
                    if (this.stillExpectingContinue) {
                        this.stillExpectingContinue = false;
                        if (this.val$streamWriter == null) {
                            ctx.writeAndFlush((Object)new DefaultLastHttpContent(this.val$byteBuf), ctx.voidPromise());
                        } else {
                            this.val$streamWriter.startWriting();
                        }
                    }
                }

                @Override
                public void complete(io.netty.handler.codec.http.HttpResponse response, CloseableByteBody body) {
                    if (!HttpUtil.isKeepAlive((HttpMessage)response)) {
                        poolHandle.taint();
                    }
                    this.val$sink.success((Object)new NettyClientByteBodyResponse(response, body, DefaultHttpClient.this.conversionService));
                }

                @Override
                public BodySizeLimits sizeLimits() {
                    return DefaultHttpClient.this.sizeLimits();
                }

                @Override
                public boolean isHeadResponse() {
                    return this.val$nettyRequest.method().equals((Object)io.netty.handler.codec.http.HttpMethod.HEAD);
                }

                @Override
                public void finish(ChannelHandlerContext ctx) {
                    ctx.pipeline().remove("micronaut-http-response");
                    if (this.val$streamWriter != null) {
                        if (!this.val$streamWriter.isCompleted()) {
                            poolHandle.taint();
                        }
                        ctx.pipeline().remove((ChannelHandler)this.val$streamWriter);
                    }
                    if (this.stillExpectingContinue && this.val$byteBuf != null) {
                        this.val$byteBuf.release();
                    }
                    poolHandle.release();
                }
            }));
            poolHandle.notifyRequestPipelineBuilt();
            io.netty.handler.codec.http.HttpHeaders headers = nettyRequest.headers();
            OptionalLong length = byteBody.expectedLength();
            if (length.isPresent()) {
                headers.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                if (length.getAsLong() != 0L || DefaultHttpClient.permitsRequestBody(nettyRequest.method())) {
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)length.getAsLong());
                }
            } else {
                headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            if (!poolHandle.http2) {
                if (poolHandle.canReturn()) {
                    nettyRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                } else {
                    nettyRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                }
            }
            Channel channel = poolHandle.channel();
            if (streamWriter == null) {
                if (!expectContinue) {
                    channel.writeAndFlush((Object)new DefaultFullHttpRequest(nettyRequest.protocolVersion(), nettyRequest.method(), nettyRequest.uri(), byteBuf, nettyRequest.headers(), (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE), channel.voidPromise());
                } else {
                    channel.writeAndFlush((Object)nettyRequest, channel.voidPromise());
                }
            } else {
                channel.writeAndFlush((Object)nettyRequest, channel.voidPromise());
                if (!expectContinue) {
                    streamWriter.startWriting();
                }
            }
        }).subscribeOn(Schedulers.fromExecutor((Executor)poolHandle.channel.eventLoop()));
    }

    private ByteBuf charSequenceToByteBuf(CharSequence bodyValue, MediaType requestContentType) {
        return (ByteBuf)this.byteBufferFactory.copiedBuffer(bodyValue.toString().getBytes(requestContentType.getCharset().orElse(this.defaultCharset))).asNativeBuffer();
    }

    private String getHostHeader(URI requestURI) {
        RequestKey requestKey = new RequestKey(this, requestURI);
        StringBuilder host = new StringBuilder(requestKey.getHost());
        int port = requestKey.getPort();
        if (port > -1 && port != 80 && port != 443) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    private NettyByteBody buildFormRequest(MutableHttpRequest<?> request, EventLoop eventLoop, ThrowingFunction<io.netty.handler.codec.http.HttpRequest, HttpPostRequestEncoder, HttpPostRequestEncoder.ErrorDataEncoderException> buildMethod) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, io.netty.handler.codec.http.HttpMethod.GET, "/");
        List<AsciiString> relevantHeaders = List.of(HttpHeaderNames.CONTENT_TYPE);
        for (AsciiString header : relevantHeaders) {
            nettyRequest.headers().add((CharSequence)header, (Iterable)request.getHeaders().getAll((CharSequence)header));
        }
        HttpPostRequestEncoder encoder = (HttpPostRequestEncoder)buildMethod.apply((Object)nettyRequest);
        io.netty.handler.codec.http.HttpRequest finalized = encoder.finalizeRequest();
        for (AsciiString header : relevantHeaders) {
            request.getHeaders().remove((CharSequence)header);
            for (String value : finalized.headers().getAll((CharSequence)header)) {
                request.getHeaders().add((CharSequence)header, (CharSequence)value);
            }
        }
        if (encoder.isChunked()) {
            Flux bytes = Flux.create(em -> {
                em.onRequest(n -> {
                    try {
                        while (n-- > 0L) {
                            HttpContent chunk = encoder.readChunk((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
                            if (chunk == null) {
                                assert (encoder.isEndOfInput());
                                em.complete();
                                break;
                            }
                            em.next((Object)chunk.content());
                        }
                    }
                    catch (Exception e) {
                        em.error((Throwable)e);
                    }
                });
                em.onDispose(() -> ((HttpPostRequestEncoder)encoder).cleanFiles());
            });
            if (this.blockingExecutor != null && encoder.getBodyListAttributes().stream().anyMatch(d -> {
                HttpData hd;
                return !(d instanceof HttpData) || !(hd = (HttpData)d).isInMemory();
            })) {
                bytes = bytes.subscribeOn(Schedulers.fromExecutor((Executor)this.blockingExecutor));
            }
            return NettyBodyAdapter.adapt((Publisher)bytes, (EventLoop)eventLoop);
        }
        return new AvailableNettyByteBody(((FullHttpRequest)finalized).content());
    }

    private HttpPostRequestEncoder buildFormDataRequest(io.netty.handler.codec.http.HttpRequest baseRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder(baseRequest, false);
        Map formData = bodyValue instanceof Map ? (Map)bodyValue : BeanMap.of((Object)bodyValue);
        for (Map.Entry entry : formData.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object val : collection) {
                    this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), val);
                }
                continue;
            }
            this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), value);
        }
        return postRequestEncoder;
    }

    private void addBodyAttribute(HttpPostRequestEncoder postRequestEncoder, String key, Object value) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        Optional converted = this.conversionService.convert(value, String.class);
        if (converted.isPresent()) {
            postRequestEncoder.addBodyAttribute(key, (String)converted.get());
        }
    }

    private HttpPostRequestEncoder buildMultipartRequest(io.netty.handler.codec.http.HttpRequest baseRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder((HttpDataFactory)factory, baseRequest, true, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        if (bodyValue instanceof MultipartBody.Builder) {
            MultipartBody.Builder builder = (MultipartBody.Builder)bodyValue;
            bodyValue = builder.build();
        }
        if (!(bodyValue instanceof MultipartBody)) {
            throw new MultipartException("The type %s is not a supported type for a multipart request body".formatted(bodyValue.getClass().getName()));
        }
        MultipartBody multipartBody = (MultipartBody)bodyValue;
        postRequestEncoder.setBodyHttpDatas(multipartBody.getData((MultipartDataFactory)new MultipartDataFactory<InterfaceHttpData>((HttpDataFactory)factory, baseRequest){
            final /* synthetic */ HttpDataFactory val$factory;
            final /* synthetic */ io.netty.handler.codec.http.HttpRequest val$baseRequest;
            {
                this.val$factory = httpDataFactory;
                this.val$baseRequest = httpRequest;
            }

            @NonNull
            public InterfaceHttpData createFileUpload(@NonNull String name, @NonNull String filename, @NonNull MediaType contentType, @Nullable String encoding, @Nullable Charset charset, long length) {
                return this.val$factory.createFileUpload(this.val$baseRequest, name, filename, contentType.toString(), encoding, charset, length);
            }

            @NonNull
            public InterfaceHttpData createAttribute(@NonNull String name, @NonNull String value) {
                return this.val$factory.createAttribute(this.val$baseRequest, name, value);
            }

            public void setContent(InterfaceHttpData fileUploadObject, Object content) throws IOException {
                if (fileUploadObject instanceof FileUpload) {
                    FileUpload fu = (FileUpload)fileUploadObject;
                    if (content instanceof InputStream) {
                        InputStream stream = (InputStream)content;
                        fu.setContent(stream);
                    } else if (content instanceof File) {
                        File file = (File)content;
                        fu.setContent(file);
                    } else if (content instanceof byte[]) {
                        byte[] bytes = (byte[])content;
                        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bytes);
                        fu.setContent(buffer);
                    }
                }
            }
        }));
        return postRequestEncoder;
    }

    private void traceBody(String type, ByteBuf content) {
        this.log.trace("{} Body", (Object)type);
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceChunk(ByteBuf content) {
        this.log.trace("Sending Chunk");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private static MediaTypeCodecRegistry createDefaultMediaTypeRegistry() {
        JsonMapper mapper = JsonMapper.createDefault();
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        return MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec(mapper, configuration, null), new JsonStreamMediaTypeCodec(mapper, configuration, null)});
    }

    private static MessageBodyHandlerRegistry createDefaultMessageBodyHandlerRegistry() {
        ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration();
        ContextlessMessageBodyHandlerRegistry registry = new ContextlessMessageBodyHandlerRegistry(applicationConfiguration, (ByteBufferFactory)NettyByteBufferFactory.DEFAULT, new TypedMessageBodyHandler[]{new NettyByteBufMessageBodyHandler(), new NettyWritableBodyWriter(applicationConfiguration)});
        JsonMapper mapper = JsonMapper.createDefault();
        registry.add(MediaType.APPLICATION_JSON_TYPE, (MessageBodyHandler)new NettyJsonHandler(mapper));
        registry.add(MediaType.APPLICATION_JSON_TYPE, (MessageBodyWriter)new NettyCharSequenceBodyWriter());
        registry.add(MediaType.APPLICATION_JSON_STREAM_TYPE, (MessageBodyHandler)new NettyJsonStreamHandler(mapper));
        return registry;
    }

    static boolean isSecureScheme(String scheme) {
        return "https".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
    }

    private <E extends HttpClientException> E decorate(E exc) {
        return (E)((Object)HttpClientExceptionUtils.populateServiceId(exc, (String)this.informationalServiceId, (HttpClientConfiguration)this.configuration));
    }

    @NonNull
    private HttpClientException handleResponseError(HttpRequest<?> finalRequest, Throwable cause) {
        Object result;
        String message = cause.getMessage();
        if (message == null) {
            message = cause.getClass().getSimpleName();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("HTTP Client exception ({}) occurred for request : {} {}", new Object[]{message, finalRequest.getMethodName(), finalRequest.getUri()});
        }
        if (cause instanceof ContentLengthExceededException) {
            ContentLengthExceededException clee = (ContentLengthExceededException)cause;
            result = this.decorate(new io.micronaut.http.client.exceptions.ContentLengthExceededException(clee.getMessage()));
        } else if (cause instanceof BufferLengthExceededException) {
            BufferLengthExceededException blee = (BufferLengthExceededException)cause;
            result = this.decorate(new io.micronaut.http.client.exceptions.ContentLengthExceededException(blee.getAdvertisedLength(), blee.getReceivedLength()));
        } else if (cause instanceof io.netty.handler.timeout.ReadTimeoutException) {
            result = ReadTimeoutException.TIMEOUT_EXCEPTION;
        } else if (cause instanceof HttpClientException) {
            HttpClientException hce = (HttpClientException)cause;
            result = this.decorate(hce);
        } else {
            result = this.decorate(new HttpClientException("Error occurred reading HTTP response: " + message, cause));
        }
        return result;
    }

    private static void setRedirectHeaders(@Nullable HttpRequest<?> request, MutableHttpRequest<Object> redirectRequest) {
        if (request != null) {
            for (Map.Entry originalHeader : request.getHeaders()) {
                List originalHeaderValue;
                if (REDIRECT_HEADER_BLOCKLIST.contains((String)originalHeader.getKey()) || (originalHeaderValue = (List)originalHeader.getValue()) == null || originalHeaderValue.isEmpty()) continue;
                for (String value : originalHeaderValue) {
                    if (value == null) continue;
                    redirectRequest.header((CharSequence)originalHeader.getKey(), (CharSequence)value);
                }
            }
        }
    }

    private BodySizeLimits sizeLimits() {
        return new BodySizeLimits(Long.MAX_VALUE, (long)this.configuration.getMaxContentLength());
    }

    private static <O, E> boolean shouldConvertWithBodyType(io.netty.handler.codec.http.HttpResponse msg, HttpClientConfiguration configuration, Argument<O> bodyType, Argument<E> errorType) {
        if (msg.status().code() < 400) {
            return true;
        }
        return !configuration.isExceptionOnErrorStatus() && bodyType.equalsType(errorType);
    }

    private HttpClientResponseException makeErrorBodyParseError(FullHttpResponse fullResponse, Throwable t) {
        FullNettyClientHttpResponse errorResponse = new FullNettyClientHttpResponse(fullResponse, this.handlerRegistry, null, false, this.conversionService);
        return this.decorate(new HttpClientResponseException("Error decoding HTTP error response body: " + t.getMessage(), t, errorResponse, null));
    }

    private HttpClientResponseException makeErrorFromRequestBody(final Argument<?> errorType, HttpResponseStatus status, FullNettyClientHttpResponse<?> response) {
        if (errorType != null && errorType != HttpClient.DEFAULT_ERROR_TYPE) {
            return this.decorate(new HttpClientResponseException(status.reasonPhrase(), null, response, new HttpClientErrorDecoder(){

                public Argument<?> getErrorType(MediaType mediaType) {
                    return errorType;
                }
            }));
        }
        return this.decorate(new HttpClientResponseException(status.reasonPhrase(), response));
    }

    private static boolean hasBody(HttpResponse<?> response) {
        if (response.code() >= HttpStatus.CONTINUE.getCode() && response.code() < HttpStatus.OK.getCode()) {
            return false;
        }
        if (response.code() == HttpResponseStatus.NO_CONTENT.code() || response.code() == HttpResponseStatus.NOT_MODIFIED.code()) {
            return false;
        }
        OptionalLong contentLength = response.getHeaders().contentLength();
        return contentLength.isEmpty() || contentLength.getAsLong() != 0L;
    }

    static {
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.HOST, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"");
    }

    public static final class RequestKey {
        private final String host;
        private final int port;
        private final boolean secure;

        public RequestKey(DefaultHttpClient ctx, URI requestURI) {
            int port;
            this.secure = DefaultHttpClient.isSecureScheme(requestURI.getScheme());
            String host = requestURI.getHost();
            if (host == null) {
                host = requestURI.getAuthority();
                if (host == null) {
                    throw this.decorate(ctx, new NoHostException("URI specifies no host to connect to"));
                }
                int i = host.indexOf(58);
                if (i > -1) {
                    String portStr = host.substring(i + 1);
                    host = host.substring(0, i);
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw this.decorate(ctx, new HttpClientException("URI specifies an invalid port: " + portStr));
                    }
                } else {
                    port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
                }
            } else {
                port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
            }
            this.host = host;
            this.port = port;
        }

        public InetSocketAddress getRemoteAddress() {
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestKey that = (RequestKey)o;
            return this.port == that.port && this.secure == that.secure && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return ObjectUtils.hash((Object)this.host, (Object)this.port, (Object)this.secure);
        }

        private <E extends HttpClientException> E decorate(DefaultHttpClient ctx, E exc) {
            return (E)HttpClientExceptionUtils.populateServiceId(exc, (String)ctx.informationalServiceId, (HttpClientConfiguration)ctx.configuration);
        }
    }

    private static final class CurrentEvent {
        byte[] data;
        String id;
        String name;
        Duration retry;

        private CurrentEvent() {
        }
    }
}

