/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.json.JsonSyntaxException;
import io.netty.buffer.ByteBuf;

@Internal
public final class JsonCounter {
    private long position;
    private int depth;
    private State state = State.BASE;
    private long bufferStart = -1L;
    private boolean unwrappingArray;
    private boolean allowUnwrappingArrayComma;
    @Nullable
    private BufferRegion lastFlushedRegion;

    public void feed(ByteBuf buf) throws JsonSyntaxException {
        int r;
        if (this.position < 4L && ((r = buf.readableBytes()) >= 1 && buf.getByte(0) == 0 || r >= 2 && buf.getByte(1) == 0 || r >= 3 && buf.getByte(2) == 0 || r >= 4 && buf.getByte(3) == 0)) {
            throw new JsonSyntaxException("Input must be legal UTF-8 JSON");
        }
        if (!this.isBuffering()) {
            this.proceedUntilBuffering(buf);
        }
        if (this.isBuffering()) {
            this.proceedUntilNonBuffering(buf);
        }
    }

    public void unwrapTopLevelArray() {
        if (this.position != 0L) {
            throw new IllegalStateException("Already consumed input");
        }
        this.state = State.BEFORE_UNWRAP_ARRAY;
        this.bufferStart = -1L;
    }

    public void noTokenization() {
        if (this.position != 0L) {
            throw new IllegalStateException("Already consumed input");
        }
        this.state = State.BUFFER_ALL;
        this.bufferStart = 0L;
    }

    private void proceedUntilNonBuffering(ByteBuf buf) throws JsonSyntaxException {
        assert (this.isBuffering());
        int end = buf.writerIndex();
        int i = buf.readerIndex();
        while (i < end && this.bufferStart != -1L) {
            int start = i;
            if (this.state == State.BASE) {
                assert (this.depth > 0) : this.depth;
                while (i < end && JsonCounter.skipBufferingBase(buf.getByte(i))) {
                    ++i;
                }
                this.position += (long)(i - start);
                if (i >= end) continue;
                this.handleBufferingBaseSpecial(buf.getByte(i));
                ++i;
                ++this.position;
                continue;
            }
            if (this.state == State.STRING) {
                while (i < end && JsonCounter.skipString(buf.getByte(i))) {
                    ++i;
                }
                this.position += (long)(i - start);
                if (i >= end) continue;
                this.handleStringSpecial(buf.getByte(i));
                ++i;
                ++this.position;
                continue;
            }
            if (this.state == State.ESCAPE) {
                this.handleEscape(buf.getByte(i));
                ++i;
                ++this.position;
                continue;
            }
            if (this.state == State.TOP_LEVEL_SCALAR) {
                assert (this.depth == 0) : this.depth;
                while (i < end && JsonCounter.skipTopLevelScalar(buf.getByte(i))) {
                    ++i;
                }
                this.position += (long)(i - start);
                if (i >= end) continue;
                this.handleTopLevelScalarSpecial(buf.getByte(i));
                ++i;
                ++this.position;
                continue;
            }
            if (this.state == State.BUFFER_ALL) {
                i = end;
                this.position += (long)(i - start);
                continue;
            }
            throw new AssertionError((Object)this.state);
        }
        buf.readerIndex(i);
    }

    private void proceedUntilBuffering(ByteBuf buf) throws JsonSyntaxException {
        assert (!this.isBuffering());
        assert (this.depth == 0) : this.depth;
        int start = buf.readerIndex();
        int end = buf.writerIndex();
        int i = start;
        if (this.state == State.AFTER_UNWRAP_ARRAY) {
            JsonCounter.skipWs(buf, i, end);
            if (i < end) {
                throw new JsonSyntaxException("Superfluous data after top-level array in streaming mode");
            }
        } else {
            assert (this.state == State.BASE || this.state == State.BEFORE_UNWRAP_ARRAY) : this.state;
            if (this.position == 0L && i < end && buf.getByte(i) == -17) {
                throw new JsonSyntaxException("UTF-8 BOM not allowed");
            }
            if (this.allowUnwrappingArrayComma && (i = JsonCounter.skipWs(buf, i, end)) < end && buf.getByte(i) == 44) {
                this.allowUnwrappingArrayComma = false;
                ++i;
            }
            i = JsonCounter.skipWs(buf, i, end);
            this.position += (long)(i - start);
            if (i < end) {
                byte b = buf.getByte(i);
                this.handleNonBufferingBase(b);
                ++i;
                ++this.position;
            }
        }
        buf.readerIndex(i);
    }

    private static int skipWs(ByteBuf buf, int i, int end) {
        while (i < end && JsonCounter.ws(buf.getByte(i))) {
            ++i;
        }
        return i;
    }

    private void handleNonBufferingBase(byte b) throws JsonSyntaxException {
        switch (b) {
            case 125: {
                JsonCounter.failMismatchedBrackets();
                break;
            }
            case 93: {
                if (this.unwrappingArray) {
                    this.state = State.AFTER_UNWRAP_ARRAY;
                    break;
                }
                JsonCounter.failMismatchedBrackets();
                break;
            }
            case 123: {
                this.depth = 1;
                this.bufferStart = this.position;
                this.state = State.BASE;
                break;
            }
            case 91: {
                if (this.state == State.BEFORE_UNWRAP_ARRAY) {
                    this.state = State.BASE;
                    this.unwrappingArray = true;
                    break;
                }
                this.depth = 1;
                this.bufferStart = this.position;
                break;
            }
            case 34: {
                this.state = State.STRING;
                this.bufferStart = this.position;
                break;
            }
            default: {
                this.state = State.TOP_LEVEL_SCALAR;
                this.bufferStart = this.position;
            }
        }
    }

    private static boolean skipTopLevelScalar(byte b) {
        return !JsonCounter.ws(b) && b != 34 && b != 123 && b != 91 && b != 93 && b != 125 && b != 44;
    }

    private void handleTopLevelScalarSpecial(byte b) throws JsonSyntaxException {
        if (JsonCounter.ws(b)) {
            --this.position;
            this.flushAfter();
            ++this.position;
            this.allowUnwrappingArrayComma = this.unwrappingArray;
            this.state = State.BASE;
        } else if (this.unwrappingArray && (b == 44 || b == 93)) {
            --this.position;
            this.flushAfter();
            ++this.position;
            this.state = b == 44 ? State.BASE : State.AFTER_UNWRAP_ARRAY;
            this.allowUnwrappingArrayComma = false;
        } else {
            JsonCounter.failMissingWs();
        }
    }

    private void handleEscape(byte b) {
        this.state = State.STRING;
    }

    private static boolean skipString(byte b) {
        return b != 34 && b != 92;
    }

    private void handleStringSpecial(byte b) throws JsonSyntaxException {
        switch (b) {
            case 34: {
                this.state = State.BASE;
                if (this.depth != 0) break;
                this.flushAfter();
                break;
            }
            case 92: {
                this.state = State.ESCAPE;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static boolean skipBufferingBase(byte b) {
        return b != 34 & b != 123 & b != 91 & b != 93 & b != 125;
    }

    private void handleBufferingBaseSpecial(byte b) throws JsonSyntaxException {
        switch (b) {
            case 93: 
            case 125: {
                --this.depth;
                if (this.depth != 0) break;
                this.flushAfter();
                break;
            }
            case 91: 
            case 123: {
                this.depth = Math.incrementExact(this.depth);
                break;
            }
            case 34: {
                this.state = State.STRING;
                break;
            }
            default: {
                throw new AssertionError(b);
            }
        }
    }

    private void flushAfter() {
        if (this.lastFlushedRegion != null) {
            throw new IllegalStateException("Should have cleared last buffer region");
        }
        assert (this.bufferStart != -1L);
        assert (this.position >= this.bufferStart);
        this.lastFlushedRegion = new BufferRegion(this.bufferStart, this.position + 1L);
        this.bufferStart = -1L;
        this.allowUnwrappingArrayComma = this.unwrappingArray;
    }

    @Nullable
    public BufferRegion pollFlushedRegion() {
        BufferRegion r = this.lastFlushedRegion;
        this.lastFlushedRegion = null;
        return r;
    }

    public long position() {
        return this.position;
    }

    public boolean isBuffering() {
        return this.bufferStart != -1L;
    }

    public long bufferStart() {
        if (this.bufferStart == -1L) {
            throw new IllegalStateException("Not buffering");
        }
        return this.bufferStart;
    }

    private static void failMismatchedBrackets() throws JsonSyntaxException {
        throw new JsonSyntaxException("JSON has mismatched brackets");
    }

    private static void failMissingWs() throws JsonSyntaxException {
        throw new JsonSyntaxException("After top-level scalars, there must be whitespace before the next node");
    }

    private static boolean ws(byte b) {
        return b == 32 || b == 10 || b == 13 || b == 9;
    }

    private static enum State {
        BASE,
        STRING,
        TOP_LEVEL_SCALAR,
        ESCAPE,
        BEFORE_UNWRAP_ARRAY,
        AFTER_UNWRAP_ARRAY,
        BUFFER_ALL;

    }

    public record BufferRegion(long start, long end) {
    }
}

