/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.http.netty.channel.EpollAvailabilityCondition;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

@Singleton
@Requires(classes={Epoll.class}, condition=EpollAvailabilityCondition.class)
@Internal
@Named(value="native")
@BootstrapContextCompatible
@Order(value=100)
public class EpollEventLoopGroupFactory
implements EventLoopGroupFactory {
    @Override
    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return new EpollEventLoopGroup(threads, threadFactory);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return new EpollEventLoopGroup(threads, executor);
    }

    @Override
    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return EpollServerSocketChannel.class;
    }

    @Override
    public Class<? extends ServerDomainSocketChannel> domainServerSocketChannelClass() throws UnsupportedOperationException {
        try {
            return EpollServerDomainSocketChannel.class;
        }
        catch (NoClassDefFoundError e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @NonNull
    public EpollServerSocketChannel serverSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        return new EpollServerSocketChannel();
    }

    @Override
    public ServerChannel domainServerSocketChannelInstance(@Nullable EventLoopGroupConfiguration configuration) {
        try {
            return new EpollServerDomainSocketChannel();
        }
        catch (NoClassDefFoundError e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return EpollSocketChannel.class;
    }

    @Override
    public SocketChannel clientSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new EpollSocketChannel();
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type) throws UnsupportedOperationException {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> EpollServerSocketChannel.class;
            case NettyChannelType.CLIENT_SOCKET -> EpollSocketChannel.class;
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> EpollServerDomainSocketChannel.class;
            case NettyChannelType.DATAGRAM_SOCKET -> EpollDatagramChannel.class;
        };
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(type);
    }

    @Override
    public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> new EpollServerSocketChannel();
            case NettyChannelType.CLIENT_SOCKET -> new EpollSocketChannel();
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> new EpollServerDomainSocketChannel();
            case NettyChannelType.DATAGRAM_SOCKET -> new EpollDatagramChannel();
        };
    }
}

