/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.cookies;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyCookies
implements Cookies {
    private static final Logger LOG = LoggerFactory.getLogger(NettyCookies.class);
    private final ConversionService conversionService;
    private final Map<CharSequence, io.micronaut.http.cookie.Cookie> cookies;

    public NettyCookies(String path, HttpHeaders nettyHeaders, ConversionService conversionService) {
        this.conversionService = conversionService;
        String value = nettyHeaders.get((CharSequence)HttpHeaderNames.COOKIE);
        if (value != null) {
            this.cookies = new LinkedHashMap<CharSequence, io.micronaut.http.cookie.Cookie>();
            Set nettyCookies = ServerCookieDecoder.LAX.decode(value);
            for (Cookie nettyCookie : nettyCookies) {
                String cookiePath = nettyCookie.path();
                if (cookiePath != null) {
                    if (!path.startsWith(cookiePath)) continue;
                    this.cookies.put(nettyCookie.name(), new NettyCookie(nettyCookie));
                    continue;
                }
                this.cookies.put(nettyCookie.name(), new NettyCookie(nettyCookie));
            }
        } else {
            this.cookies = Collections.emptyMap();
        }
    }

    public NettyCookies(HttpHeaders nettyHeaders, ConversionService conversionService) {
        this.conversionService = conversionService;
        if (nettyHeaders != null) {
            List values = nettyHeaders.getAll((CharSequence)HttpHeaderNames.SET_COOKIE);
            if (values != null && !values.isEmpty()) {
                this.cookies = new LinkedHashMap<CharSequence, io.micronaut.http.cookie.Cookie>();
                for (String value : values) {
                    Cookie nettyCookie = ClientCookieDecoder.STRICT.decode(value);
                    if (nettyCookie != null) {
                        this.cookies.put(nettyCookie.name(), new NettyCookie(nettyCookie));
                        continue;
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Failed to decode cookie value [{}]", (Object)value);
                }
            } else {
                this.cookies = Collections.emptyMap();
            }
        } else {
            this.cookies = Collections.emptyMap();
        }
    }

    public Set<io.micronaut.http.cookie.Cookie> getAll() {
        return new HashSet<io.micronaut.http.cookie.Cookie>(this.cookies.values());
    }

    public Optional<io.micronaut.http.cookie.Cookie> findCookie(CharSequence name) {
        io.micronaut.http.cookie.Cookie cookie = this.cookies.get(name);
        return cookie != null ? Optional.of(cookie) : Optional.empty();
    }

    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        if (requiredType == io.micronaut.http.cookie.Cookie.class || requiredType == Object.class) {
            return this.findCookie(name);
        }
        return this.findCookie(name).flatMap(cookie -> this.conversionService.convert((Object)cookie.getValue(), requiredType));
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.findCookie(name).flatMap(cookie -> this.conversionService.convert((Object)cookie.getValue(), conversionContext));
    }

    public Collection<io.micronaut.http.cookie.Cookie> values() {
        return Collections.unmodifiableCollection(this.cookies.values());
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }
}

