/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.RawMessageBodyHandler;
import io.micronaut.http.body.WritableBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.exceptions.MessageBodyException;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.body.NettyBodyWriter;
import io.micronaut.http.netty.body.NettyWriteContext;
import io.micronaut.runtime.ApplicationConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.reactivestreams.Publisher;

@Replaces(value=WritableBodyWriter.class)
@Singleton
@Internal
@BootstrapContextCompatible
@Bean(typed={RawMessageBodyHandler.class})
public final class NettyWritableBodyWriter
implements NettyBodyWriter<Writable>,
RawMessageBodyHandler<Writable> {
    private final WritableBodyWriter defaultWritable;

    public NettyWritableBodyWriter(ApplicationConfiguration applicationConfiguration) {
        this.defaultWritable = new WritableBodyWriter(applicationConfiguration);
    }

    public boolean isBlocking() {
        return true;
    }

    @Override
    public void writeTo(HttpRequest<?> request, MutableHttpResponse<Writable> outgoingResponse, Argument<Writable> type, MediaType mediaType, Writable object, NettyWriteContext nettyContext) throws CodecException {
        ByteBuf byteBuf = nettyContext.alloc().ioBuffer(128);
        MutableHttpHeaders outgoingHeaders = outgoingResponse.getHeaders();
        if (mediaType != null && !outgoingHeaders.contains("Content-Type")) {
            outgoingHeaders.contentType(mediaType);
        }
        try (ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);){
            DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)outgoingResponse.code(), (String)outgoingResponse.reason()), byteBuf, ((NettyHttpHeaders)outgoingHeaders).getNettyHeaders(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            object.writeTo((OutputStream)outputStream, MessageBodyWriter.getCharset((Headers)outgoingHeaders));
            nettyContext.writeFull((FullHttpResponse)fullHttpResponse);
        }
        catch (IOException e) {
            throw new MessageBodyException("Error writing body from writable", (Throwable)e);
        }
    }

    public void writeTo(Argument<Writable> type, MediaType mediaType, Writable object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        this.defaultWritable.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }

    public Publisher<? extends Writable> readChunked(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        return this.defaultWritable.readChunked(type, mediaType, httpHeaders, input);
    }

    public Writable read(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        return this.defaultWritable.read(type, mediaType, httpHeaders, inputStream);
    }

    public Collection<? extends Class<?>> getTypes() {
        return this.defaultWritable.getTypes();
    }
}

