/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.cookies;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.ServerCookieEncoder;
import io.micronaut.http.netty.cookies.NettyCookie;
import java.util.Arrays;
import java.util.List;

@Internal
public final class NettyServerCookieEncoder
implements ServerCookieEncoder {
    public List<String> encode(Cookie ... cookies) {
        return Arrays.stream(cookies).map(this::encodeCookie).toList();
    }

    @NonNull
    private String encodeCookie(@NonNull Cookie cookie) {
        if (cookie instanceof NettyCookie) {
            NettyCookie nettyCookie = (NettyCookie)cookie;
            return io.netty.handler.codec.http.cookie.ServerCookieEncoder.STRICT.encode(nettyCookie.getNettyCookie());
        }
        return io.netty.handler.codec.http.cookie.ServerCookieEncoder.STRICT.encode(new NettyCookie(cookie).getNettyCookie());
    }
}

