/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.server.HttpServerConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class MicronautHttpData<D extends HttpData>
extends AbstractReferenceCounted
implements HttpData {
    private static final Supplier<ResourceLeakDetector<MicronautHttpData>> LEAK_DETECTOR = SupplierUtil.memoized(() -> ResourceLeakDetectorFactory.instance().newResourceLeakDetector(MicronautHttpData.class));
    private static final Logger LOG = LoggerFactory.getLogger(MicronautHttpData.class);
    private static final int MMAP_SEGMENT_SIZE = 0x40000000;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    final Factory factory;
    long definedSize = 0L;
    Charset charset;
    @Nullable
    private final ResourceLeakTracker<MicronautHttpData> tracker = LEAK_DETECTOR.get().track((Object)this);
    private final String name;
    private final List<Chunk> chunks = new ArrayList<Chunk>();
    private long size = 0L;
    @Nullable
    private Path path;
    private FileChannel channel;
    private List<ByteBuf> mmapSegments;
    private boolean completed = false;
    private int pollIndex = 0;

    private MicronautHttpData(Factory factory, String name) {
        this.factory = factory;
        this.name = name;
        this.charset = factory.characterEncoding;
        this.chunks.add(new Chunk(0L));
    }

    private boolean shouldMoveToDisk(long newSize) {
        if (this.factory.multipartConfiguration.isDisk()) {
            return true;
        }
        if (this.factory.multipartConfiguration.isMixed()) {
            return newSize >= this.factory.multipartConfiguration.getThreshold();
        }
        return false;
    }

    private Chunk lastChunk() {
        return this.chunks.get(this.chunks.size() - 1);
    }

    public Chunk pollChunk() {
        if (this.pollIndex >= this.chunks.size()) {
            return null;
        }
        Chunk chunk = this.chunks.get(this.pollIndex++);
        if (this.pollIndex == this.chunks.size() && !this.completed) {
            this.chunks.add(new Chunk(this.size));
        }
        chunk.retain();
        return chunk;
    }

    public InputStream toStream() {
        this.retain();
        return new StreamImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(ByteBuf buffer, boolean last) throws IOException {
        int newChunkSize;
        Chunk chunk;
        if (this.completed) {
            throw new IllegalStateException("Already completed");
        }
        buffer.touch();
        long newSize = this.size + (long)buffer.readableBytes();
        if (newSize > this.factory.multipartConfiguration.getMaxFileSize()) {
            buffer.release();
            throw new IOException("Size exceed allowed maximum capacity");
        }
        if (this.channel == null && this.shouldMoveToDisk(newSize)) {
            this.transferToDisk();
        }
        while (true) {
            chunk = this.lastChunk();
            if (chunk.lock.tryLock()) {
                if (chunk.buf == null) {
                    newChunkSize = buffer.readableBytes();
                } else {
                    newChunkSize = chunk.buf.readableBytes() + buffer.readableBytes();
                    if (newChunkSize > 0x40000000) {
                        newChunkSize = -1;
                    }
                }
                if (newChunkSize >= 0) break;
                chunk.lock.unlock();
            }
            this.chunks.add(new Chunk(this.size));
        }
        try {
            if (this.channel == null) {
                if (chunk.buf == null) {
                    chunk.buf = buffer;
                } else {
                    ByteBuf byteBuf = chunk.buf;
                    if (byteBuf instanceof CompositeByteBuf) {
                        CompositeByteBuf composite = (CompositeByteBuf)byteBuf;
                        composite.addComponent(true, buffer);
                    } else {
                        chunk.buf = Unpooled.compositeBuffer().addComponent(true, chunk.buf).addComponent(true, buffer);
                    }
                }
            } else {
                buffer.readBytes(this.channel, this.size, buffer.readableBytes());
                buffer.release();
                chunk.loadFromDisk(newChunkSize);
            }
            this.size = newSize;
            if (newSize > this.definedSize && this.definedSize != 0L) {
                this.definedSize = newSize;
            }
        }
        finally {
            chunk.lock.unlock();
        }
        if (last) {
            this.completed = true;
            if (this.channel != null) {
                this.channel.close();
            }
        }
    }

    private ByteBuf mmapSegment(int index) throws IOException {
        while (this.mmapSegments.size() <= index) {
            this.mmapSegments.add(null);
        }
        ByteBuf segment = this.mmapSegments.get(index);
        if (segment == null) {
            segment = Unpooled.wrappedBuffer((ByteBuffer)this.channel.map(FileChannel.MapMode.READ_ONLY, (long)index * 0x40000000L, 0x40000000L));
            this.mmapSegments.set(index, segment);
        }
        return segment;
    }

    private void transferToDisk() throws IOException {
        assert (this.channel == null);
        this.path = this.newTempFile();
        this.channel = FileChannel.open(this.path, StandardOpenOption.READ, StandardOpenOption.WRITE);
        for (Chunk chunk : this.chunks) {
            if (chunk.buf == null) continue;
            chunk.buf.getBytes(chunk.buf.readerIndex(), this.channel, chunk.offset, chunk.buf.readableBytes());
        }
        this.mmapSegments = new ArrayList<ByteBuf>();
        for (Chunk chunk : this.chunks) {
            if (!chunk.lock.tryLock()) continue;
            try {
                if (chunk.buf == null) continue;
                chunk.loadFromDisk(chunk.buf.readableBytes());
            }
            finally {
                chunk.lock.unlock();
            }
        }
    }

    private Path newTempFile() throws IOException {
        Optional location = this.factory.multipartConfiguration.getLocation();
        if (location.isPresent()) {
            return Files.createTempFile(((File)location.get()).toPath(), "FUp_", ".tmp", new FileAttribute[0]);
        }
        return Files.createTempFile("FUp_", ".tmp", new FileAttribute[0]);
    }

    protected void deallocate() {
        if (this.tracker != null) {
            this.tracker.close((Object)this);
        }
        this.dealloc0();
    }

    private void dealloc0() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close temp file channel", (Throwable)e);
            }
        }
        if (this.path != null) {
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete temp file", (Throwable)e);
            }
        }
        for (Chunk chunk : this.chunks) {
            chunk.release();
        }
        if (this.mmapSegments != null) {
            for (ByteBuf segment : this.mmapSegments) {
                segment.release();
            }
        }
    }

    public void setContent(ByteBuf buffer) throws IOException {
        this.dealloc0();
        this.chunks.clear();
        Chunk ch = new Chunk(0L);
        this.chunks.add(ch);
        ch.buf = buffer;
        this.size = buffer.readableBytes();
    }

    public long getMaxSize() {
        throw new UnsupportedOperationException();
    }

    public void setMaxSize(long maxSize) {
        throw new UnsupportedOperationException();
    }

    public void checkSize(long newSize) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setContent(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setContent(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public long length() {
        return this.size;
    }

    public long definedLength() {
        return this.definedSize;
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get() throws IOException {
        byte[] arr = new byte[Math.toIntExact(this.size)];
        for (Chunk chunk : this.chunks) {
            if (!chunk.lock.tryLock()) {
                throw new IllegalStateException("Chunk already claimed (or get() called concurrently, which is not allowed)");
            }
            try {
                if (chunk.buf == null) continue;
                chunk.buf.getBytes(chunk.buf.readerIndex(), arr, Math.toIntExact(chunk.offset), chunk.buf.readableBytes());
            }
            finally {
                chunk.lock.unlock();
            }
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf getByteBuf() {
        ByteBuf buf = Unpooled.buffer((int)Math.toIntExact(this.size));
        for (Chunk chunk : this.chunks) {
            if (!chunk.lock.tryLock()) {
                buf.release();
                throw new IllegalStateException("Chunk already claimed (or get() called concurrently, which is not allowed)");
            }
            try {
                if (chunk.buf == null) continue;
                chunk.buf.getBytes(chunk.buf.readerIndex(), buf, chunk.buf.readableBytes());
            }
            finally {
                chunk.lock.unlock();
            }
        }
        return buf;
    }

    public ByteBuf getChunk(int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getString() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getString(Charset encoding) throws IOException {
        return new String(this.get(), encoding);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean renameTo(File dest) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isInMemory() {
        throw new UnsupportedOperationException();
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteBuf content() {
        return this.getByteBuf();
    }

    public D copy() {
        throw new UnsupportedOperationException();
    }

    public D duplicate() {
        throw new UnsupportedOperationException();
    }

    public D retainedDuplicate() {
        throw new UnsupportedOperationException();
    }

    public D replace(ByteBuf content) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public D touch(Object hint) {
        if (this.tracker != null) {
            this.tracker.record(hint);
        }
        return (D)((Object)this);
    }

    public int compareTo(@NonNull InterfaceHttpData o) {
        throw new UnsupportedOperationException();
    }

    public D retain() {
        return (D)((HttpData)super.retain());
    }

    public D retain(int increment) {
        return (D)((HttpData)super.retain(increment));
    }

    public D touch() {
        if (this.tracker != null) {
            this.tracker.record();
        }
        return (D)((HttpData)super.touch());
    }

    @Internal
    public static final class Factory
    implements HttpDataFactory {
        private final HttpServerConfiguration.MultipartConfiguration multipartConfiguration;
        private final Charset characterEncoding;
        private final Set<MicronautHttpData<?>> toClean = new HashSet();

        public Factory(HttpServerConfiguration.MultipartConfiguration multipartConfiguration, Charset characterEncoding) {
            this.multipartConfiguration = multipartConfiguration;
            this.characterEncoding = characterEncoding;
        }

        public void setMaxLimit(long max) {
            throw new UnsupportedOperationException();
        }

        public AttributeImpl createAttribute(String name) {
            AttributeImpl attribute = new AttributeImpl(this, name);
            this.toClean.add(attribute);
            return attribute;
        }

        public Attribute createAttribute(HttpRequest request, String name) {
            return this.createAttribute(name);
        }

        public Attribute createAttribute(HttpRequest request, String name, long definedSize) {
            AttributeImpl attribute = this.createAttribute(name);
            attribute.definedSize = definedSize;
            return attribute;
        }

        public Attribute createAttribute(HttpRequest request, String name, String value) {
            AttributeImpl attr = this.createAttribute(name);
            try {
                attr.addContent(Unpooled.wrappedBuffer((byte[])value.getBytes(this.characterEncoding)), true);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return attr;
        }

        public FileUpload createFileUpload(HttpRequest request, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
            FileUploadImpl fileUpload = new FileUploadImpl(this, name, filename, contentType);
            this.toClean.add(fileUpload);
            fileUpload.definedSize = size;
            fileUpload.charset = charset;
            return fileUpload;
        }

        public void removeHttpDataFromClean(HttpRequest request, InterfaceHttpData data) {
            this.toClean.remove(data);
        }

        public void cleanRequestHttpData(HttpRequest request) {
            this.cleanAllHttpData();
        }

        public void cleanAllHttpData() {
            for (MicronautHttpData<?> micronautHttpData : this.toClean) {
                micronautHttpData.release();
            }
            this.toClean.clear();
        }

        public void cleanRequestHttpDatas(HttpRequest request) {
            throw new UnsupportedOperationException();
        }

        public void cleanAllHttpDatas() {
            throw new UnsupportedOperationException();
        }
    }

    public final class Chunk
    extends AbstractReferenceCounted {
        private final Lock lock = new ReentrantLock();
        private final long offset;
        @Nullable
        private ByteBuf buf;

        private Chunk(long offset) {
            this.offset = offset;
        }

        private void loadFromDisk(int length) throws IOException {
            int firstSegmentIndex = Math.toIntExact(this.offset / 0x40000000L);
            int lastSegmentIndex = Math.toIntExact((this.offset + (long)length - 1L) / 0x40000000L);
            int offsetInSegment = Math.toIntExact(this.offset % 0x40000000L);
            ByteBuf oldBuf = this.buf;
            if (firstSegmentIndex == lastSegmentIndex) {
                this.buf = MicronautHttpData.this.mmapSegment(firstSegmentIndex).retainedSlice(offsetInSegment, Math.toIntExact(length));
            } else {
                CompositeByteBuf composite = Unpooled.compositeBuffer((int)(lastSegmentIndex - firstSegmentIndex + 1));
                composite.addComponent(MicronautHttpData.this.mmapSegment(firstSegmentIndex).retainedSlice(offsetInSegment, 0x40000000 - offsetInSegment));
                for (int i = firstSegmentIndex + 1; i < lastSegmentIndex; ++i) {
                    composite.addComponent(MicronautHttpData.this.mmapSegment(i).retain());
                }
                composite.addComponent(MicronautHttpData.this.mmapSegment(lastSegmentIndex).retainedSlice(0, Math.toIntExact((this.offset + (long)length) % 0x40000000L)));
                this.buf = composite;
            }
            if (oldBuf != null) {
                oldBuf.release();
            }
        }

        public ByteBuf claim() {
            this.lock.lock();
            if (this.buf == null) {
                return Unpooled.EMPTY_BUFFER;
            }
            ByteBuf b = this.buf;
            this.buf = null;
            b.touch();
            this.release();
            return b;
        }

        protected void deallocate() {
            if (!this.lock.tryLock()) {
                return;
            }
            if (this.buf != null) {
                this.buf.release();
                this.buf = null;
            }
        }

        public ReferenceCounted touch() {
            return this;
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }
    }

    private final class StreamImpl
    extends InputStream {
        ByteBuf buf = Unpooled.EMPTY_BUFFER;

        private StreamImpl() {
        }

        @Override
        public int read() throws IOException {
            byte[] arr = new byte[1];
            if (this.read(arr) != 1) {
                return -1;
            }
            return arr[0] & 0xFF;
        }

        @Override
        public int read(@NonNull byte[] b, int off, int len) throws IOException {
            if (!this.buf.isReadable()) {
                this.buf.release();
                Chunk nextChunk = MicronautHttpData.this.pollChunk();
                if (nextChunk == null) {
                    this.buf = Unpooled.EMPTY_BUFFER;
                    return -1;
                }
                this.buf = nextChunk.claim();
            }
            int n = Math.min(len, this.buf.readableBytes());
            this.buf.readBytes(b, off, n);
            return n;
        }

        @Override
        public void close() throws IOException {
            if (this.buf != null) {
                this.buf.release();
                this.buf = null;
                MicronautHttpData.this.release();
            }
        }
    }

    private static final class FileUploadImpl
    extends MicronautHttpData<FileUpload>
    implements FileUpload {
        private final String fileName;
        private final String contentType;

        FileUploadImpl(Factory factory, String name, String fileName, String contentType) {
            super(factory, name);
            this.fileName = fileName;
            this.contentType = contentType;
        }

        public String getFilename() {
            return this.fileName;
        }

        public void setFilename(String filename) {
            throw new UnsupportedOperationException();
        }

        public void setContentType(String contentType) {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentTransferEncoding(String contentTransferEncoding) {
            throw new UnsupportedOperationException();
        }

        public String getContentTransferEncoding() {
            throw new UnsupportedOperationException();
        }

        public InterfaceHttpData.HttpDataType getHttpDataType() {
            return InterfaceHttpData.HttpDataType.FileUpload;
        }
    }

    private static final class AttributeImpl
    extends MicronautHttpData<Attribute>
    implements Attribute {
        AttributeImpl(Factory factory, String name) {
            super(factory, name);
        }

        public String getValue() throws IOException {
            return new String(this.get(), this.factory.characterEncoding);
        }

        public void setValue(String value) throws IOException {
            this.setContent(Unpooled.copiedBuffer((CharSequence)value, (Charset)this.factory.characterEncoding));
        }

        public InterfaceHttpData.HttpDataType getHttpDataType() {
            return InterfaceHttpData.HttpDataType.Attribute;
        }
    }
}

