/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import java.util.Collections;
import java.util.Optional;

public class PathVariableAnnotationBinder<T>
extends AbstractArgumentBinder<T>
implements AnnotatedRequestArgumentBinder<PathVariable, T> {
    public PathVariableAnnotationBinder(ConversionService conversionService) {
        super(conversionService);
    }

    public Class<PathVariable> getAnnotationType() {
        return PathVariable.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        HttpParameters parameters = source.getParameters();
        Argument argument = context.getArgument();
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        String parameterName = annotationMetadata.stringValue(PathVariable.class).orElse(argument.getName());
        Optional matchInfo = source.getAttribute(HttpAttributes.ROUTE_MATCH, UriMatchInfo.class);
        boolean bindAll = matchInfo.flatMap(umi -> umi.getVariables().stream().filter(v -> v.getName().equals(parameterName)).findFirst().map(UriMatchVariable::isExploded)).orElse(false);
        ConvertibleValues variableValues = ConvertibleValues.of(((UriMatchInfo)matchInfo.get()).getVariableValues(), (ConversionService)this.conversionService);
        if (bindAll) {
            Object value;
            if (Iterable.class.isAssignableFrom(argument.getType())) {
                value = this.doResolve(context, variableValues, parameterName);
                if (value == null) {
                    value = Collections.emptyList();
                }
            } else {
                value = parameters.asMap();
            }
            return this.doConvert(value, context);
        }
        return this.doBind(context, variableValues, parameterName, ArgumentBinder.BindingResult.unsatisfied());
    }
}

