/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;

public class HeaderAnnotationBinder<T>
extends AbstractArgumentBinder<T>
implements AnnotatedRequestArgumentBinder<Header, T> {
    public HeaderAnnotationBinder(ConversionService conversionService) {
        super(conversionService);
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> argument, HttpRequest<?> source) {
        HttpHeaders parameters = source.getHeaders();
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        String parameterName = annotationMetadata.stringValue(Header.class).orElseGet(() -> annotationMetadata.stringValue(Header.class, "name").orElse(argument.getArgument().getName()));
        return this.doBind(argument, (ConvertibleValues)parameters, parameterName);
    }

    public Class<Header> getAnnotationType() {
        return Header.class;
    }

    protected String getFallbackFormat(Argument<?> argument) {
        return NameUtils.hyphenate((String)NameUtils.capitalize((String)argument.getName()), (boolean)false);
    }
}

