/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

@Indexed(value=MessageBodyWriter.class)
public interface MessageBodyWriter<T> {
    default public boolean isWriteable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return true;
    }

    default public MessageBodyWriter<T> createSpecific(@NonNull Argument<T> type) {
        return this;
    }

    default public boolean isBlocking() {
        return false;
    }

    @NonNull
    public static Charset getCharset(@NonNull Headers headers) {
        return MessageBodyWriter.findCharset(headers).orElse(StandardCharsets.UTF_8);
    }

    @NonNull
    public static Charset getCharset(@Nullable MediaType mediaType, @NonNull Headers headers) {
        Charset charset;
        Charset charset2 = charset = mediaType == null ? null : (Charset)mediaType.getCharset().orElse(null);
        if (charset == null) {
            return MessageBodyWriter.getCharset(headers);
        }
        return charset;
    }

    public static Optional<Charset> findCharset(@Nullable MediaType mediaType, @NonNull Headers headers) {
        if (mediaType == null) {
            return MessageBodyWriter.findCharset(headers);
        }
        return mediaType.getCharset().or(() -> MessageBodyWriter.findCharset(headers));
    }

    public static Optional<Charset> findCharset(@NonNull Headers headers) {
        return Optional.ofNullable(MessageBodyWriter.findCharset0(headers));
    }

    @Nullable
    private static Charset findCharset0(Headers headers) {
        if (headers instanceof HttpHeaders) {
            HttpHeaders httpHeaders = (HttpHeaders)headers;
            return httpHeaders.acceptCharset();
        }
        return null;
    }

    public void writeTo(@NonNull Argument<T> var1, @NonNull MediaType var2, T var3, @NonNull MutableHeaders var4, @NonNull OutputStream var5) throws CodecException;

    @NonNull
    default public ByteBuffer<?> writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        ByteBuffer buffer = bufferFactory.buffer();
        try {
            this.writeTo(type, mediaType, object, outgoingHeaders, buffer.toOutputStream());
        }
        catch (Throwable t) {
            if (buffer instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)buffer;
                rc.release();
            }
            throw t;
        }
        return buffer;
    }
}

