/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.simple;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.MutableHttpHeaders;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SimpleHttpHeaders
implements MutableHttpHeaders {
    private final CaseInsensitiveMutableHttpHeaders headers;
    private ConversionService conversionService;

    public SimpleHttpHeaders() {
        this(ConversionService.SHARED);
    }

    public SimpleHttpHeaders(Map<String, String> headers, ConversionService conversionService) {
        this.headers = new CaseInsensitiveMutableHttpHeaders(conversionService);
        headers.forEach(this.headers::add);
        this.conversionService = conversionService;
    }

    public SimpleHttpHeaders(ConversionService conversionService) {
        this(new LinkedHashMap<String, String>(), conversionService);
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        Optional value = this.headers.getFirst(name.toString());
        return value.flatMap(it -> this.conversionService.convert(it, conversionContext));
    }

    public List<String> getAll(CharSequence name) {
        return this.headers.getAll(name.toString());
    }

    public Set<String> names() {
        return this.headers.names();
    }

    public Collection<List<String>> values() {
        return this.headers.values();
    }

    public String get(CharSequence name) {
        return this.headers.get(name.toString());
    }

    @Override
    public MutableHttpHeaders add(CharSequence header, CharSequence value) {
        if (value != null) {
            this.headers.add((CharSequence)header.toString(), value.toString());
        }
        return this;
    }

    @Override
    public MutableHttpHeaders remove(CharSequence header) {
        this.headers.remove(header.toString().toLowerCase(Locale.ROOT));
        return this;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
        this.headers.setConversionService(conversionService);
    }
}

