/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
final class DefaultUriMatchInfo
implements UriMatchInfo {
    private final String uri;
    private final Map<String, Object> variableValues;
    private final List<UriMatchVariable> variables;
    private final Map<String, UriMatchVariable> variableMap;

    DefaultUriMatchInfo(String uri, Map<String, Object> variableValues, List<UriMatchVariable> variables) {
        this.uri = uri;
        this.variableValues = variableValues;
        this.variables = variables;
        LinkedHashMap vm = CollectionUtils.newLinkedHashMap((int)variables.size());
        for (UriMatchVariable variable : variables) {
            vm.put(variable.getName(), variable);
        }
        this.variableMap = Collections.unmodifiableMap(vm);
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public Map<String, Object> getVariableValues() {
        return this.variableValues;
    }

    @Override
    public List<UriMatchVariable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    @Override
    public Map<String, UriMatchVariable> getVariableMap() {
        return this.variableMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUriMatchInfo that = (DefaultUriMatchInfo)o;
        return this.uri.equals(that.uri) && this.variables.equals(that.variables);
    }

    public String toString() {
        return this.getUri();
    }

    public int hashCode() {
        return ObjectUtils.hash((Object)this.uri, this.variableValues);
    }
}

