/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.core.util.StringUtils;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriTemplate
implements Comparable<UriTemplate> {
    private static final String STRING_PATTERN_SCHEME = "([^:/?#]+):";
    private static final String STRING_PATTERN_USER_INFO = "([^@\\[/?#]*)";
    private static final String STRING_PATTERN_HOST_IPV4 = "[^\\[{/?#:]*";
    private static final String STRING_PATTERN_HOST_IPV6 = "\\[[\\p{XDigit}:.]*[%\\p{Alnum}]*]";
    private static final String STRING_PATTERN_HOST = "(\\[[\\p{XDigit}:.]*[%\\p{Alnum}]*]|[^\\[{/?#:]*)";
    private static final String STRING_PATTERN_PORT = "(\\d*(?:\\{[^/]+?})?)";
    private static final String STRING_PATTERN_PATH = "([^#]*)";
    private static final String STRING_PATTERN_QUERY = "([^#]*)";
    private static final String STRING_PATTERN_REMAINING = "(.*)";
    private static final char QUERY_OPERATOR = '?';
    private static final char SLASH_OPERATOR = '/';
    private static final char HASH_OPERATOR = '#';
    private static final char EXPAND_MODIFIER = '*';
    private static final char OPERATOR_NONE = '0';
    private static final char VAR_START = '{';
    private static final char VAR_END = '}';
    private static final char AND_OPERATOR = '&';
    private static final String SLASH_STRING = "/";
    private static final char DOT_OPERATOR = '.';
    private static final Pattern PATTERN_SCHEME = Pattern.compile("^([^:/?#]+)://.*");
    private static final Pattern PATTERN_FULL_URI = Pattern.compile("^(([^:/?#]+):)?(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}:.]*[%\\p{Alnum}]*]|[^\\[{/?#:]*)(:(\\d*(?:\\{[^/]+?})?))?)?([^#]*)(\\?([^#]*))?(#(.*))?");
    protected final String templateString;
    final List<PathSegment> segments = new ArrayList<PathSegment>();
    private String asString;

    public UriTemplate(CharSequence templateString) {
        this(templateString, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UriTemplate(CharSequence templateString, Object ... parserArguments) {
        int len;
        if (templateString == null) {
            throw new IllegalArgumentException("Argument [templateString] should not be null");
        }
        String templateAsString = templateString.toString();
        if (templateAsString.endsWith(SLASH_STRING) && (len = templateAsString.length()) > 1) {
            templateAsString = templateAsString.substring(0, len - 1);
        }
        if (PATTERN_SCHEME.matcher(templateAsString).matches()) {
            Matcher matcher = PATTERN_FULL_URI.matcher(templateAsString);
            if (!matcher.find()) throw new IllegalArgumentException("Invalid URI template: " + templateString);
            this.templateString = templateAsString;
            String scheme = matcher.group(2);
            if (scheme != null) {
                this.createParser(scheme + "://", parserArguments).parse(this.segments);
            }
            String userInfo = matcher.group(5);
            String host = matcher.group(6);
            String port = matcher.group(8);
            String path = matcher.group(9);
            String query = matcher.group(11);
            String fragment = matcher.group(13);
            if (userInfo != null) {
                this.createParser(userInfo, parserArguments).parse(this.segments);
            }
            if (host != null) {
                this.createParser(host, parserArguments).parse(this.segments);
            }
            if (port != null) {
                this.createParser(":" + port, parserArguments).parse(this.segments);
            }
            if (path != null) {
                if (fragment != null) {
                    this.createParser(path + "#" + fragment, new Object[0]).parse(this.segments);
                } else {
                    this.createParser(path, parserArguments).parse(this.segments);
                }
            }
            if (query == null) return;
            this.createParser(query, parserArguments).parse(this.segments);
            return;
        } else {
            this.templateString = templateAsString;
            this.createParser(this.templateString, parserArguments).parse(this.segments);
        }
    }

    protected UriTemplate(String templateString, List<PathSegment> segments) {
        this.templateString = templateString;
        this.segments.addAll(segments);
    }

    public String getTemplateString() {
        return this.templateString;
    }

    public long getVariableSegmentCount() {
        return this.segments.stream().filter(PathSegment::isVariable).count();
    }

    public long getPathVariableSegmentCount() {
        return this.segments.stream().filter(PathSegment::isVariable).filter(s -> !s.isQuerySegment()).count();
    }

    public long getRawSegmentCount() {
        return this.segments.stream().filter(segment -> !segment.isVariable()).count();
    }

    public int getRawSegmentLength() {
        return this.segments.stream().filter(segment -> !segment.isVariable()).map(CharSequence::length).reduce(Integer::sum).orElse(0);
    }

    public UriTemplate nest(CharSequence uriTemplate) {
        return this.nest(uriTemplate, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public String expand(Map<String, Object> parameters) {
        StringBuilder builder = new StringBuilder(this.templateString.length());
        boolean anyPreviousHasContent = false;
        boolean anyPreviousHasOperator = false;
        boolean queryParameter = false;
        for (PathSegment segment : this.segments) {
            String result = segment.expand(parameters, anyPreviousHasContent, anyPreviousHasOperator);
            if (result == null) continue;
            if (segment instanceof UriTemplateParser.VariablePathSegment) {
                char operator;
                UriTemplateParser.VariablePathSegment varPathSegment = (UriTemplateParser.VariablePathSegment)segment;
                if (varPathSegment.isQuerySegment && !queryParameter) {
                    queryParameter = true;
                    anyPreviousHasContent = false;
                    anyPreviousHasOperator = false;
                }
                if ((operator = varPathSegment.operator()) != '0' && result.contains(String.valueOf(operator))) {
                    anyPreviousHasOperator = true;
                }
                anyPreviousHasContent = anyPreviousHasContent || !result.isEmpty();
            }
            builder.append(result);
        }
        return builder.toString();
    }

    public String expand(Object bean) {
        return this.expand((Map<String, Object>)BeanMap.of((Object)bean));
    }

    public String toString() {
        if (this.asString == null) {
            this.asString = this.toString(pathSegment -> true);
        }
        return this.asString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriTemplate that = (UriTemplate)o;
        return this.templateString.equals(that.templateString);
    }

    public int hashCode() {
        return this.templateString.hashCode();
    }

    @Override
    public int compareTo(UriTemplate o) {
        if (this == o) {
            return 0;
        }
        int thisVariableCount = 0;
        int thatVariableCount = 0;
        int thisRawLength = 0;
        int thatRawLength = 0;
        for (PathSegment segment : this.segments) {
            if (segment.isVariable()) {
                if (segment.isQuerySegment()) continue;
                ++thisVariableCount;
                continue;
            }
            thisRawLength += segment.length();
        }
        for (PathSegment segment : o.segments) {
            if (segment.isVariable()) {
                if (segment.isQuerySegment()) continue;
                ++thatVariableCount;
                continue;
            }
            thatRawLength += segment.length();
        }
        int rawCompare = Integer.compare(thatRawLength, thisRawLength);
        if (rawCompare == 0) {
            return Integer.compare(thisVariableCount, thatVariableCount);
        }
        return rawCompare;
    }

    public static UriTemplate of(String uri) {
        return new UriTemplate(uri);
    }

    protected UriTemplate nest(CharSequence uriTemplate, Object ... parserArguments) {
        if (uriTemplate == null) {
            return this;
        }
        int len = uriTemplate.length();
        if (len == 0) {
            return this;
        }
        List<PathSegment> newSegments = this.buildNestedSegments(uriTemplate, len, parserArguments);
        return this.newUriTemplate(uriTemplate, newSegments);
    }

    protected UriTemplate newUriTemplate(CharSequence uriTemplate, List<PathSegment> newSegments) {
        return new UriTemplate(this.normalizeNested(this.templateString, uriTemplate), newSegments);
    }

    protected String normalizeNested(String uri, CharSequence nested) {
        if (StringUtils.isEmpty((CharSequence)nested)) {
            return uri;
        }
        String nestedStr = nested.toString();
        char firstNested = nestedStr.charAt(0);
        int len = nestedStr.length();
        if (len == 1 && firstNested == '/') {
            return uri;
        }
        switch (firstNested) {
            case '{': {
                if (len > 1) {
                    switch (nested.charAt(1)) {
                        case '#': 
                        case '&': 
                        case '/': 
                        case '?': {
                            if (uri.endsWith(SLASH_STRING)) {
                                return uri.substring(0, uri.length() - 1) + nestedStr;
                            }
                            return uri + nestedStr;
                        }
                    }
                    if (!uri.endsWith(SLASH_STRING)) {
                        return uri + SLASH_STRING + nestedStr;
                    }
                    return uri + nestedStr;
                }
                return uri;
            }
            case '/': {
                if (uri.endsWith(SLASH_STRING)) {
                    return uri + nestedStr.substring(1);
                }
                return uri + nestedStr;
            }
        }
        if (uri.endsWith(SLASH_STRING)) {
            return uri + nestedStr;
        }
        return uri + SLASH_STRING + nestedStr;
    }

    protected List<PathSegment> buildNestedSegments(CharSequence uriTemplate, int len, Object ... parserArguments) {
        ArrayList<PathSegment> newSegments = new ArrayList<PathSegment>();
        ArrayList<PathSegment> querySegments = new ArrayList<PathSegment>();
        for (PathSegment segment : this.segments) {
            if (!segment.isQuerySegment()) {
                newSegments.add(segment);
                continue;
            }
            querySegments.add(segment);
        }
        Object templateString = uriTemplate.toString();
        if (this.shouldPrependSlash((String)templateString, len)) {
            templateString = SLASH_STRING + (String)templateString;
        } else if (!this.segments.isEmpty() && ((String)templateString).startsWith(SLASH_STRING)) {
            if (len == 1 && uriTemplate.charAt(0) == '/') {
                templateString = "";
            } else {
                PathSegment last = this.segments.get(this.segments.size() - 1);
                if (last instanceof UriTemplateParser.RawPathSegment) {
                    UriTemplateParser.RawPathSegment segment = (UriTemplateParser.RawPathSegment)last;
                    String v = segment.value;
                    templateString = v.endsWith(SLASH_STRING) ? ((String)templateString).substring(1) : this.normalizeNested(SLASH_STRING, ((String)templateString).substring(1));
                }
            }
        }
        this.createParser((String)templateString, parserArguments).parse(newSegments);
        newSegments.addAll(querySegments);
        return newSegments;
    }

    protected UriTemplateParser createParser(String templateString, Object ... parserArguments) {
        return new UriTemplateParser(templateString);
    }

    protected String toString(Predicate<PathSegment> filter) {
        StringBuilder builder = new StringBuilder(this.templateString.length());
        UriTemplateParser.VariablePathSegment previousVariable = null;
        for (PathSegment segment : this.segments) {
            if (!filter.test(segment)) continue;
            boolean isVar = segment instanceof UriTemplateParser.VariablePathSegment;
            if (previousVariable != null && isVar) {
                UriTemplateParser.VariablePathSegment varSeg = (UriTemplateParser.VariablePathSegment)segment;
                if (varSeg.operator == previousVariable.operator && varSeg.modifierChar != '*') {
                    builder.append(varSeg.delimiter);
                } else {
                    builder.append('}').append('{');
                    char op = varSeg.operator;
                    if ('0' != op) {
                        builder.append(op);
                    }
                }
                builder.append(segment);
                previousVariable = varSeg;
                continue;
            }
            if (isVar) {
                previousVariable = (UriTemplateParser.VariablePathSegment)segment;
                builder.append('{');
                char op = previousVariable.operator;
                if ('0' != op) {
                    builder.append(op);
                }
                builder.append(segment);
                continue;
            }
            if (previousVariable != null) {
                builder.append('}');
                previousVariable = null;
            }
            builder.append(segment);
        }
        if (previousVariable != null) {
            builder.append('}');
        }
        return builder.toString();
    }

    private boolean shouldPrependSlash(String templateString, int len) {
        String parentString = this.templateString;
        int parentLen = parentString.length();
        return parentLen > 0 && parentString.charAt(parentLen - 1) != '/' && templateString.charAt(0) != '/' && this.isAdditionalPathVar(templateString, len);
    }

    private boolean isAdditionalPathVar(String templateString, int len) {
        if (len > 1) {
            boolean isVar;
            boolean bl = isVar = templateString.charAt(0) == '{';
            if (isVar) {
                return switch (templateString.charAt(1)) {
                    case '#', '/', '?' -> false;
                    default -> true;
                };
            }
        }
        return templateString.charAt(0) != '/';
    }

    protected static class UriTemplateParser {
        String templateText;

        UriTemplateParser(String templateText) {
            this.templateText = templateText;
        }

        protected void parse(List<PathSegment> segments) {
            static enum State {
                TEXT,
                VAR_START,
                VAR_CONTENT,
                VAR_NEXT,
                VAR_MODIFIER,
                VAR_NEXT_MODIFIER;

            }
            State state = State.TEXT;
            char operator = '0';
            char modifier = '0';
            String varDelimiter = null;
            boolean isQuerySegment = false;
            char[] chars = this.templateText.toCharArray();
            StringBuilder buff = new StringBuilder();
            StringBuilder modBuff = new StringBuilder();
            int varCount = 0;
            block32: for (char c : chars) {
                switch (state) {
                    case TEXT: {
                        String val;
                        if (c == '{') {
                            if (!buff.isEmpty()) {
                                val = buff.toString();
                                this.addRawContentSegment(segments, val, isQuerySegment);
                            }
                            buff.delete(0, buff.length());
                            state = State.VAR_START;
                            continue block32;
                        }
                        if (c == '?' || c == '#') {
                            isQuerySegment = true;
                        }
                        buff.append(c);
                        continue block32;
                    }
                    case VAR_MODIFIER: 
                    case VAR_NEXT_MODIFIER: {
                        if (c == ' ') continue block32;
                    }
                    case VAR_NEXT: 
                    case VAR_CONTENT: {
                        String val;
                        switch (c) {
                            case '*': 
                            case ':': {
                                if (state == State.VAR_MODIFIER || state == State.VAR_NEXT_MODIFIER) {
                                    modBuff.append(c);
                                    continue block32;
                                }
                                modifier = c;
                                state = state == State.VAR_NEXT ? State.VAR_NEXT_MODIFIER : State.VAR_MODIFIER;
                                continue block32;
                            }
                            case ',': {
                                state = State.VAR_NEXT;
                            }
                            case '}': {
                                boolean hasAnotherVar;
                                if (!buff.isEmpty()) {
                                    boolean repeatPrefix;
                                    Object delimiter;
                                    Object prefix;
                                    boolean encode;
                                    val = buff.toString();
                                    switch (operator) {
                                        case '+': {
                                            encode = false;
                                            prefix = null;
                                            delimiter = ",";
                                            repeatPrefix = varCount < 1;
                                            break;
                                        }
                                        case '#': {
                                            encode = false;
                                            repeatPrefix = varCount < 1;
                                            prefix = String.valueOf(operator);
                                            delimiter = ",";
                                            break;
                                        }
                                        case '.': 
                                        case '/': {
                                            encode = true;
                                            repeatPrefix = varCount < 1;
                                            prefix = String.valueOf(operator);
                                            delimiter = modifier == '*' ? prefix : ",";
                                            break;
                                        }
                                        case ';': {
                                            encode = true;
                                            repeatPrefix = true;
                                            prefix = operator + val + "=";
                                            delimiter = modifier == '*' ? prefix : ",";
                                            break;
                                        }
                                        case '&': 
                                        case '?': {
                                            encode = true;
                                            repeatPrefix = true;
                                            prefix = varCount < 1 ? operator + val + "=" : val + "=";
                                            delimiter = modifier == '*' ? "&" + val + "=" : ",";
                                            break;
                                        }
                                        default: {
                                            repeatPrefix = varCount < 1;
                                            encode = true;
                                            prefix = null;
                                            delimiter = ",";
                                        }
                                    }
                                    String modifierStr = modBuff.toString();
                                    String previous = state == State.VAR_NEXT || state == State.VAR_NEXT_MODIFIER ? varDelimiter : null;
                                    this.addVariableSegment(segments, val, (String)prefix, (String)delimiter, encode, repeatPrefix, modifierStr, modifier, operator, previous, isQuerySegment);
                                }
                                boolean bl = hasAnotherVar = state == State.VAR_NEXT && c != '}';
                                if (hasAnotherVar) {
                                    varDelimiter = switch (operator) {
                                        case ';' -> null;
                                        case '&', '?' -> "&";
                                        case '.', '/' -> String.valueOf(operator);
                                        default -> ",";
                                    };
                                    ++varCount;
                                } else {
                                    varCount = 0;
                                }
                                state = hasAnotherVar ? State.VAR_NEXT : State.TEXT;
                                modBuff.delete(0, modBuff.length());
                                buff.delete(0, buff.length());
                                modifier = '0';
                                if (hasAnotherVar) continue block32;
                                operator = '0';
                                continue block32;
                            }
                        }
                        switch (modifier) {
                            case '*': {
                                throw new IllegalStateException("Expansion modifier * must be immediately followed by a closing brace '}'");
                            }
                            case ':': {
                                modBuff.append(c);
                                continue block32;
                            }
                        }
                        buff.append(c);
                        continue block32;
                    }
                    case VAR_START: {
                        switch (c) {
                            case ' ': {
                                continue block32;
                            }
                            case '#': 
                            case '&': 
                            case ';': 
                            case '?': {
                                isQuerySegment = true;
                            }
                            case '+': 
                            case '.': 
                            case '/': {
                                operator = c;
                                state = State.VAR_CONTENT;
                                continue block32;
                            }
                        }
                        state = State.VAR_CONTENT;
                        buff.append(c);
                        continue block32;
                    }
                }
            }
            if (state == State.TEXT && !buff.isEmpty()) {
                String val = buff.toString();
                this.addRawContentSegment(segments, val, isQuerySegment);
            }
        }

        protected void addRawContentSegment(List<PathSegment> segments, String value, boolean isQuerySegment) {
            segments.add(new RawPathSegment(isQuerySegment, value));
        }

        protected void addVariableSegment(List<PathSegment> segments, String variable, String prefix, String delimiter, boolean encode, boolean repeatPrefix, String modifierStr, char modifierChar, char operator, String previousDelimiter, boolean isQuerySegment) {
            segments.add(new VariablePathSegment(isQuerySegment, variable, prefix, delimiter, encode, modifierChar, operator, modifierStr, previousDelimiter, repeatPrefix));
        }

        private record RawPathSegment(boolean isQuerySegment, String value) implements PathSegment
        {
            @Override
            public String expand(Map<String, Object> parameters, boolean previousHasContent, boolean anyPreviousHasOperator) {
                return this.value;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RawPathSegment that = (RawPathSegment)o;
                if (this.isQuerySegment != that.isQuerySegment) {
                    return false;
                }
                return Objects.equals(this.value, that.value);
            }

            @Override
            public int hashCode() {
                return ObjectUtils.hash((Object)this.isQuerySegment, (Object)this.value);
            }

            @Override
            public int length() {
                return this.value.length();
            }

            @Override
            public char charAt(int index) {
                return this.value.charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return this.value.subSequence(start, end);
            }

            @Override
            public String toString() {
                return this.value;
            }
        }

        private record VariablePathSegment(boolean isQuerySegment, String variable, String prefix, String delimiter, boolean encode, char modifierChar, char operator, String modifierStr, String previousDelimiter, boolean repeatPrefix) implements PathSegment
        {
            @Override
            public Optional<String> getVariable() {
                return Optional.of(this.variable);
            }

            @Override
            public int length() {
                return this.toString().length();
            }

            @Override
            public char charAt(int index) {
                return this.toString().charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return this.toString().subSequence(start, end);
            }

            @Override
            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.variable);
                if (this.modifierChar != '0') {
                    builder.append(this.modifierChar);
                    if (null != this.modifierStr) {
                        builder.append(this.modifierStr);
                    }
                }
                return builder.toString();
            }

            private String escape(String v) {
                return v.replace("%", "%25").replaceAll("\\s", "%20");
            }

            @Override
            public String expand(Map<String, Object> parameters, boolean previousHasContent, boolean anyPreviousHasOperator) {
                Object found = parameters.get(this.variable);
                boolean isOptional = found instanceof Optional;
                if (!(found == null || isOptional && ((Optional)found).isEmpty())) {
                    String result;
                    boolean isQuery;
                    if (isOptional) {
                        found = ((Optional)found).get();
                    }
                    Object prefixToUse = this.prefix;
                    if (this.operator == '?' && !anyPreviousHasOperator && this.prefix != null && !this.prefix.startsWith(String.valueOf(this.operator))) {
                        prefixToUse = this.operator + this.prefix;
                    }
                    if (found.getClass().isArray()) {
                        found = Arrays.asList((Object[])found);
                    }
                    boolean bl = isQuery = this.operator == '?';
                    if (this.modifierChar == '*') {
                        found = this.expandPOJO(found);
                    }
                    if (found instanceof Iterable) {
                        Collection collection;
                        Iterable iterable = (Iterable)found;
                        if (iterable instanceof Collection && (collection = (Collection)iterable).isEmpty()) {
                            return "";
                        }
                        StringJoiner joiner = new StringJoiner(this.delimiter);
                        for (Object o : iterable) {
                            if (o == null) continue;
                            String v = o.toString();
                            joiner.add(this.encode ? this.encode(v, isQuery) : this.escape(v));
                        }
                        result = joiner.toString();
                    } else if (found instanceof Map) {
                        StringJoiner joiner;
                        Map map = (Map)found;
                        if (map.isEmpty()) {
                            return "";
                        }
                        if (this.modifierChar == '*') {
                            joiner = switch (this.operator) {
                                case '&', '?' -> {
                                    prefixToUse = String.valueOf(anyPreviousHasOperator ? (char)'&' : (char)this.operator);
                                    yield new StringJoiner(String.valueOf('&'));
                                }
                                case ';' -> {
                                    prefixToUse = String.valueOf(this.operator);
                                    yield new StringJoiner((CharSequence)prefixToUse);
                                }
                                default -> new StringJoiner(this.delimiter);
                            };
                        } else {
                            joiner = new StringJoiner(this.delimiter);
                        }
                        map.forEach((key, some) -> {
                            Iterable<Object> iterable;
                            if (some == null) {
                                return;
                            }
                            String ks = key.toString();
                            if (some instanceof Iterable) {
                                Iterable i = (Iterable)some;
                                iterable = i;
                            } else {
                                iterable = Collections.singletonList(some);
                            }
                            List<Object> values = iterable;
                            for (Object t : values) {
                                String ev;
                                if (t == null) continue;
                                String vs = t.toString();
                                String ek = this.encode ? this.encode(ks, isQuery) : this.escape(ks);
                                String string = ev = this.encode ? this.encode(vs, isQuery) : this.escape(vs);
                                if (this.modifierChar == '*') {
                                    String finalValue = ek + "=" + ev;
                                    joiner.add(finalValue);
                                    continue;
                                }
                                joiner.add(ek);
                                joiner.add(ev);
                            }
                        });
                        if (joiner.length() == 0) {
                            return "";
                        }
                        result = joiner.toString();
                    } else {
                        String str = found.toString();
                        str = this.applyModifier(this.modifierStr, this.modifierChar, str, str.length());
                        result = this.encode ? this.encode(str, isQuery) : this.escape(str);
                    }
                    int len = result.length();
                    StringBuilder finalResult = new StringBuilder(previousHasContent && this.previousDelimiter != null ? this.previousDelimiter : "");
                    if (len == 0) {
                        switch (this.operator) {
                            case '/': {
                                break;
                            }
                            case ';': {
                                if (prefixToUse != null && ((String)prefixToUse).endsWith("=")) {
                                    finalResult.append((CharSequence)prefixToUse, 0, ((String)prefixToUse).length() - 1).append(result);
                                    break;
                                }
                            }
                            default: {
                                if (prefixToUse != null) {
                                    finalResult.append((String)prefixToUse).append(result);
                                    break;
                                }
                                finalResult.append(result);
                                break;
                            }
                        }
                    } else if (prefixToUse != null && this.repeatPrefix) {
                        finalResult.append((String)prefixToUse).append(result);
                    } else {
                        finalResult.append(result);
                    }
                    return finalResult.toString();
                }
                if (this.operator == '/') {
                    return null;
                }
                return "";
            }

            private String applyModifier(String modifierStr, char modifierChar, String result, int len) {
                if (modifierChar == ':' && !modifierStr.isEmpty() && Character.isDigit(modifierStr.charAt(0))) {
                    try {
                        int subResult = Integer.parseInt(modifierStr.trim(), 10);
                        if (subResult < len) {
                            result = ((String)result).substring(0, subResult);
                        }
                    }
                    catch (NumberFormatException e) {
                        result = ":" + modifierStr;
                    }
                }
                return result;
            }

            private String encode(String str, boolean query) {
                String encoded = URLEncoder.encode(str, StandardCharsets.UTF_8);
                return query ? encoded : encoded.replace("+", "%20");
            }

            private Object expandPOJO(Object found) {
                if (found instanceof Iterable || found instanceof Map) {
                    return found;
                }
                if (found == null || ClassUtils.isJavaLangType(found.getClass())) {
                    return found;
                }
                return BeanMap.of((Object)found);
            }
        }
    }

    protected static interface PathSegment
    extends CharSequence {
        default public boolean isQuerySegment() {
            return false;
        }

        default public Optional<String> getVariable() {
            return Optional.empty();
        }

        default public boolean isVariable() {
            return this.getVariable().isPresent();
        }

        public String expand(Map<String, Object> var1, boolean var2, boolean var3);
    }
}

