/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.TypedMessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Singleton
@Internal
public final class TextPlainObjectBodyReader<T>
implements TypedMessageBodyReader<T>,
ChunkedMessageBodyReader<T> {
    private final Charset defaultCharset;
    private final ConversionService conversionService;

    TextPlainObjectBodyReader(ApplicationConfiguration applicationConfiguration, ConversionService conversionService) {
        this.defaultCharset = applicationConfiguration.getDefaultCharset();
        this.conversionService = conversionService;
    }

    @Override
    public Argument<T> getType() {
        return Argument.OBJECT_ARGUMENT;
    }

    @Override
    public boolean isReadable(Argument<T> type, MediaType mediaType) {
        return mediaType != null && mediaType.matches(MediaType.TEXT_PLAIN_TYPE);
    }

    @Override
    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        try {
            String string = new String(inputStream.readAllBytes(), this.getCharset(mediaType, httpHeaders));
            return (T)this.conversionService.convertRequired((Object)string, type);
        }
        catch (IOException e) {
            throw new CodecException("Failed to read InputStream", e);
        }
    }

    @Override
    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return this.read0(type, byteBuffer, this.getCharset(mediaType, httpHeaders));
    }

    private T read0(Argument<T> type, ByteBuffer<?> byteBuffer, Charset charset) {
        String string = byteBuffer.toString(charset);
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)byteBuffer;
            rc.release();
        }
        return (T)this.conversionService.convertRequired((Object)string, type);
    }

    @Override
    public Publisher<T> readChunked(Argument<T> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        return Flux.from(input).map(byteBuffer -> this.read0(type, (ByteBuffer<?>)byteBuffer, this.getCharset(mediaType, httpHeaders)));
    }

    private Charset getCharset(MediaType mediaType, Headers httpHeaders) {
        return MessageBodyWriter.findCharset(mediaType, httpHeaders).orElse(this.defaultCharset);
    }
}

