/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.context.scope.CustomScopeRegistry;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
class DefaultCustomScopeRegistry
implements CustomScopeRegistry {
    private final BeanLocator beanLocator;
    private final Map<String, Optional<CustomScope<?>>> scopes = new ConcurrentHashMap(2);

    DefaultCustomScopeRegistry(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    @Override
    public Optional<CustomScope<?>> findDeclaredScope(@NonNull Argument<?> argument) {
        return argument.getAnnotationMetadata().getAnnotationNameByStereotype("javax.inject.Scope").flatMap(this::findScope);
    }

    @Override
    public Optional<CustomScope<?>> findDeclaredScope(@NonNull BeanType<?> beanType) {
        String scope;
        List scopeHierarchy = beanType.getAnnotationMetadata().getAnnotationNamesByStereotype("javax.inject.Scope");
        Optional<CustomScope<?>> registeredScope = Optional.empty();
        Iterator iterator = scopeHierarchy.iterator();
        while (iterator.hasNext() && !(registeredScope = this.findScope(scope = (String)iterator.next())).isPresent()) {
        }
        return registeredScope;
    }

    @Override
    public Optional<CustomScope<?>> findScope(Class<? extends Annotation> scopeAnnotation) {
        return this.scopes.computeIfAbsent(scopeAnnotation.getName(), s -> {
            Qualifier qualifier = Qualifiers.byTypeArguments(scopeAnnotation);
            return this.beanLocator.findBean(CustomScope.class, qualifier);
        });
    }

    @Override
    public Optional<CustomScope<?>> findScope(String scopeAnnotation) {
        return this.scopes.computeIfAbsent(scopeAnnotation, type -> {
            Qualifier qualifier = Qualifiers.byExactTypeArgumentName(scopeAnnotation);
            return this.beanLocator.findBean(CustomScope.class, qualifier);
        });
    }
}

