/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.annotation.EnvironmentAnnotationValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
final class EnvironmentConvertibleValuesMap<V>
extends ConvertibleValuesMap<V> {
    private final Environment environment;

    EnvironmentConvertibleValuesMap(Map<? extends CharSequence, V> map, Environment environment) {
        super(map, (ConversionService)environment);
        this.environment = environment;
    }

    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        return this.get(name, ConversionContext.of(requiredType));
    }

    public <T> Optional<T> get(CharSequence name, Argument<T> requiredType) {
        return this.get(name, ConversionContext.of(requiredType));
    }

    public <T> T get(CharSequence name, Class<T> requiredType, T defaultValue) {
        return this.get(name, ConversionContext.of(requiredType)).orElse(defaultValue);
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.map.get(name);
        if (value instanceof AnnotationClassValue) {
            AnnotationClassValue acv = (AnnotationClassValue)value;
            return this.environment.convert(acv, conversionContext);
        }
        if (value instanceof CharSequence) {
            CharSequence sequence = (CharSequence)value;
            PropertyPlaceholderResolver placeholderResolver = this.environment.getPlaceholderResolver();
            String str = this.doResolveIfNecessary(sequence, placeholderResolver);
            return this.environment.convert(str, conversionContext);
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            PropertyPlaceholderResolver placeholderResolver = this.environment.getPlaceholderResolver();
            String[] resolved = (String[])Arrays.stream(values).flatMap(val -> placeholderResolver.resolveOptionalPlaceholder((String)val, String[].class).map(Arrays::stream).orElseGet(() -> Stream.of(this.doResolveIfNecessary((CharSequence)val, placeholderResolver)))).toArray(String[]::new);
            return this.environment.convert(resolved, conversionContext);
        }
        if (value instanceof AnnotationValue[]) {
            AnnotationValue[] annotationValues = (AnnotationValue[])value;
            AnnotationValue[] b = new AnnotationValue[annotationValues.length];
            for (int i = 0; i < annotationValues.length; ++i) {
                AnnotationValue annotationValue = annotationValues[i];
                b[i] = new EnvironmentAnnotationValue(this.environment, annotationValue);
            }
            return this.environment.convert(b, conversionContext);
        }
        if (value instanceof AnnotationValue) {
            EnvironmentAnnotationValue av = (EnvironmentAnnotationValue)((Object)value);
            av = new EnvironmentAnnotationValue(this.environment, av);
            return this.environment.convert((Object)av, (ArgumentConversionContext)conversionContext);
        }
        return super.get(name, conversionContext);
    }

    public Collection<V> values() {
        return super.values().stream().map(v -> {
            if (v instanceof CharSequence) {
                v = this.environment.getPlaceholderResolver().resolveRequiredPlaceholders(v.toString());
            }
            return v;
        }).toList();
    }

    private String doResolveIfNecessary(CharSequence value, PropertyPlaceholderResolver placeholderResolver) {
        String str = value.toString();
        if (str.contains(placeholderResolver.getPrefix())) {
            str = placeholderResolver.resolveRequiredPlaceholders(str);
        }
        return str;
    }

    static <T> ConvertibleValues<T> of(Environment environment, Map<? extends CharSequence, T> values) {
        if (values == null) {
            return ConvertibleValuesMap.empty();
        }
        return new EnvironmentConvertibleValuesMap<T>(values, environment);
    }
}

