/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import io.micronaut.inject.qualifiers.QualifierUtils;
import java.lang.annotation.Annotation;

@Internal
class AnnotationQualifier<T>
extends FilteringQualifier<T> {
    final Annotation annotation;
    private String qualifiedName;
    private String annotationSimpleName;

    AnnotationQualifier(Annotation annotation) {
        this.annotation = annotation;
        this.qualifiedName = annotation.annotationType().getName();
        this.annotationSimpleName = annotation.annotationType().getSimpleName();
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        if (!QualifierUtils.matchType(beanType, candidate)) {
            return false;
        }
        if (QualifierUtils.matchAny(beanType, candidate)) {
            return true;
        }
        if (candidate.getAnnotationMetadata().hasDeclaredAnnotation(this.qualifiedName)) {
            return true;
        }
        return QualifierUtils.matchByCandidateName(candidate, beanType, this.annotationSimpleName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return QualifierUtils.annotationQualifiersEquals(this, o);
    }

    public int hashCode() {
        return this.annotation.hashCode();
    }

    public String toString() {
        return "@" + this.annotation.annotationType().getSimpleName();
    }
}

