/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import io.micronaut.inject.qualifiers.QualifierUtils;
import java.util.Objects;

@Internal
final class NamedAnnotationStereotypeQualifier<T>
extends FilteringQualifier<T> {
    final String stereotype;

    NamedAnnotationStereotypeQualifier(String stereotype) {
        this.stereotype = Objects.requireNonNull(stereotype, "Stereotype cannot be null");
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        return candidate.getAnnotationMetadata().hasStereotype(this.stereotype);
    }

    public String toString() {
        return "@" + this.stereotype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return QualifierUtils.annotationQualifiersEquals(this, o);
    }

    public int hashCode() {
        return this.stereotype.hashCode();
    }
}

