/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Any;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.AnnotationMetadataQualifier;
import io.micronaut.inject.qualifiers.AnnotationQualifier;
import io.micronaut.inject.qualifiers.AnnotationStereotypeQualifier;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.ClosestTypeArgumentQualifier;
import io.micronaut.inject.qualifiers.CompositeQualifier;
import io.micronaut.inject.qualifiers.ExactTypeArgumentNameQualifier;
import io.micronaut.inject.qualifiers.FilteringCompositeQualifier;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import io.micronaut.inject.qualifiers.InterceptorBindingQualifier;
import io.micronaut.inject.qualifiers.NameQualifier;
import io.micronaut.inject.qualifiers.NamedAnnotationStereotypeQualifier;
import io.micronaut.inject.qualifiers.NoneQualifier;
import io.micronaut.inject.qualifiers.PrimaryQualifier;
import io.micronaut.inject.qualifiers.QualifierUtils;
import io.micronaut.inject.qualifiers.RepeatableAnnotationQualifier;
import io.micronaut.inject.qualifiers.TypeAnnotationQualifier;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class Qualifiers {
    public static <T> Qualifier<T> any() {
        return AnyQualifier.INSTANCE;
    }

    public static <T> Qualifier<T> none() {
        return NoneQualifier.INSTANCE;
    }

    @Nullable
    public static <T> Qualifier<T> forArgument(@NonNull Argument<?> argument) {
        List qualifierTypes;
        AnnotationMetadata annotationMetadata = Objects.requireNonNull(argument, "Argument cannot be null").getAnnotationMetadata();
        boolean hasMetadata = annotationMetadata != AnnotationMetadata.EMPTY_METADATA;
        List list = qualifierTypes = hasMetadata ? AnnotationUtil.findQualifierAnnotationsNames((AnnotationMetadata)annotationMetadata) : null;
        if (CollectionUtils.isNotEmpty((Collection)qualifierTypes)) {
            if (qualifierTypes.size() == 1) {
                return Qualifiers.byAnnotation(annotationMetadata, (String)qualifierTypes.iterator().next());
            }
            Qualifier[] qualifiers = new Qualifier[qualifierTypes.size()];
            int i = 0;
            for (String type : qualifierTypes) {
                qualifiers[i++] = Qualifiers.byAnnotation(annotationMetadata, type);
            }
            return Qualifiers.byQualifiers(qualifiers);
        }
        return null;
    }

    public static <T> Qualifier<T> byQualifiers(Qualifier<T> ... qualifiers) {
        FilteringQualifier[] filteringQualifiers = new FilteringQualifier[qualifiers.length];
        for (int i = 0; i < qualifiers.length; ++i) {
            FilteringQualifier filteringQualifier;
            Qualifier<T> qualifier = qualifiers[i];
            if (!(qualifier instanceof FilteringQualifier)) {
                return new CompositeQualifier<T>(qualifiers);
            }
            filteringQualifiers[i] = filteringQualifier = (FilteringQualifier)qualifier;
        }
        return new FilteringCompositeQualifier(filteringQualifiers);
    }

    public static <T> Qualifier<T> byName(String name) {
        return new NameQualifier(null, name);
    }

    @Nullable
    public static String findName(@NonNull Qualifier<?> qualifier) {
        String name;
        Qualifier compositeQualifier;
        if (qualifier instanceof NameQualifier) {
            NameQualifier nameQualifier = (NameQualifier)qualifier;
            return nameQualifier.getName();
        }
        if (qualifier instanceof CompositeQualifier) {
            compositeQualifier = (CompositeQualifier)qualifier;
            for (Qualifier qualifier2 : ((CompositeQualifier)compositeQualifier).getQualifiers()) {
                name = Qualifiers.findName(qualifier2);
                if (name == null) continue;
                return name;
            }
        }
        if (qualifier instanceof FilteringCompositeQualifier) {
            compositeQualifier = (FilteringCompositeQualifier)qualifier;
            for (Qualifier qualifier3 : ((FilteringCompositeQualifier)compositeQualifier).getQualifiers()) {
                name = Qualifiers.findName(qualifier3);
                if (name == null) continue;
                return name;
            }
        }
        return null;
    }

    public static <T> Qualifier<T> byNamePrefix(String prefix) {
        return new PrefixQualifier(prefix);
    }

    public static <T> Qualifier<T> byAnnotation(Annotation annotation) {
        Qualifier<T> qualifier = Qualifiers.findCustomByType(AnnotationMetadata.EMPTY_METADATA, annotation.annotationType());
        if (qualifier != null) {
            return qualifier;
        }
        return new AnnotationQualifier(annotation);
    }

    public static <T> Qualifier<T> byAnnotation(AnnotationMetadata metadata, Class<? extends Annotation> type) {
        Qualifier<T> instance = Qualifiers.findCustomByType(metadata, type);
        if (instance != null) {
            return instance;
        }
        return AnnotationMetadataQualifier.fromType(metadata, type);
    }

    public static <T> Qualifier<T> byAnnotation(AnnotationMetadata metadata, String type) {
        Qualifier<T> qualifier = Qualifiers.findCustomByName(metadata, type);
        if (qualifier != null) {
            return qualifier;
        }
        return AnnotationMetadataQualifier.fromTypeName(metadata, type);
    }

    public static <T extends Annotation> Qualifier<T> byAnnotation(AnnotationMetadata metadata, AnnotationValue<T> annotationValue) {
        Qualifier<T> qualifier = Qualifiers.findCustomByName(metadata, annotationValue.getAnnotationName());
        if (qualifier != null) {
            return qualifier;
        }
        return AnnotationMetadataQualifier.fromValue(metadata, annotationValue);
    }

    public static <T> Qualifier<T> byRepeatableAnnotation(AnnotationMetadata metadata, String repeatableType) {
        return new RepeatableAnnotationQualifier(metadata, repeatableType);
    }

    @Internal
    public static <T> Qualifier<T> byAnnotationSimple(AnnotationMetadata metadata, String type) {
        Qualifier<T> qualifier = Qualifiers.findCustomByName(metadata, type);
        if (qualifier != null) {
            return qualifier;
        }
        return AnnotationMetadataQualifier.fromTypeName(metadata, type);
    }

    public static <T> Qualifier<T> byStereotype(Class<? extends Annotation> stereotype) {
        Qualifier<T> instance = Qualifiers.findCustomByType(AnnotationMetadata.EMPTY_METADATA, stereotype);
        if (instance != null) {
            return instance;
        }
        return new AnnotationStereotypeQualifier(stereotype);
    }

    public static <T> Qualifier<T> byStereotype(String stereotype) {
        Qualifier<T> qualifier = Qualifiers.findCustomByName(AnnotationMetadata.EMPTY_METADATA, stereotype);
        if (qualifier != null) {
            return qualifier;
        }
        return new NamedAnnotationStereotypeQualifier(stereotype);
    }

    public static <T> Qualifier<T> byTypeArguments(Class<?> ... typeArguments) {
        return new TypeArgumentQualifier(typeArguments);
    }

    @NonNull
    public static <T> Qualifier<T> byExactTypeArgumentName(@NonNull String typeName) {
        return new ExactTypeArgumentNameQualifier(typeName);
    }

    public static <T> Qualifier<T> byTypeArgumentsClosest(Class<?> ... typeArguments) {
        return new ClosestTypeArgumentQualifier(typeArguments);
    }

    public static <T> Qualifier<T> byType(Class<?> ... typeArguments) {
        return new TypeAnnotationQualifier(typeArguments);
    }

    @NonNull
    public static <T> Qualifier<T> byInterceptorBinding(@NonNull AnnotationMetadata annotationMetadata) {
        return new InterceptorBindingQualifier(annotationMetadata);
    }

    @NonNull
    public static <T> Qualifier<T> byInterceptorBindingValues(@NonNull Collection<AnnotationValue<?>> binding) {
        return new InterceptorBindingQualifier(binding);
    }

    @Nullable
    private static <T> Qualifier<T> findCustomByType(@NonNull AnnotationMetadata metadata, @NonNull Class<? extends Annotation> type) {
        Optional value;
        if (Any.class == type) {
            return AnyQualifier.INSTANCE;
        }
        if (Primary.class == type) {
            return PrimaryQualifier.INSTANCE;
        }
        if (Type.class == type) {
            Optional aClass = metadata.classValue(type);
            if (aClass.isPresent()) {
                return Qualifiers.byType((Class)aClass.get());
            }
        } else if (Named.class == type && (value = metadata.stringValue(type)).isPresent()) {
            return Qualifiers.byName((String)value.get());
        }
        return null;
    }

    @Nullable
    private static <T> Qualifier<T> findCustomByName(@NonNull AnnotationMetadata metadata, @NonNull String type) {
        if (Type.NAME.equals(type)) {
            Optional aClass = metadata.classValue(type);
            if (aClass.isPresent()) {
                return Qualifiers.byType((Class)aClass.get());
            }
        } else {
            String n;
            if (Any.NAME.equals(type)) {
                return AnyQualifier.INSTANCE;
            }
            if (Qualifier.PRIMARY.equals(type)) {
                return PrimaryQualifier.INSTANCE;
            }
            if (Named.class.getName().equals(type) && (n = (String)metadata.stringValue(type).orElse(null)) != null) {
                return Qualifiers.byName(n);
            }
        }
        return null;
    }

    private record PrefixQualifier<T>(String prefix) implements Qualifier<T>
    {
        @Override
        public <B extends BeanType<T>> Stream<B> reduce(Class<T> beanType, Stream<B> candidates) {
            return candidates.filter(candidate -> {
                if (!QualifierUtils.matchType(beanType, candidate)) {
                    return false;
                }
                if (QualifierUtils.matchAny(beanType, candidate)) {
                    return true;
                }
                String name = candidate.getBeanName().orElse(null);
                return name != null && name.startsWith(this.prefix);
            });
        }
    }
}

