/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

@Internal
public final class AnnotationReflectionUtils {
    private AnnotationReflectionUtils() {
    }

    @Nullable
    public static <T> Argument<T> resolveGenericToArgument(@NonNull Class<?> runtimeGenericType, @NonNull Class<T> rawSuperType) {
        AnnotatedType st;
        if (ClassUtils.REFLECTION_LOGGER.isDebugEnabled()) {
            ClassUtils.REFLECTION_LOGGER.debug("Reflectively finding a generic argument of '{}' from the implementation '{}'", rawSuperType, runtimeGenericType);
        }
        if ((st = AnnotationReflectionUtils.findAnnotatedSupertype(new SimpleAnnotatedType(runtimeGenericType), rawSuperType)) == null) {
            return null;
        }
        return AnnotationReflectionUtils.toArgument(st);
    }

    @Nullable
    private static AnnotatedType findAnnotatedSupertype(AnnotatedType subType, Class<?> superType) {
        List<AnnotatedType> candidates;
        Class<?> raw = AnnotationReflectionUtils.getRawType(subType.getType());
        if (superType == raw) {
            return subType;
        }
        if (!superType.isAssignableFrom(raw)) {
            return null;
        }
        HashMap substitutions = new HashMap();
        AnnotationReflectionUtils.collectTypeSubstitutions(subType, substitutions);
        Stream<AnnotatedType> supertypes = AnnotationReflectionUtils.getSupertypes(raw);
        if (!substitutions.isEmpty()) {
            supertypes = supertypes.map(t -> new LazySubstitutingType((AnnotatedType)t, substitutions));
        }
        if ((candidates = supertypes.map(at -> AnnotationReflectionUtils.findAnnotatedSupertype(at, superType)).filter(Objects::nonNull).toList()).isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        return new MergedAnnotatedType(candidates.get(0), candidates);
    }

    private static void collectTypeSubstitutions(AnnotatedType type, Map<TypeVariable<?>, AnnotatedType> substitutions) {
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedType annotatedType;
            AnnotatedType[] args;
            AnnotatedParameterizedType apt = (AnnotatedParameterizedType)type;
            TypeVariable<Class<?>>[] variables = AnnotationReflectionUtils.getRawType(type.getType()).getTypeParameters();
            if (variables.length == (args = apt.getAnnotatedActualTypeArguments()).length) {
                for (int i = 0; i < args.length; ++i) {
                    substitutions.put(variables[i], args[i]);
                }
            }
            if ((annotatedType = apt.getAnnotatedOwnerType()) instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType owner = (AnnotatedParameterizedType)annotatedType;
                AnnotationReflectionUtils.collectTypeSubstitutions(owner, substitutions);
            }
        } else if (type instanceof LazySubstitutingType) {
            LazySubstitutingType lst = (LazySubstitutingType)type;
            HashMap intermediate = new HashMap();
            AnnotationReflectionUtils.collectTypeSubstitutions(lst.actual, intermediate);
            intermediate.replaceAll((k, v) -> new LazySubstitutingType((AnnotatedType)v, lst.substitutions));
            substitutions.putAll(intermediate);
        } else if (type instanceof MergedAnnotatedType) {
            MergedAnnotatedType mat = (MergedAnnotatedType)type;
            AnnotationReflectionUtils.collectTypeSubstitutions(mat.actual, substitutions);
        } else {
            AnnotationReflectionUtils.collectTypeSubstitutions(type.getType(), substitutions);
        }
    }

    private static void collectTypeSubstitutions(Type type, Map<TypeVariable<?>, AnnotatedType> substitutions) {
        Type[] args;
        ParameterizedType pt;
        TypeVariable<Class<?>>[] variables;
        if (type instanceof ParameterizedType && (variables = AnnotationReflectionUtils.getRawType((pt = (ParameterizedType)type).getRawType()).getTypeParameters()).length == (args = pt.getActualTypeArguments()).length) {
            for (int i = 0; i < args.length; ++i) {
                substitutions.put(variables[i], new SimpleAnnotatedType(args[i]));
            }
        }
    }

    private static AnnotationMetadata annotationMetadataOf(AnnotatedElement annotatedElement) {
        Annotation[] annotations = annotatedElement.getAnnotations();
        if (annotations.length == 0) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        MutableAnnotationMetadata mutableAnnotationMetadata = new MutableAnnotationMetadata();
        for (Annotation annotation : annotations) {
            Method[] methods;
            LinkedHashMap<CharSequence, Object> values = new LinkedHashMap<CharSequence, Object>();
            Class<? extends Annotation> annotationType = annotation.annotationType();
            for (Method method : methods = annotationType.getMethods()) {
                Object value;
                if (!method.getDeclaringClass().equals(annotationType) || (value = ReflectionUtils.invokeMethod((Object)annotation, (Method)method, (Object[])new Object[0])) == null) continue;
                values.put(method.getName(), value);
            }
            mutableAnnotationMetadata.addAnnotation(annotationType.getName(), values);
        }
        return mutableAnnotationMetadata;
    }

    private static Argument<?> toArgument(AnnotatedType annotatedType) {
        return AnnotationReflectionUtils.toArgument(null, annotatedType, Map.of());
    }

    private static Argument<?> toArgument(@Nullable String name, AnnotatedType annotatedType, Map<TypeVariable<?>, AnnotatedType> substitutions) {
        if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType apt = (AnnotatedParameterizedType)annotatedType;
            Class<?> rawType = AnnotationReflectionUtils.getRawType(apt.getType());
            TypeVariable<Class<?>>[] variables = rawType.getTypeParameters();
            Argument[] typeArgs = new Argument[apt.getAnnotatedActualTypeArguments().length];
            for (int i = 0; i < typeArgs.length; ++i) {
                typeArgs[i] = AnnotationReflectionUtils.toArgument(variables.length > i ? variables[i].getName() : null, apt.getAnnotatedActualTypeArguments()[i], substitutions);
            }
            return Argument.of(AnnotationReflectionUtils.getRawType(apt.getType()), (String)name, (AnnotationMetadata)AnnotationReflectionUtils.annotationMetadataOf(apt), (Argument[])typeArgs);
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            AnnotatedArrayType aat = (AnnotatedArrayType)annotatedType;
            Argument<?> component = AnnotationReflectionUtils.toArgument(null, aat.getAnnotatedGenericComponentType(), substitutions);
            AnnotationMetadata componentAnnotations = component.getAnnotationMetadata();
            AnnotationMetadata ourAnnotations = AnnotationReflectionUtils.annotationMetadataOf(aat);
            AnnotationMetadata combined = AnnotationReflectionUtils.combine(componentAnnotations, ourAnnotations);
            return Argument.of(Array.newInstance(component.getType(), 0).getClass(), (String)name, (AnnotationMetadata)combined, (Argument[])new Argument[0]);
        }
        if (annotatedType instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType awt = (AnnotatedWildcardType)annotatedType;
            Argument<?> upper = AnnotationReflectionUtils.toArgument(null, awt.getAnnotatedUpperBounds()[0], substitutions);
            return Argument.of((Class)upper.getType(), (String)name, (AnnotationMetadata)AnnotationReflectionUtils.combine(upper.getAnnotationMetadata(), AnnotationReflectionUtils.annotationMetadataOf(annotatedType)), (Argument[])upper.getTypeParameters());
        }
        if (annotatedType instanceof LazySubstitutingType) {
            Map<TypeVariable<?>, AnnotatedType> newSubstitutions;
            LazySubstitutingType lst = (LazySubstitutingType)annotatedType;
            if (substitutions.isEmpty()) {
                newSubstitutions = lst.substitutions;
            } else {
                newSubstitutions = new HashMap();
                newSubstitutions.putAll(substitutions);
                newSubstitutions.putAll(lst.substitutions);
            }
            return AnnotationReflectionUtils.toArgument(name, lst.actual, newSubstitutions);
        }
        if (annotatedType instanceof MergedAnnotatedType) {
            MergedAnnotatedType mat = (MergedAnnotatedType)annotatedType;
            Argument<?> argument = AnnotationReflectionUtils.toArgument(null, mat.actual, substitutions);
            return Argument.of((Class)argument.getType(), (String)name, (AnnotationMetadata)AnnotationReflectionUtils.combine(argument.getAnnotationMetadata(), AnnotationReflectionUtils.annotationMetadataOf(mat)), (Argument[])argument.getTypeParameters());
        }
        Argument<?> simple = AnnotationReflectionUtils.toArgument(null, annotatedType.getType(), substitutions);
        AnnotationMetadata annotations = AnnotationReflectionUtils.annotationMetadataOf(annotatedType);
        return Argument.of((Class)simple.getType(), (String)name, (AnnotationMetadata)AnnotationReflectionUtils.combine(annotations, simple.getAnnotationMetadata()), (Argument[])simple.getTypeParameters());
    }

    private static Argument<?> toArgument(@Nullable String name, Type type, Map<TypeVariable<?>, AnnotatedType> substitutions) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Class<?> rawType = AnnotationReflectionUtils.getRawType(pt.getRawType());
            TypeVariable<Class<?>>[] variables = rawType.getTypeParameters();
            Argument[] typeArgs = new Argument[pt.getActualTypeArguments().length];
            for (int i = 0; i < typeArgs.length; ++i) {
                typeArgs[i] = AnnotationReflectionUtils.toArgument(variables.length > i ? variables[i].getName() : null, pt.getActualTypeArguments()[i], substitutions);
            }
            return Argument.of(rawType, (Argument[])typeArgs);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Argument<?> component = AnnotationReflectionUtils.toArgument(null, gat.getGenericComponentType(), substitutions);
            return Argument.of(Array.newInstance(component.getType(), 0).getClass(), (String)name, (AnnotationMetadata)component.getAnnotationMetadata(), (Argument[])new Argument[0]);
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return AnnotationReflectionUtils.toArgument(name, wt.getUpperBounds()[0], substitutions);
        }
        if (type instanceof Class) {
            Class cl = (Class)type;
            return Argument.of((Class)cl, (String)name);
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            AnnotatedType sub = substitutions.get(tv);
            if (sub == null) {
                return AnnotationReflectionUtils.toArgument(name, tv.getAnnotatedBounds()[0], Map.of());
            }
            return AnnotationReflectionUtils.toArgument(name, sub, Map.of());
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    private static AnnotationMetadata combine(AnnotationMetadata left, AnnotationMetadata right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        return new AnnotationMetadataHierarchy(true, left, right);
    }

    private static Stream<AnnotatedType> getSupertypes(Class<?> cl) {
        Stream<AnnotatedType> itf = Stream.of(cl.getAnnotatedInterfaces());
        if (cl.isInterface()) {
            return itf;
        }
        return Stream.concat(Stream.of(cl.getAnnotatedSuperclass()), itf);
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            return cl;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return AnnotationReflectionUtils.getRawType(ptype.getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return AnnotationReflectionUtils.getRawType(tv.getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return AnnotationReflectionUtils.getRawType(wt.getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Class<?> rawComponentType = AnnotationReflectionUtils.getRawType(gat.getGenericComponentType());
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    private record SimpleAnnotatedType(Type actual) implements AnnotatedType
    {
        @Override
        public Type getType() {
            return this.actual;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }
    }

    private record MergedAnnotatedType(AnnotatedType actual, List<AnnotatedType> annotationSources) implements AnnotatedType
    {
        @Override
        public Type getType() {
            return this.actual.getType();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)((Annotation)this.annotationSources.stream().map(s -> s.getAnnotation(annotationClass)).filter(Objects::nonNull).findFirst().orElse(null));
        }

        @Override
        public Annotation[] getAnnotations() {
            return (Annotation[])this.annotationSources.stream().flatMap(s -> Arrays.stream(s.getAnnotations())).toArray(Annotation[]::new);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return (Annotation[])this.annotationSources.stream().flatMap(s -> Arrays.stream(s.getDeclaredAnnotations())).toArray(Annotation[]::new);
        }
    }

    private record LazySubstitutingType(AnnotatedType actual, Map<TypeVariable<?>, AnnotatedType> substitutions) implements AnnotatedType
    {
        @Override
        public Type getType() {
            return this.actual.getType();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.actual.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.actual.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.actual.getDeclaredAnnotations();
        }
    }
}

