/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.EnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public final class AnnotationMetadataHierarchy
implements AnnotationMetadata,
EnvironmentAnnotationMetadata,
Iterable<AnnotationMetadata> {
    public static final AnnotationMetadata[] EMPTY_HIERARCHY = new AnnotationMetadata[]{AnnotationMetadata.EMPTY_METADATA, AnnotationMetadata.EMPTY_METADATA};
    private final AnnotationMetadata[] hierarchy;
    private final boolean delegateDeclaredToAllElements;

    public AnnotationMetadataHierarchy(AnnotationMetadata ... hierarchy) {
        this(false, hierarchy);
    }

    @Internal
    public AnnotationMetadataHierarchy(boolean delegateDeclaredToAllElements, AnnotationMetadata ... hierarchy) {
        this.delegateDeclaredToAllElements = delegateDeclaredToAllElements;
        if (ArrayUtils.isNotEmpty((Object[])hierarchy)) {
            ArrayUtils.reverse((Object[])hierarchy);
            this.hierarchy = hierarchy;
        } else {
            this.hierarchy = EMPTY_HIERARCHY;
        }
    }

    private AnnotationMetadataHierarchy(AnnotationMetadata[] existing, AnnotationMetadata newChild) {
        this.hierarchy = new AnnotationMetadata[existing.length];
        System.arraycopy(existing, 0, this.hierarchy, 0, existing.length);
        this.hierarchy[0] = newChild;
        this.delegateDeclaredToAllElements = false;
    }

    @Override
    public boolean hasPropertyExpressions() {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasPropertyExpressions()) continue;
            return true;
        }
        return false;
    }

    public boolean hasEvaluatedExpressions() {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasEvaluatedExpressions()) continue;
            return true;
        }
        return false;
    }

    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name) {
        for (AnnotationMetadata metadata : this.hierarchy) {
            Optional annotationType = metadata.getAnnotationType(name);
            if (!annotationType.isPresent()) continue;
            return annotationType;
        }
        return Optional.empty();
    }

    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name, @NonNull ClassLoader classLoader) {
        for (AnnotationMetadata metadata : this.hierarchy) {
            Optional annotationType = metadata.getAnnotationType(name, classLoader);
            if (!annotationType.isPresent()) continue;
            return annotationType;
        }
        return Optional.empty();
    }

    @NonNull
    public AnnotationMetadata getDeclaredMetadata() {
        return this.hierarchy[0];
    }

    @NonNull
    public AnnotationMetadata getRootMetadata() {
        return this.hierarchy[this.hierarchy.length - 1];
    }

    @NonNull
    public AnnotationMetadata createSibling(@NonNull AnnotationMetadata child) {
        if (this.hierarchy.length > 1) {
            return new AnnotationMetadataHierarchy(this.hierarchy, child);
        }
        return child;
    }

    @Nullable
    public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass, @NonNull String sourceAnnotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Annotation a = annotationMetadata.synthesize(annotationClass, sourceAnnotation);
            if (a == null) continue;
            return (T)a;
        }
        return null;
    }

    public Annotation[] synthesizeAll() {
        return (Annotation[])Stream.of(this.hierarchy).flatMap(am -> Arrays.stream(am.synthesizeAll())).toArray(Annotation[]::new);
    }

    public Annotation[] synthesizeDeclared() {
        return (Annotation[])Stream.of(this.hierarchy).flatMap(am -> Arrays.stream(am.synthesizeDeclared())).toArray(Annotation[]::new);
    }

    public <T extends Annotation> T[] synthesizeAnnotationsByType(Class<T> annotationClass) {
        if (annotationClass == null) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        return (Annotation[])Stream.of(this.hierarchy).flatMap(am -> am.getAnnotationValuesByType(annotationClass).stream()).distinct().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, entries)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
    }

    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(Class<T> annotationClass) {
        if (annotationClass == null) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        return (Annotation[])Stream.of(this.hierarchy).flatMap(am -> am.getAnnotationValuesByType(annotationClass).stream()).distinct().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, entries)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
    }

    @Nullable
    public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass, @NonNull String sourceAnnotation) {
        return (T)this.hierarchy[0].synthesize(annotationClass, sourceAnnotation);
    }

    @Nullable
    public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Annotation a = annotationMetadata.synthesize(annotationClass);
            if (a == null) continue;
            return (T)a;
        }
        return null;
    }

    @Nullable
    public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass) {
        if (this.delegateDeclaredToAllElements) {
            return (T)this.merge().synthesizeDeclared((Class)annotationClass);
        }
        return (T)this.hierarchy[0].synthesize(annotationClass);
    }

    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@NonNull String annotation) {
        AnnotationValue<T> existing = null;
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            existing = this.mergeValue(annotation, existing, annotationMetadata.getAnnotation(annotation));
        }
        return Optional.ofNullable(existing);
    }

    @Nullable
    private <T extends Annotation> AnnotationValue<T> mergeValue(@NonNull String annotation, @Nullable AnnotationValue<T> existingValue, @Nullable AnnotationValue<T> newValue) {
        if (newValue == null) {
            return existingValue;
        }
        if (existingValue == null) {
            return newValue;
        }
        Map values = newValue.getValues();
        Map existing = existingValue.getValues();
        LinkedHashMap newValues = CollectionUtils.newLinkedHashMap((int)(values.size() + existing.size()));
        newValues.putAll(existing);
        for (Map.Entry entry : values.entrySet()) {
            newValues.putIfAbsent((CharSequence)entry.getKey(), entry.getValue());
        }
        Map newDefaults = newValue.getDefaultValues();
        Map existingDefaults = existingValue.getDefaultValues();
        return new AnnotationValue(annotation, (Map)newValues, existingDefaults != null ? existingDefaults : newDefaults);
    }

    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@NonNull String annotation) {
        if (this.delegateDeclaredToAllElements) {
            AnnotationValue<T> existing = null;
            for (AnnotationMetadata annotationMetadata : this.hierarchy) {
                existing = this.mergeValue(annotation, existing, annotationMetadata.getDeclaredAnnotation(annotation));
            }
            return Optional.ofNullable(existing);
        }
        return this.hierarchy[0].findDeclaredAnnotation(annotation);
    }

    @NonNull
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.stringValues(annotation.getName(), member);
    }

    @NonNull
    public String[] stringValues(@NonNull String annotation, @NonNull String member) {
        Object[] values = this.hierarchy[0].stringValues(annotation, member);
        for (int i = 1; i < this.hierarchy.length; ++i) {
            AnnotationMetadata annotationMetadata = this.hierarchy[i];
            Object[] moreValues = annotationMetadata.stringValues(annotation, member);
            if (!ArrayUtils.isNotEmpty((Object[])moreValues)) continue;
            values = (String[])ArrayUtils.concat((Object[])values, (Object[])moreValues);
        }
        return values;
    }

    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.booleanValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public boolean isTrue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata am : this.hierarchy) {
            if (!am.isTrue(annotation, member)) continue;
            return true;
        }
        return false;
    }

    public OptionalLong longValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalLong o = annotationMetadata.longValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalLong.empty();
    }

    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.stringValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public OptionalInt intValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalInt o = annotationMetadata.intValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalInt.empty();
    }

    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    public <E extends Enum<E>> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.enumValue(annotation, member, enumType);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @NonNull
    public <T> Class<T>[] classValues(@NonNull String annotation, @NonNull String member) {
        ArrayList<Class> list = new ArrayList<Class>();
        for (AnnotationMetadata am : this.hierarchy) {
            list.addAll(Arrays.asList(am.classValues(annotation, member)));
        }
        return list.toArray(new Class[0]);
    }

    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.classValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @NonNull
    public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        LinkedHashSet list = new LinkedHashSet();
        for (AnnotationMetadata am : this.hierarchy) {
            list.addAll(am.getAnnotationNamesByStereotype(stereotype));
        }
        return new ArrayList<String>(list);
    }

    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByStereotype(String stereotype) {
        LinkedHashSet list = new LinkedHashSet();
        for (AnnotationMetadata am : this.hierarchy) {
            list.addAll(am.getAnnotationValuesByStereotype(stereotype));
        }
        return new ArrayList<AnnotationValue<T>>(list);
    }

    @NonNull
    public Set<String> getDeclaredAnnotationNames() {
        if (this.delegateDeclaredToAllElements) {
            HashSet<String> set = new HashSet<String>();
            for (AnnotationMetadata am : this.hierarchy) {
                set.addAll(am.getDeclaredAnnotationNames());
            }
            return set;
        }
        return this.hierarchy[0].getDeclaredAnnotationNames();
    }

    @NonNull
    public Set<String> getAnnotationNames() {
        HashSet<String> set = new HashSet<String>();
        for (AnnotationMetadata am : this.hierarchy) {
            set.addAll(am.getAnnotationNames());
        }
        return set;
    }

    @NonNull
    public <T> OptionalValues<T> getValues(@NonNull String annotation, @NonNull Class<T> valueType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalValues values = annotationMetadata.getValues(annotation, valueType);
            if (values.isEmpty()) continue;
            return values;
        }
        return OptionalValues.empty();
    }

    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional defaultValue = annotationMetadata.getDefaultValue(annotation, member, requiredType);
            if (!defaultValue.isPresent()) continue;
            return defaultValue;
        }
        return Optional.empty();
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@NonNull Class<T> annotationType) {
        ArrayList<AnnotationValue<T>> list = new ArrayList<AnnotationValue<T>>(10);
        HashSet<AnnotationValue> uniqueValues = new HashSet<AnnotationValue>(10);
        for (AnnotationMetadata am : this.hierarchy) {
            for (AnnotationValue tAnnotationValue : am.getAnnotationValuesByType(annotationType)) {
                if (!uniqueValues.add(tAnnotationValue)) continue;
                list.add(tAnnotationValue);
            }
        }
        return list;
    }

    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByName(String annotationType) {
        if (annotationType == null) {
            return Collections.emptyList();
        }
        return this.mergeAnnotationValues(annotationType, AnnotationMetadata::getAnnotationValuesByName);
    }

    @NonNull
    private <T extends Annotation, V> List<AnnotationValue<T>> mergeAnnotationValues(V annotationType, BiFunction<AnnotationMetadata, V, List<AnnotationValue<T>>> fn) {
        ArrayList<AnnotationValue<T>> list = new ArrayList<AnnotationValue<T>>(10);
        HashSet<AnnotationValue<T>> uniqueValues = new HashSet<AnnotationValue<T>>(10);
        for (AnnotationMetadata am : this.hierarchy) {
            for (AnnotationValue<T> tAnnotationValue : fn.apply(am, annotationType)) {
                if (!uniqueValues.add(tAnnotationValue)) continue;
                list.add(tAnnotationValue);
            }
        }
        return Collections.unmodifiableList(list);
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@NonNull Class<T> annotationType) {
        if (this.delegateDeclaredToAllElements) {
            return this.mergeAnnotationValues(annotationType, AnnotationMetadata::getDeclaredAnnotationValuesByType);
        }
        return this.hierarchy[0].getDeclaredAnnotationValuesByType(annotationType);
    }

    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByName(String annotationType) {
        if (this.delegateDeclaredToAllElements) {
            return this.mergeAnnotationValues(annotationType, AnnotationMetadata::getDeclaredAnnotationValuesByName);
        }
        return this.hierarchy[0].getDeclaredAnnotationValuesByName(annotationType);
    }

    public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        if (this.delegateDeclaredToAllElements) {
            for (AnnotationMetadata annotationMetadata : this.hierarchy) {
                if (!annotationMetadata.hasDeclaredAnnotation(annotation)) continue;
                return true;
            }
            return false;
        }
        return this.hierarchy[0].hasDeclaredAnnotation(annotation);
    }

    public boolean hasAnnotation(@Nullable String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStereotype(@Nullable String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredStereotype(@Nullable String annotation) {
        if (this.delegateDeclaredToAllElements) {
            for (AnnotationMetadata annotationMetadata : this.hierarchy) {
                if (!annotationMetadata.hasDeclaredStereotype(annotation)) continue;
                return true;
            }
            return false;
        }
        return this.hierarchy[0].hasDeclaredStereotype(annotation);
    }

    public <E extends Enum<E>> Optional<E> enumValue(String annotation, String member, Class<E> enumType) {
        return this.enumValue(annotation, member, enumType, null);
    }

    public <E extends Enum<E>> E[] enumValues(String annotation, String member, Class<E> enumType) {
        return this.enumValues(annotation, member, enumType, null);
    }

    public OptionalInt intValue(Class<? extends Annotation> annotation, String member) {
        return this.intValue(annotation, member, null);
    }

    public boolean isFalse(Class<? extends Annotation> annotation, String member) {
        return this.booleanValue(annotation, member, null).orElse(false) == false;
    }

    @NonNull
    public Map<CharSequence, Object> getDefaultValues(@NonNull String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Map defaultValues = annotationMetadata.getDefaultValues(annotation);
            if (defaultValues.isEmpty()) continue;
            return defaultValues;
        }
        return Collections.emptyMap();
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<E> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.enumValue(annotation, member, enumType, valueMapper);
            } else {
                o = annotationMetadata.enumValue(annotation, member, enumType);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull String annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<E> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.enumValue(annotation, member, enumType, valueMapper);
            } else {
                o = annotationMetadata.enumValue(annotation, member, enumType);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        Object[] values = this.hierarchy[0].enumValues(annotation, member, enumType);
        for (int i = 1; i < this.hierarchy.length; ++i) {
            AnnotationMetadata annotationMetadata = this.hierarchy[i];
            Object[] moreValues = annotationMetadata.enumValues(annotation, member, enumType);
            if (!ArrayUtils.isNotEmpty((Object[])moreValues)) continue;
            values = (Enum[])ArrayUtils.concat((Object[])values, (Object[])moreValues);
        }
        return values;
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull String annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        Object[] values = this.hierarchy[0].enumValues(annotation, member, enumType);
        for (int i = 1; i < this.hierarchy.length; ++i) {
            AnnotationMetadata annotationMetadata = this.hierarchy[i];
            Object[] moreValues = annotationMetadata.enumValues(annotation, member, enumType);
            if (!ArrayUtils.isNotEmpty((Object[])moreValues)) continue;
            values = (Enum[])ArrayUtils.concat((Object[])values, (Object[])moreValues);
        }
        return values;
    }

    @Override
    public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<Class> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.classValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.classValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<Class> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.classValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.classValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalInt o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.intValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.intValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalInt.empty();
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<Boolean> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.booleanValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.booleanValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<Boolean> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.booleanValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.booleanValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public OptionalLong longValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalLong o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.longValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.longValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalLong.empty();
    }

    @Override
    @NonNull
    public OptionalLong longValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalLong o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.longValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.longValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalLong.empty();
    }

    @Override
    @NonNull
    public OptionalInt intValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalInt o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.intValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.intValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalInt.empty();
    }

    public OptionalLong longValue(Class<? extends Annotation> annotation, String member) {
        return this.longValue(annotation, member, null);
    }

    public <E extends Enum<E>> E[] enumValues(Class<? extends Annotation> annotation, String member, Class<E> enumType) {
        return this.enumValues(annotation, member, enumType, null);
    }

    public <T> Class<T>[] classValues(Class<? extends Annotation> annotation, String member) {
        ArrayList<Class> list = new ArrayList<Class>();
        for (AnnotationMetadata am : this.hierarchy) {
            list.addAll(Arrays.asList(am.classValues(annotation, member)));
        }
        return list.toArray(new Class[0]);
    }

    public Optional<Class> classValue(Class<? extends Annotation> annotation, String member) {
        return this.classValue(annotation, member, null);
    }

    public Optional<String> stringValue(Class<? extends Annotation> annotation, String member) {
        return this.stringValue(annotation, member, null);
    }

    public Optional<Boolean> booleanValue(Class<? extends Annotation> annotation, String member) {
        return this.booleanValue(annotation, member, null);
    }

    public boolean isTrue(Class<? extends Annotation> annotation, String member) {
        return this.isTrue(annotation, member, null);
    }

    public boolean isPresent(Class<? extends Annotation> annotation, String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.isPresent(annotation, member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<String> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.stringValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.stringValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArrayList<String> strings = new ArrayList<String>();
        for (AnnotationMetadata am : this.hierarchy) {
            if (am instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)am;
                strings.addAll(Arrays.asList(environmentAnnotationMetadata.stringValues(annotation, member, valueMapper)));
                continue;
            }
            strings.addAll(Arrays.asList(am.stringValues(annotation, member)));
        }
        return strings.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    public String[] stringValues(String annotation, String member, Function<Object, Object> valueMapper) {
        ArrayList<String> strings = new ArrayList<String>();
        for (AnnotationMetadata am : this.hierarchy) {
            if (am instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)am;
                strings.addAll(Arrays.asList(environmentAnnotationMetadata.stringValues(annotation, member, valueMapper)));
                continue;
            }
            strings.addAll(Arrays.asList(am.stringValues(annotation, member)));
        }
        return strings.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    @NonNull
    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<String> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.stringValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.stringValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public boolean isTrue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        return this.booleanValue(annotation, member, valueMapper).orElse(false);
    }

    @Override
    public boolean isTrue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        return this.booleanValue(annotation, member, valueMapper).orElse(false);
    }

    @Override
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.doubleValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.doubleValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    @Override
    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.doubleValue(annotation, member, valueMapper);
            } else {
                o = annotationMetadata.doubleValue(annotation, member);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    @Override
    @NonNull
    public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<T> o;
            if (annotationMetadata instanceof EnvironmentAnnotationMetadata) {
                EnvironmentAnnotationMetadata environmentAnnotationMetadata = (EnvironmentAnnotationMetadata)annotationMetadata;
                o = environmentAnnotationMetadata.getValue(annotation, member, requiredType, valueMapper);
            } else {
                o = annotationMetadata.getValue(annotation, member, requiredType);
            }
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public Iterator<AnnotationMetadata> iterator() {
        return ArrayUtils.reverseIterator((Object[])this.hierarchy);
    }

    public boolean isEmpty() {
        for (AnnotationMetadata metadata : this.hierarchy) {
            if (metadata.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isRepeatableAnnotation(Class<? extends Annotation> annotation) {
        for (AnnotationMetadata metadata : this.hierarchy) {
            if (!metadata.isRepeatableAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean isRepeatableAnnotation(String annotation) {
        for (AnnotationMetadata metadata : this.hierarchy) {
            if (!metadata.isRepeatableAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> findRepeatableAnnotation(Class<? extends Annotation> annotation) {
        for (AnnotationMetadata metadata : this.hierarchy) {
            Optional repeatable = metadata.findRepeatableAnnotation(annotation);
            if (!repeatable.isPresent()) continue;
            return repeatable;
        }
        return Optional.empty();
    }

    public Optional<String> findRepeatableAnnotation(String annotation) {
        for (AnnotationMetadata metadata : this.hierarchy) {
            Optional repeatable = metadata.findRepeatableAnnotation(annotation);
            if (!repeatable.isPresent()) continue;
            return repeatable;
        }
        return Optional.empty();
    }

    public MutableAnnotationMetadata merge() {
        MutableAnnotationMetadata newAnnotationMetadata = new MutableAnnotationMetadata();
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if ((annotationMetadata = annotationMetadata.getTargetAnnotationMetadata()).isEmpty()) continue;
            if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
                AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
                newAnnotationMetadata.addAnnotationMetadata(annotationMetadataHierarchy.merge());
                continue;
            }
            if (annotationMetadata instanceof MutableAnnotationMetadata) {
                MutableAnnotationMetadata mutableAnnotationMetadata = (MutableAnnotationMetadata)annotationMetadata;
                newAnnotationMetadata.addAnnotationMetadata(mutableAnnotationMetadata);
                continue;
            }
            if (annotationMetadata instanceof DefaultAnnotationMetadata) {
                DefaultAnnotationMetadata defaultAnnotationMetadata = (DefaultAnnotationMetadata)annotationMetadata;
                newAnnotationMetadata.addAnnotationMetadata(defaultAnnotationMetadata);
                continue;
            }
            throw new IllegalStateException("Unknown instance of AnnotationMetadata: " + annotationMetadata.getClass());
        }
        return newAnnotationMetadata;
    }

    public AnnotationMetadata copyAnnotationMetadata() {
        Object[] copy = new AnnotationMetadata[this.hierarchy.length];
        System.arraycopy(this.hierarchy, 0, copy, 0, this.hierarchy.length);
        ArrayUtils.reverse((Object[])copy);
        return new AnnotationMetadataHierarchy(this.delegateDeclaredToAllElements, (AnnotationMetadata[])Arrays.stream(copy).map(AnnotationMetadata::copyAnnotationMetadata).toArray(AnnotationMetadata[]::new));
    }

    public int size() {
        return this.hierarchy.length;
    }
}

