/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;

@Internal
public abstract class FilteringQualifier<T>
implements Qualifier<T> {
    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> this.doesQualify(beanType, candidate));
    }

    @Override
    public boolean doesQualify(Class<T> beanType, Collection<? extends BeanType<T>> candidates) {
        for (BeanType<T> candidate : candidates) {
            if (!this.doesQualify(beanType, candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <BT extends BeanType<T>> Collection<BT> filter(Class<T> beanType, Collection<BT> candidates) {
        int size = candidates.size();
        if (size == 1) {
            return this.doesQualify(beanType, (BeanType)candidates.iterator().next()) ? candidates : Collections.emptyList();
        }
        ArrayList<BeanType> result = new ArrayList<BeanType>(size);
        for (BeanType candidate : candidates) {
            if (!this.doesQualify(beanType, candidate)) continue;
            result.add(candidate);
        }
        return result;
    }
}

