/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.Internal;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@Internal
public record MatchesPresenceOfEntitiesCondition(AnnotationClassValue<?>[] classes) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            for (AnnotationClassValue<?> classValue : this.classes) {
                Class annotationType;
                Optional entityType = classValue.getType();
                if (entityType.isEmpty()) {
                    context.fail("Annotation type [" + classValue.getName() + "] not present on classpath");
                    return false;
                }
                Environment environment = applicationContext.getEnvironment();
                if (!environment.scan(annotationType = (Class)entityType.get()).findFirst().isEmpty()) continue;
                context.fail("No entities found in packages [" + String.join((CharSequence)", ", environment.getPackages()) + "] for annotation: " + annotationType);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesPresenceOfEntitiesCondition that = (MatchesPresenceOfEntitiesCondition)o;
        return Objects.deepEquals(this.classes, that.classes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.classes);
    }

    @Override
    public String toString() {
        return "MatchesPresenceOfEntitiesCondition{classes=" + Arrays.toString(this.classes) + "}";
    }
}

