/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Optional;

@Internal
public final class AnnotationConvertersRegistrar
implements TypeConverterRegistrar {
    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(AnnotationValue.class, Annotation.class, (object, targetType, context) -> {
            Class aClass = ClassUtils.forName((String)object.getAnnotationName(), (ClassLoader)targetType.getClassLoader()).orElse(null);
            if (aClass != null) {
                return Optional.of(AnnotationMetadataSupport.buildAnnotation(aClass, object));
            }
            return Optional.empty();
        });
        conversionService.addConverter(AnnotationValue[].class, Object[].class, (object, targetType, context) -> {
            ArrayList result = new ArrayList();
            Class annotationClass = null;
            for (AnnotationValue annotationValue : object) {
                if (annotationClass == null) {
                    Class aClass = ClassUtils.forName((String)annotationValue.getAnnotationName(), (ClassLoader)targetType.getClassLoader()).orElse(null);
                    if (aClass == null) break;
                    annotationClass = aClass;
                }
                Object annotation = AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
                result.add(annotation);
            }
            if (!result.isEmpty()) {
                return Optional.of(result.toArray((Object[])Array.newInstance(annotationClass, result.size())));
            }
            return Optional.empty();
        });
    }
}

